/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.model.constraint;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.xcmis.search.QueryObjectModelVisitor;
import org.xcmis.search.VisitException;
import org.xcmis.search.Visitors;
import org.xcmis.search.model.constraint.Constraint;
import org.xcmis.search.model.source.SelectorName;

public class FullTextSearch
extends Constraint {
    private static final long serialVersionUID = 565310580065900807L;
    private final String fullTextSearchExpression;
    private final String propertyName;
    private final SelectorName selectorName;
    private final int hcode;

    public FullTextSearch(SelectorName selectorName, String propertyName, String fullTextSearchExpression) {
        Validate.notNull((Object)selectorName, (String)"The selectorName argument may not be null");
        Validate.notEmpty((String)fullTextSearchExpression, (String)" The fullTextSearchExpression argument may not be empty");
        this.selectorName = selectorName;
        this.propertyName = propertyName;
        this.fullTextSearchExpression = fullTextSearchExpression;
        this.hcode = new HashCodeBuilder().append((Object)selectorName).append((Object)fullTextSearchExpression).append((Object)propertyName).toHashCode();
    }

    @Override
    public void accept(QueryObjectModelVisitor visitor) throws VisitException {
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        FullTextSearch rhs = (FullTextSearch)obj;
        return new EqualsBuilder().append((Object)this.selectorName, (Object)rhs.selectorName).append((Object)this.fullTextSearchExpression, (Object)rhs.fullTextSearchExpression).append((Object)this.propertyName, (Object)rhs.propertyName).isEquals();
    }

    public final String getFullTextSearchExpression() {
        return this.fullTextSearchExpression;
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    public final SelectorName getSelectorName() {
        return this.selectorName;
    }

    public int hashCode() {
        return this.hcode;
    }

    public String toString() {
        return Visitors.readable(this);
    }
}

