/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.audit;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.util.TraversingItemVisitor;
import org.exoplatform.services.jcr.ext.audit.AuditService;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RemoveAuditableVisitor
extends TraversingItemVisitor {
    private final AuditService auditService;
    private final Log log = ExoLogger.getLogger((String)"jcr.RemoveAuditableVisitor");

    public RemoveAuditableVisitor(AuditService auditService) {
        this.auditService = auditService;
    }

    protected void entering(Node node, int arg1) throws RepositoryException {
        if (((NodeImpl)node).isNodeType(AuditService.EXO_AUDITABLE) && this.auditService.hasHistory(node)) {
            this.auditService.removeHistory(node);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("History removed for " + node.getPath()));
            }
        }
    }

    protected void entering(Property arg0, int arg1) throws RepositoryException {
    }

    protected void leaving(Node arg0, int arg1) throws RepositoryException {
    }

    protected void leaving(Property arg0, int arg1) throws RepositoryException {
    }
}

