/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.lang.css.CssSchema;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.stages.HtmlToJsStage;
import com.google.caja.plugin.stages.PipelineStageTestCase;
import com.google.caja.util.ContentType;

public final class CompileHtmlStageTest
extends PipelineStageTestCase {
    public final void testEmitHtmlAsJsStaticOnly() throws Exception {
        this.assertPipeline(CompileHtmlStageTest.job("<p>Hello world</p>", ContentType.HTML), CompileHtmlStageTest.job("{\n  'use strict';\n  'use cajita'; /* Start translated code */\n  throw 'Translated code must never be executed';\n  {\n    IMPORTS___.htmlEmitter___.emitStatic('<p>Hello world</p>');\n  } /* End translated code */\n}", ContentType.JS));
    }

    public final void testEmitHtmlAsJsAttributes() throws Exception {
        this.assertPipeline(CompileHtmlStageTest.job("<p id=\"foo\">Hello world</p>", ContentType.HTML), CompileHtmlStageTest.job("{\n  'use strict';\n  'use cajita'; /* Start translated code */\n  throw 'Translated code must never be executed';\n  {\n    IMPORTS___.htmlEmitter___.emitStatic('<p id=\\\"id_1___\\\">Hello world</p>');\n  } /* End translated code */\n}", ContentType.JS), CompileHtmlStageTest.job("{\n  'use cajita'; /* Start translated code */\n  throw 'Translated code must never be executed';\n  {\n    var el___;\n    var emitter___ = IMPORTS___.htmlEmitter___;\n    el___ = emitter___.byId('id_1___');\n    emitter___.setAttr(el___, 'id', 'foo-' + IMPORTS___.getIdClass___());\n    el___ = emitter___.finish();\n    emitter___.signalLoaded();\n  } /* End translated code */\n}", ContentType.JS));
    }

    protected boolean runPipeline(Jobs jobs) throws Exception {
        this.mq.getMessages().clear();
        return new HtmlToJsStage(CssSchema.getDefaultCss21Schema(this.mq), HtmlSchema.getDefault(this.mq)).apply(jobs);
    }
}

