/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database.creator;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.Property;
import org.exoplatform.services.database.creator.DBConnectionInfo;
import org.exoplatform.services.database.creator.DBCreatorException;
import org.exoplatform.services.database.utils.ExceptionManagementHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBCreator {
    private static final String CONNECTION_PROPERTIES = "db-connection";
    private static final String DRIVER_NAME = "driverClassName";
    private static final String SERVER_URL = "url";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String DB_CREATION_PROPERTIES = "db-creation";
    private static final String DB_SCRIPT_PATH = "scriptPath";
    private static final String DB_USERNAME = "username";
    private static final String DB_PASSWORD = "password";
    public static final String DATABASE_TEMPLATE = "${database}";
    public static final String USERNAME_TEMPLATE = "${username}";
    public static final String PASSWORD_TEMPLATE = "${password}";
    protected final String serverUrl;
    protected final Map<String, String> connectionProperties;
    protected final String dbScript;
    protected final String dbUserName;
    protected final String dbPassword;

    public DBCreator(String serverUrl, Map<String, String> connectionProperties, String scriptPath, String dbUserName, String dbPassword, ConfigurationManager cm) throws ConfigurationException {
        this.serverUrl = serverUrl;
        this.connectionProperties = connectionProperties;
        this.dbUserName = dbUserName;
        this.dbPassword = dbPassword;
        this.dbScript = this.findScriptResource(scriptPath, cm);
    }

    public DBCreator(InitParams params, ConfigurationManager cm) throws ConfigurationException {
        if (params == null) {
            throw new ConfigurationException("Initializations parameters expected");
        }
        PropertiesParam prop = params.getPropertiesParam(CONNECTION_PROPERTIES);
        if (prop != null) {
            if (prop.getProperty(DRIVER_NAME) == null) {
                throw new ConfigurationException("driverClassName expected in db-connection properties section");
            }
            this.serverUrl = prop.getProperty(SERVER_URL);
            if (this.serverUrl == null) {
                throw new ConfigurationException("url expected in db-connection properties section");
            }
            if (prop.getProperty("username") == null) {
                throw new ConfigurationException("username expected in db-connection properties section");
            }
            if (prop.getProperty("password") == null) {
                throw new ConfigurationException("password expected in db-connection properties section");
            }
            Iterator pit = prop.getPropertyIterator();
            this.connectionProperties = new HashMap<String, String>();
            while (pit.hasNext()) {
                Property p = (Property)pit.next();
                if (p.getName().equalsIgnoreCase(SERVER_URL)) continue;
                this.connectionProperties.put(p.getName(), p.getValue());
            }
        } else {
            throw new ConfigurationException("db-connection properties expected in initializations parameters");
        }
        prop = params.getPropertiesParam(DB_CREATION_PROPERTIES);
        if (prop != null) {
            String scriptPath = prop.getProperty(DB_SCRIPT_PATH);
            if (scriptPath == null) {
                throw new ConfigurationException("scriptPath expected in db-creation properties section");
            }
            this.dbScript = this.findScriptResource(scriptPath, cm);
            this.dbUserName = prop.getProperty("username");
            if (this.dbUserName == null) {
                throw new ConfigurationException("username expected in db-creation properties section");
            }
            this.dbPassword = prop.getProperty("password");
            if (this.dbPassword == null) {
                throw new ConfigurationException("password expected in db-creation properties section");
            }
        } else {
            throw new ConfigurationException("db-creation properties expected in initializations parameters");
        }
    }

    public DBConnectionInfo createDatabase(String dbName) throws DBCreatorException {
        Connection conn = this.openConnection();
        try {
            String dbProductName = this.getDBProductName(conn);
            if (dbProductName.startsWith("Microsoft SQL Server") || dbProductName.startsWith("Adaptive Server Anywhere") || dbProductName.equals("Sybase SQL Server") || dbProductName.equals("Adaptive Server Enterprise")) {
                this.executeAutoCommitMode(conn, dbName);
            } else {
                this.executeBatchMode(conn, dbName);
            }
            DBConnectionInfo dBConnectionInfo = this.constructDBConnectionInfo(dbName, dbProductName);
            return dBConnectionInfo;
        }
        catch (SQLException e) {
            throw new DBCreatorException("Can't execute SQL script : " + ExceptionManagementHelper.getFullSQLExceptionMessage(e));
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new DBCreatorException("Can't close connection", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBConnectionInfo getDBConnectionInfo(String dbName) throws DBCreatorException {
        Connection conn = this.openConnection();
        try {
            DBConnectionInfo dBConnectionInfo = this.constructDBConnectionInfo(dbName, this.getDBProductName(conn));
            return dBConnectionInfo;
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new DBCreatorException("Can't close connection", e);
            }
        }
    }

    private void executeBatchMode(Connection conn, String dbName) throws SQLException {
        Statement statement = conn.createStatement();
        for (String scr : this.dbScript.split(";")) {
            scr = scr.replace(DATABASE_TEMPLATE, dbName);
            scr = scr.replace(USERNAME_TEMPLATE, this.dbUserName);
            String s = this.cleanWhitespaces((scr = scr.replace(PASSWORD_TEMPLATE, this.dbPassword)).trim());
            if (s.length() <= 0) continue;
            statement.addBatch(s);
        }
        statement.executeBatch();
    }

    private DBConnectionInfo constructDBConnectionInfo(String dbName, String dbProductName) {
        String dbUrl = this.serverUrl;
        if (dbProductName.startsWith("Microsoft SQL Server")) {
            dbUrl = dbUrl + (dbUrl.endsWith(";") ? "" : ";") + "databaseName=" + dbName + ";";
        } else if (!dbProductName.equals("Oracle")) {
            dbUrl = dbUrl + (dbUrl.endsWith("/") ? "" : "/") + dbName;
        }
        HashMap<String, String> connProperties = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.connectionProperties.entrySet()) {
            connProperties.put(entry.getKey(), entry.getValue());
        }
        connProperties.put(SERVER_URL, dbUrl);
        return new DBConnectionInfo(dbName, connProperties);
    }

    private void executeAutoCommitMode(Connection conn, String dbName) throws SQLException {
        conn.setAutoCommit(true);
        for (String scr : this.dbScript.split(";")) {
            scr = scr.replace(DATABASE_TEMPLATE, dbName);
            scr = scr.replace(USERNAME_TEMPLATE, this.dbUserName);
            String s = this.cleanWhitespaces((scr = scr.replace(PASSWORD_TEMPLATE, this.dbPassword)).trim());
            if (s.length() <= 0) continue;
            conn.createStatement().executeUpdate(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResource(InputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader(is);
        try {
            StringBuilder sbuff = new StringBuilder();
            char[] buff = new char[is.available()];
            int r = 0;
            while ((r = isr.read(buff)) > 0) {
                sbuff.append(buff, 0, r);
            }
            String string = sbuff.toString();
            return string;
        }
        finally {
            is.close();
        }
    }

    private String findScriptResource(String scriptPath, ConfigurationManager cm) throws ConfigurationException {
        try {
            return this.readResource(cm.getInputStream(scriptPath));
        }
        catch (Exception e) {
            try {
                return this.readResource(PrivilegedFileHelper.fileInputStream((String)scriptPath));
            }
            catch (IOException ioe) {
                throw new ConfigurationException("Can't read script resource " + scriptPath, (Throwable)e);
            }
        }
    }

    private String cleanWhitespaces(String string) {
        if (string != null) {
            char[] cc = string.toCharArray();
            for (int ci = cc.length - 1; ci > 0; --ci) {
                if (!Character.isWhitespace(cc[ci])) continue;
                cc[ci] = 32;
            }
            return new String(cc);
        }
        return string;
    }

    private Connection openConnection() throws DBCreatorException {
        Connection conn = null;
        try {
            Class.forName(this.connectionProperties.get(DRIVER_NAME));
            conn = (Connection)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Connection>(){

                @Override
                public Connection run() throws Exception {
                    return DriverManager.getConnection(DBCreator.this.serverUrl, DBCreator.this.connectionProperties.get("username"), DBCreator.this.connectionProperties.get("password"));
                }
            });
            return conn;
        }
        catch (SQLException e) {
            throw new DBCreatorException("Can't establish the JDBC connection to database " + this.serverUrl, e);
        }
        catch (ClassNotFoundException e) {
            throw new DBCreatorException("Can't load the JDBC driver " + this.connectionProperties.get(DRIVER_NAME), e);
        }
    }

    private String getDBProductName(final Connection conn) throws DBCreatorException {
        try {
            return (String)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return conn.getMetaData().getDatabaseProductName();
                }
            });
        }
        catch (SQLException e) {
            throw new DBCreatorException("Can't resolve database product name ", e);
        }
    }
}

