/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core;

import java.io.Serializable;
import java.util.List;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="system:/groovy/webui/core/UIConfirmation.gtmpl", events={@EventConfig(listeners={CloseActionListener.class}), @EventConfig(listeners={ClickActionListener.class})})
public class UIConfirmation
extends UIPopupWindow {
    private String message_;
    private Object caller_;
    private List<ActionConfirm> actions_;

    public UIConfirmation() {
        this.message_ = "";
        this.caller_ = new Object();
        this.setShowMask(true);
        this.setShow(true);
    }

    public UIConfirmation(String message, Object caller) {
        this.message_ = message;
        this.caller_ = caller;
        this.setShowMask(true);
        this.setShow(true);
    }

    public void setMessage(String message) {
        this.message_ = message;
    }

    public String getMessage() {
        return this.message_;
    }

    public Object getCaller() {
        return this.caller_;
    }

    public void setCaller(Object caller) {
        this.caller_ = caller;
    }

    public void addMessage(String message) {
        this.message_ = message;
    }

    public void clearMessage() {
        this.message_ = "";
    }

    public void setActions(List<ActionConfirm> actions_) {
        this.actions_ = actions_;
    }

    public List<ActionConfirm> getActions() {
        return this.actions_;
    }

    public boolean hasMessage() {
        return this.message_ != null && !this.message_.equals("");
    }

    private void hidePopup(Event<UIConfirmation> event) throws Exception {
        WebuiRequestContext context = event.getRequestContext();
        this.clearMessage();
        context.addUIComponentToUpdateByAjax((UIComponent)this);
        UIComponent uiParent = this.getParent();
        Event pEvent = uiParent.createEvent("ClosePopup", event.getExecutionPhase(), event.getRequestContext());
        if (pEvent != null) {
            pEvent.broadcast();
        }
    }

    public static class ActionConfirm
    implements Serializable {
        private String eventId_;
        private String actionKey_;

        public ActionConfirm() {
        }

        public ActionConfirm(String eventId, String actionKey) {
            this.eventId_ = eventId;
            this.actionKey_ = actionKey;
        }

        public void setEventId(String eventId) {
            this.eventId_ = eventId;
        }

        public String getEventId() {
            return this.eventId_;
        }

        public void setActionKey(String actionKey) {
            this.actionKey_ = actionKey;
        }

        public String getActionKey() {
            return this.actionKey_;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClickActionListener
    extends EventListener<UIConfirmation> {
        public void execute(Event<UIConfirmation> event) throws Exception {
            WebuiRequestContext context = event.getRequestContext();
            UIConfirmation uiConfirmation = (UIConfirmation)((Object)event.getSource());
            UIComponent uiComponent = (UIComponent)uiConfirmation.getCaller();
            Event xEvent = uiComponent.createEvent(context.getRequestParameter("objectId"), event.getExecutionPhase(), context);
            if (xEvent != null) {
                xEvent.broadcast();
            }
            uiConfirmation.hidePopup((Event<UIConfirmation>)event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UIConfirmation> {
        public void execute(Event<UIConfirmation> event) throws Exception {
            UIConfirmation uiConfirmation = (UIConfirmation)((Object)event.getSource());
            uiConfirmation.hidePopup((Event<UIConfirmation>)event);
        }
    }
}

