/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.rightclick.manager;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.filter.CanSetPropertyFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsCheckedOutFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotHoldsLockFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotInTrashFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotSameNameSiblingFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotSimpleLockedFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotTrashHomeNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIWorkingAreaActionListener;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.services.cms.lock.LockService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={LockActionListener.class})})
public class LockManageComponent
extends UIAbstractManagerComponent {
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsNotInTrashFilter(), new IsNotSameNameSiblingFilter(), new IsNotHoldsLockFilter(), new IsNotSimpleLockedFilter(), new CanSetPropertyFilter(), new IsCheckedOutFilter(), new IsNotTrashHomeNodeFilter()});
    private static final Log LOG = ExoLogger.getLogger(LockManageComponent.class);

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    private static void processMultiLock(String[] nodePaths, Event<?> event, UIJCRExplorer uiExplorer) throws Exception {
        for (int i = 0; i < nodePaths.length; ++i) {
            LockManageComponent.processLock(nodePaths[i], event, uiExplorer);
        }
        uiExplorer.updateAjax(event);
    }

    private static void processLock(String nodePath, Event<?> event, UIJCRExplorer uiExplorer) throws Exception {
        Node node;
        UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
        Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(nodePath);
        String wsName = null;
        if (!matcher.find()) {
            throw new IllegalArgumentException("The ObjectId is invalid '" + nodePath + "'");
        }
        wsName = matcher.group(1);
        nodePath = matcher.group(2);
        Session session = uiExplorer.getSessionByWorkspace(wsName);
        try {
            node = uiExplorer.getNodeByPath(nodePath, session);
            nodePath = node.getPath();
            session = node.getSession();
            wsName = session.getWorkspace().getName();
        }
        catch (PathNotFoundException path) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
            return;
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return;
        }
        try {
            if (!PermissionUtil.canSetProperty((Node)node)) {
                throw new AccessDeniedException("access denied, can't lock node:" + node.getPath());
            }
            if (node.canAddMixin("mix:lockable")) {
                node.addMixin("mix:lockable");
                node.save();
            }
            Lock lock = node.lock(false, false);
            LockUtil.keepLock((Lock)lock);
            LockService lockService = (LockService)uiExplorer.getApplicationComponent(LockService.class);
            List settingLockList = lockService.getAllGroupsOrUsersForLock();
            for (String settingLock : settingLockList) {
                LockUtil.keepLock((Lock)lock, (String)settingLock);
                if (!settingLock.startsWith("*")) continue;
                String lockTokenString = settingLock;
                ExoContainer container = ExoContainerContext.getCurrentContainer();
                OrganizationService service = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
                List memberships = (List)service.getMembershipTypeHandler().findMembershipTypes();
                for (MembershipType membership : memberships) {
                    lockTokenString = settingLock.replace("*", membership.getName());
                    LockUtil.keepLock((Lock)lock, (String)lockTokenString);
                }
            }
            session.save();
        }
        catch (LockException le) {
            ApplicationMessage appMessage = new ApplicationMessage("UIPopupMenu.msg.cant-lock", (Object[])new String[]{node.getPath()}, 0);
            appMessage.setArgsLocalized(false);
            uiApp.addMessage(appMessage);
            uiExplorer.updateAjax(event);
            return;
        }
        catch (AccessDeniedException adEx) {
            ApplicationMessage appMessage = new ApplicationMessage("UIPopupMenu.msg.can-not-lock-node", (Object[])new String[]{node.getPath()}, 0);
            appMessage.setArgsLocalized(false);
            uiApp.addMessage(appMessage);
            uiExplorer.updateAjax(event);
            return;
        }
        catch (Exception e) {
            LOG.error((Object)"an unexpected error occurs while locking the node", (Throwable)e);
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            uiExplorer.updateAjax(event);
        }
    }

    public static void lockManage(Event<? extends UIComponent> event, UIJCRExplorer uiExplorer) throws Exception {
        String nodePath = event.getRequestContext().getRequestParameter("objectId");
        if (nodePath.indexOf(";") > -1) {
            LockManageComponent.processMultiLock(nodePath.split(";"), event, uiExplorer);
        } else {
            LockManageComponent.processLock(nodePath, event, uiExplorer);
        }
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LockActionListener
    extends UIWorkingAreaActionListener<LockManageComponent> {
        public void processEvent(Event<LockManageComponent> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((LockManageComponent)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            LockManageComponent.lockManage(event, uiExplorer);
        }
    }
}

