/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contentvalidation.webui;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.presentation.AbstractActionComponent;
import org.exoplatform.ecm.webui.presentation.NodePresentation;
import org.exoplatform.ecm.webui.presentation.removeattach.RemoveAttachmentComponent;
import org.exoplatform.ecm.webui.presentation.removecomment.RemoveCommentComponent;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.comments.CommentsService;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.web.application.Parameter;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.workflow.webui.component.controller.UITaskManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:resources/templates/controller/UIDocumentContent.gtmpl", events={@EventConfig(listeners={ChangeLanguageActionListener.class}), @EventConfig(listeners={DownloadActionListener.class}), @EventConfig(listeners={ChangeNodeActionListener.class})})
public class UIDocumentContent
extends UIContainer
implements NodePresentation {
    private NodeLocation node_;
    public static final String DEFAULT_LANGUAGE = "default";
    private String language_ = "default";
    private static final Log LOG = ExoLogger.getLogger(UIDocumentContent.class);

    public void setNode(Node node) {
        this.node_ = NodeLocation.getNodeLocationByNode((Node)node);
    }

    public Node getNode() throws Exception {
        Node node = this.getOriginalNode();
        if (node.hasProperty("exo:language")) {
            String defaultLang = node.getProperty("exo:language").getString();
            if (!this.language_.equals(DEFAULT_LANGUAGE) && !this.language_.equals(defaultLang)) {
                Node curNode = node.getNode("languages/" + this.language_);
                this.language_ = defaultLang;
                return curNode;
            }
        }
        return node;
    }

    public Node getOriginalNode() throws Exception {
        return NodeLocation.getNodeByLocation((NodeLocation)this.node_);
    }

    public String getNodeType() throws Exception {
        return this.getOriginalNode().getPrimaryNodeType().getName();
    }

    public String getTemplate() {
        try {
            if (this.isNodeTypeSupported()) {
                return this.getTemplatePath();
            }
            return super.getTemplate();
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
            return null;
        }
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        try {
            DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
            String wsName = dmsConfiguration.getConfig().getSystemWorkspace();
            return new JCRResourceResolver(wsName);
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
            return super.getTemplateResourceResolver(context, template);
        }
    }

    public boolean isNodeTypeSupported() {
        try {
            TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
            String nodeTypeName = this.getOriginalNode().getPrimaryNodeType().getName();
            return templateService.isManagedNodeType(nodeTypeName);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getImage(Node node, String nodeTypeName) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node imageNode = node.getNode(nodeTypeName);
        InputStream input = imageNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public Node getNodeByPath(String nodePath, String workspace) throws Exception {
        ManageableRepository manageRepo = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository();
        Session session = WCMCoreUtils.getSystemSessionProvider().getSession(workspace, manageRepo);
        return (Node)session.getItem(nodePath);
    }

    public String getCapacityOfFile(Node file) throws Exception {
        Node contentNode = file.getNode("jcr:content");
        InputStream in = contentNode.getProperty("jcr:data").getStream();
        float capacity = in.available() / 1024;
        String strCapacity = Float.toString(capacity);
        if (strCapacity.indexOf(".") > -1) {
            return strCapacity.substring(0, strCapacity.lastIndexOf("."));
        }
        return strCapacity;
    }

    public List<Node> getRelations() throws Exception {
        ArrayList<Node> relations = new ArrayList<Node>();
        try {
            Value[] vals;
            for (Value val : vals = this.getOriginalNode().getProperty("exo:relation").getValues()) {
                String uuid = val.getString();
                Node relationNode = this.getNodeByUUID(uuid);
                relations.add(relationNode);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return relations;
    }

    public Node getNodeByUUID(String uuid) throws Exception {
        ManageableRepository manageRepo = (ManageableRepository)this.getOriginalNode().getSession().getRepository();
        SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
        for (String ws : manageRepo.getWorkspaceNames()) {
            try {
                return sessionProvider.getSession(ws, manageRepo).getNodeByUUID(uuid);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    private List<String> getListAllowedFileType(Node currentNode) throws Exception {
        ArrayList<String> nodeTypes = new ArrayList<String>();
        NodeTypeManager ntManager = currentNode.getSession().getWorkspace().getNodeTypeManager();
        NodeType currentNodeType = currentNode.getPrimaryNodeType();
        NodeDefinition[] childDefs = currentNodeType.getChildNodeDefinitions();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        List templates = templateService.getDocumentTemplates();
        try {
            block2: for (int i = 0; i < templates.size(); ++i) {
                String nodeTypeName = templates.get(i).toString();
                NodeType nodeType = ntManager.getNodeType(nodeTypeName);
                NodeType[] superTypes = nodeType.getSupertypes();
                boolean isCanCreateDocument = false;
                for (NodeDefinition nodeDefinition : childDefs) {
                    NodeType[] requiredChilds;
                    for (NodeType requiredChild : requiredChilds = nodeDefinition.getRequiredPrimaryTypes()) {
                        if (!nodeTypeName.equals(requiredChild.getName())) continue;
                        isCanCreateDocument = true;
                        break;
                    }
                    if (!nodeTypeName.equals(nodeDefinition.getName()) && !isCanCreateDocument) continue;
                    if (!nodeTypes.contains(nodeTypeName)) {
                        nodeTypes.add(nodeTypeName);
                    }
                    isCanCreateDocument = true;
                }
                if (isCanCreateDocument) continue;
                for (NodeDefinition nodeDefinition : superTypes) {
                    for (NodeDefinition childDef : childDefs) {
                        for (NodeType requiredType : childDef.getRequiredPrimaryTypes()) {
                            if (!nodeDefinition.getName().equals(requiredType.getName())) continue;
                            if (!nodeTypes.contains(nodeTypeName)) {
                                nodeTypes.add(nodeTypeName);
                            }
                            isCanCreateDocument = true;
                            break;
                        }
                        if (isCanCreateDocument) break;
                    }
                    if (isCanCreateDocument) continue block2;
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
        }
        return nodeTypes;
    }

    public UIComponent getCommentComponent() {
        return this;
    }

    public UIComponent getRemoveAttach() throws Exception {
        this.removeChild(RemoveAttachmentComponent.class);
        UIComponent uicomponent = this.addChild(RemoveAttachmentComponent.class, null, "DocumentContentRemoveAttach");
        ((AbstractActionComponent)uicomponent).setLstComponentupdate(Arrays.asList(UIPopupWindow.class));
        return uicomponent;
    }

    public UIComponent getRemoveComment() throws Exception {
        this.removeChild(RemoveCommentComponent.class);
        UIComponent uicomponent = this.addChild(RemoveCommentComponent.class, null, "DocumentContentRemoveComment");
        ((AbstractActionComponent)uicomponent).setLstComponentupdate(Arrays.asList(UIPopupWindow.class));
        return uicomponent;
    }

    public UIComponent getUIComponent(String mimeType) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getUIComponent((String)mimeType, (UIContainer)this);
    }

    public List<Node> getAttachments() throws Exception {
        ArrayList<Node> attachments = new ArrayList<Node>();
        String nodeType = "";
        Node node = this.getOriginalNode();
        NodeIterator childrenIterator = node.getNodes();
        while (childrenIterator.hasNext()) {
            Node childNode = childrenIterator.nextNode();
            try {
                nodeType = childNode.getPrimaryNodeType().getName();
                List<String> listCanCreateNodeType = this.getListAllowedFileType(node);
                if (!listCanCreateNodeType.contains(nodeType)) continue;
                attachments.add(childNode);
            }
            catch (Exception e) {}
        }
        return attachments;
    }

    @Deprecated
    public String getAttachmentURL(Node attNode, Parameter[] params) throws Exception {
        return this.getViewableLink(attNode, params);
    }

    public String getViewableLink(Node attNode, Parameter[] params) throws Exception {
        return this.event("ChangeNode", org.exoplatform.ecm.webui.utils.Utils.formatNodeName((String)attNode.getPath()), params);
    }

    public String getRssLink() {
        return null;
    }

    public boolean isRssLink() {
        return false;
    }

    public List<String> getSupportedLocalise() throws Exception {
        ArrayList<String> local = new ArrayList<String>();
        Node node = this.getOriginalNode();
        if (node.hasNode("languages")) {
            Node languages = node.getNode("languages");
            NodeIterator iter = languages.getNodes();
            while (iter.hasNext()) {
                local.add(iter.nextNode().getName());
            }
            local.add(node.getProperty("exo:language").getString());
        }
        return local;
    }

    public String getTemplatePath() throws Exception {
        String nodeTypeName = this.getOriginalNode().getPrimaryNodeType().getName();
        String userName = Util.getPortalRequestContext().getRemoteUser();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return templateService.getTemplatePathByUser(false, nodeTypeName, userName);
    }

    public String getViewTemplate(String nodeTypeName, String templateName) throws Exception {
        TemplateService tempServ = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return tempServ.getTemplatePath(false, nodeTypeName, templateName);
    }

    public String getTemplateSkin(String nodeTypeName, String skinName) throws Exception {
        TemplateService tempServ = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return tempServ.getSkinPath(nodeTypeName, skinName, this.getLanguage());
    }

    public List<Node> getComments() throws Exception {
        return ((CommentsService)this.getApplicationComponent(CommentsService.class)).getComments(this.getOriginalNode(), DEFAULT_LANGUAGE);
    }

    public String getIcons(Node node, String appended) throws Exception {
        String nodeType = node.getPrimaryNodeType().getName().replaceAll(":", "_") + appended;
        StringBuilder str = new StringBuilder(nodeType);
        if (node.isNodeType("nt:file")) {
            Node jcrContentNode = node.getNode("jcr:content");
            str.append(" ").append(jcrContentNode.getProperty("jcr:mimeType").getString().replaceFirst("/", "_")).append(appended);
        }
        return str.toString();
    }

    public String getImage(Node node) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node imageNode = node.getNode("exo:image");
        InputStream input = imageNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public String getWebDAVServerPrefix() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)PortletRequestContext.getCurrentInstance();
        String prefixWebDAV = portletRequestContext.getRequest().getScheme() + "://" + portletRequestContext.getRequest().getServerName() + ":" + String.format("%s", portletRequestContext.getRequest().getServerPort());
        return prefixWebDAV;
    }

    public String getLanguage() {
        return this.language_;
    }

    public void setLanguage(String language) {
        this.language_ = language;
    }

    public Object getComponentInstanceOfType(String className) {
        Object service = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> object = loader.loadClass(className);
            service = this.getApplicationComponent(object);
        }
        catch (ClassNotFoundException ex) {
            LOG.error((Object)"Unexpected error", (Throwable)ex);
        }
        return service;
    }

    public String getDownloadLink(Node node) throws Exception {
        return Utils.getDownloadLink((Node)node);
    }

    public String getPortalName() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        return containerInfo.getContainerName();
    }

    public String getWorkspaceName() throws Exception {
        return this.getOriginalNode().getSession().getWorkspace().getName();
    }

    public String getRepository() throws Exception {
        ManageableRepository manaRepo = (ManageableRepository)this.getOriginalNode().getSession().getRepository();
        return manaRepo.getConfiguration().getName();
    }

    public String encodeHTML(String text) throws Exception {
        return text.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public boolean isEnableComment() {
        return false;
    }

    public boolean isEnableVote() {
        return false;
    }

    public void setEnableComment(boolean value) {
    }

    public void setEnableVote(boolean value) {
    }

    public String getInlineEditingField(Node orgNode, String propertyName, String defaultValue, String inputType, String idGenerator, String cssClass, boolean isGenericProperty, String ... arguments) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getInlineEditingField((Node)orgNode, (String)propertyName, (String)defaultValue, (String)inputType, (String)idGenerator, (String)cssClass, (boolean)isGenericProperty, (String[])arguments);
    }

    public String getInlineEditingField(Node orgNode, String propertyName) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getInlineEditingField((Node)orgNode, (String)propertyName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeNodeActionListener
    extends EventListener<UIDocumentContent> {
        public void execute(Event<UIDocumentContent> event) throws Exception {
            UIDocumentContent uiComp = (UIDocumentContent)((Object)event.getSource());
            RepositoryService repositoryService = (RepositoryService)uiComp.getApplicationComponent(RepositoryService.class);
            ManageableRepository repository = repositoryService.getCurrentRepository();
            String uri = event.getRequestContext().getRequestParameter("objectId");
            String workspaceName = event.getRequestContext().getRequestParameter("workspaceName");
            Session session = WCMCoreUtils.getUserSessionProvider().getSession(workspaceName, repository);
            Node selectedNode = (Node)session.getItem(uri);
            uiComp.setNode(selectedNode);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiComp.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DownloadActionListener
    extends EventListener<UIDocumentContent> {
        public void execute(Event<UIDocumentContent> event) throws Exception {
            UIDocumentContent uiComp = (UIDocumentContent)((Object)event.getSource());
            String downloadLink = uiComp.getDownloadLink(Utils.getFileLangNode((Node)uiComp.getNode()));
            event.getRequestContext().getJavascriptManager().addJavascript((CharSequence)("ajaxRedirect('" + downloadLink + "');"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeLanguageActionListener
    extends EventListener<UIDocumentContent> {
        public void execute(Event<UIDocumentContent> event) throws Exception {
            UIDocumentContent uiDocContent = (UIDocumentContent)((Object)event.getSource());
            event.getRequestContext().addUIComponentToUpdateByAjax(uiDocContent.getAncestorOfType(UITaskManager.class));
            String selectedLanguage = event.getRequestContext().getRequestParameter("objectId");
            uiDocContent.setRenderSibling(UIDocumentContent.class);
            uiDocContent.setLanguage(selectedLanguage);
        }
    }
}

