/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.io.File;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CacheManager {
    private static final Logger logger = Logger.getLogger(CacheManager.class.toString());
    private int fileCount = 0;
    private Vector cachedFiles = new Vector(128);

    public synchronized void addCachedFile(String filePath) {
        ++this.fileCount;
        this.cachedFiles.add(filePath);
    }

    public void dispose() {
        for (Object cachedFile : this.cachedFiles) {
            String fileName = (String)cachedFile;
            try {
                boolean success = new File(fileName).delete();
                if (success || !logger.isLoggable(Level.FINE)) continue;
                logger.fine("Error deleting cached file " + fileName);
            }
            catch (SecurityException e) {
                logger.log(Level.FINE, "Security error removing cached file " + fileName, e);
            }
        }
    }
}

