/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.net.media;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gatein.common.net.media.MediaType;
import org.gatein.common.net.media.MediaTypeMap;
import org.gatein.common.net.media.TypeDef;

public class MediaTypeMapImpl<V>
implements MediaTypeMap<V> {
    private static final String ANY = "*";
    private static final String ANY_ANY = "*/*";
    private static final char SEPARATOR = '/';
    private final Map<MediaType, Set<V>> mediaTypeToValues = new HashMap<MediaType, Set<V>>();
    private final Map<TypeDef, Set<V>> typeToValues = new HashMap<TypeDef, Set<V>>();
    private final Map<MediaType, Set<V>> combinedMediaTypeToValues = new HashMap<MediaType, Set<V>>();
    private final Map<TypeDef, Set<V>> combinedTypeToValues = new HashMap<TypeDef, Set<V>>();
    private final Set<V> anyTypeValues = new HashSet<V>();

    public void put(String mediaTypePattern, V value) throws IllegalArgumentException {
        if (mediaTypePattern == null) {
            throw new IllegalArgumentException("No null media type pattern accepted");
        }
        if (value == null) {
            throw new IllegalArgumentException("No null value accepted");
        }
        if (ANY.equals(mediaTypePattern) || ANY_ANY.equals(mediaTypePattern)) {
            this.put(value);
        } else {
            int index = mediaTypePattern.indexOf(47);
            if (index == -1) {
                throw new IllegalArgumentException("Not a valid media type pattern value:" + mediaTypePattern);
            }
            String type = mediaTypePattern.substring(0, index);
            String subtype = mediaTypePattern.substring(index + 1);
            if (ANY.equals(subtype)) {
                this.put(TypeDef.create(type), value);
            } else {
                this.put(MediaType.create(type, subtype), value);
            }
        }
    }

    public void put(MediaType mediaType, V value) throws IllegalArgumentException {
        if (mediaType == null) {
            throw new IllegalArgumentException("No null media type accepted");
        }
        if (value == null) {
            throw new IllegalArgumentException("No null value accepted");
        }
        Set<V> mediaTypeValues = this.mediaTypeToValues.get(mediaType);
        if (mediaTypeValues == null) {
            mediaTypeValues = new HashSet<V>();
            this.mediaTypeToValues.put(mediaType, mediaTypeValues);
        }
        mediaTypeValues.add(value);
        Set<V> combinedMediaTypeValues = this.combinedMediaTypeToValues.get(mediaType);
        if (combinedMediaTypeValues == null) {
            combinedMediaTypeValues = new HashSet<V>();
            this.combinedMediaTypeToValues.put(mediaType, combinedMediaTypeValues);
        }
        combinedMediaTypeValues.add(value);
        Set<V> combinedTypeValues = this.combinedTypeToValues.get(mediaType.getType());
        if (combinedTypeValues != null) {
            combinedMediaTypeValues.addAll(combinedTypeValues);
        }
        combinedMediaTypeValues.addAll(this.anyTypeValues);
    }

    public void put(TypeDef type, V value) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("No null type accepted");
        }
        if (value == null) {
            throw new IllegalArgumentException("No null value accepted");
        }
        Set<V> typeValues = this.typeToValues.get(type);
        if (typeValues == null) {
            typeValues = new HashSet<V>();
            this.typeToValues.put(type, typeValues);
        }
        typeValues.add(value);
        Set<V> combinedTypeValues = this.combinedTypeToValues.get(type);
        if (combinedTypeValues == null) {
            combinedTypeValues = new HashSet<V>();
            this.combinedTypeToValues.put(type, combinedTypeValues);
        }
        combinedTypeValues.add(value);
        for (Map.Entry<MediaType, Set<V>> entry : this.combinedMediaTypeToValues.entrySet()) {
            if (!entry.getKey().getType().equals(type)) continue;
            entry.getValue().add(value);
        }
    }

    public void put(V value) {
        if (value == null) {
            throw new IllegalArgumentException("No null value accepted");
        }
        this.anyTypeValues.add(value);
        for (Set<V> combinedTypeValues : this.combinedTypeToValues.values()) {
            combinedTypeValues.add(value);
        }
        for (Set<V> combinedMediaTypeValues : this.combinedMediaTypeToValues.values()) {
            combinedMediaTypeValues.add(value);
        }
    }

    @Override
    public Set<V> resolve(MediaType mediaType) {
        if (mediaType == null) {
            throw new IllegalArgumentException("No null media type accepted");
        }
        Set<V> values = this.combinedMediaTypeToValues.get(mediaType);
        if (values == null) {
            values = this.resolve(mediaType.getType());
        }
        return values;
    }

    @Override
    public Set<V> resolve(TypeDef type) {
        if (type == null) {
            throw new IllegalArgumentException("No null type accepted");
        }
        Set<V> values = this.combinedTypeToValues.get(type);
        if (values == null) {
            values = this.getValues();
        }
        return values;
    }

    @Override
    public Set<V> get(MediaType mediaType) {
        if (mediaType == null) {
            throw new IllegalArgumentException("No null media type accepted");
        }
        Set<Object> values = this.combinedMediaTypeToValues.get(mediaType);
        if (values == null) {
            values = Collections.emptySet();
        }
        return values;
    }

    @Override
    public Set<V> get(TypeDef type) {
        if (type == null) {
            throw new IllegalArgumentException("No null type accepted");
        }
        Set<Object> values = this.combinedTypeToValues.get(type);
        if (values == null) {
            values = Collections.emptySet();
        }
        return values;
    }

    @Override
    public Set<V> getValues() {
        return this.anyTypeValues;
    }

    @Override
    public boolean isSupported(MediaType mediaType) {
        return this.resolve(mediaType).size() > 0;
    }

    @Override
    public boolean isSupported(TypeDef type) {
        return this.resolve(type).size() > 0;
    }

    @Override
    public boolean isSupported(MediaType mediaType, V value) {
        if (value == null) {
            throw new IllegalArgumentException("No null value accepted");
        }
        return this.resolve(mediaType).contains(value);
    }

    @Override
    public boolean isSupported(TypeDef type, V value) {
        if (value == null) {
            throw new IllegalArgumentException("No null value accepted");
        }
        return this.resolve(type).contains(value);
    }

    @Override
    public boolean isSupported(V value) {
        if (value == null) {
            throw new IllegalArgumentException("No null value accepted");
        }
        return this.getValues().contains(value);
    }

    @Override
    public boolean contains(MediaType mediaType) {
        return this.get(mediaType).size() > 0;
    }

    @Override
    public boolean contains(TypeDef type) {
        return this.get(type).size() > 0;
    }

    @Override
    public boolean contains(MediaType mediaType, V value) {
        return this.get(mediaType).contains(value);
    }

    @Override
    public boolean contains(TypeDef type, V value) {
        return this.get(type).contains(value);
    }

    @Override
    public boolean contains(V value) {
        return this.getValues().contains(value);
    }

    @Override
    public Set<MediaType> getMediaTypes() {
        return this.combinedMediaTypeToValues.keySet();
    }

    @Override
    public Set<TypeDef> getTypes() {
        return this.combinedTypeToValues.keySet();
    }
}

