/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.node.DecisionCondition;
import org.jbpm.graph.node.DecisionHandler;
import org.jbpm.instantiation.Delegation;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Parsable;

public class Decision
extends Node
implements Parsable {
    static final String DECISION_CONDITION_RESULT = "decision_condition_result";
    static final long serialVersionUID = 1L;
    List decisionConditions = null;
    Delegation decisionDelegation = null;
    String decisionExpression = null;
    private static Log log = LogFactory.getLog((Class)Decision.class);

    public Decision() {
    }

    public Decision(String name) {
        super(name);
    }

    public Node.NodeType getNodeType() {
        return Node.NodeType.Decision;
    }

    public void read(Element decisionElement, JpdlXmlReader jpdlReader) {
        String expression = decisionElement.attributeValue("expression");
        Element decisionHandlerElement = decisionElement.element("handler");
        if (expression != null) {
            this.decisionExpression = expression;
        } else if (decisionHandlerElement != null) {
            this.decisionDelegation = new Delegation();
            this.decisionDelegation.read(decisionHandlerElement, jpdlReader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContext executionContext) {
        Transition transition = null;
        ClassLoader surroundingClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(JbpmConfiguration.getProcessClassLoader(executionContext.getProcessDefinition()));
            try {
                if (this.decisionDelegation != null) {
                    String transitionName;
                    DecisionHandler decisionHandler = (DecisionHandler)this.decisionDelegation.getInstance();
                    if (decisionHandler == null) {
                        decisionHandler = (DecisionHandler)this.decisionDelegation.instantiate();
                    }
                    if ((transition = this.getLeavingTransition(transitionName = decisionHandler.decide(executionContext))) == null) {
                        throw new JbpmException("decision '" + this.name + "' selected non existing transition '" + transitionName + "'");
                    }
                } else if (this.decisionExpression != null) {
                    Object result = JbpmExpressionEvaluator.evaluate(this.decisionExpression, executionContext);
                    if (result == null) {
                        throw new JbpmException("decision expression '" + this.decisionExpression + "' returned null");
                    }
                    String transitionName = result.toString();
                    transition = this.getLeavingTransition(transitionName);
                    if (transition == null) {
                        throw new JbpmException("decision '" + this.name + "' selected non existing transition '" + transitionName + "'");
                    }
                } else if (this.decisionConditions != null && !this.decisionConditions.isEmpty()) {
                    Iterator iter = this.decisionConditions.iterator();
                    while (iter.hasNext() && transition == null) {
                        String transitionName;
                        DecisionCondition decisionCondition = (DecisionCondition)iter.next();
                        Object result = JbpmExpressionEvaluator.evaluate(decisionCondition.getExpression(), executionContext);
                        if (!Boolean.TRUE.equals(result) || (transition = this.getLeavingTransition(transitionName = decisionCondition.getTransitionName())) == null) continue;
                        transition.removeConditionEnforcement();
                    }
                } else {
                    Iterator iter = this.leavingTransitions.iterator();
                    while (iter.hasNext() && transition == null) {
                        Object result;
                        Transition candidate = (Transition)iter.next();
                        String conditionExpression = candidate.getCondition();
                        if (conditionExpression == null || !Boolean.TRUE.equals(result = JbpmExpressionEvaluator.evaluate(conditionExpression, executionContext))) continue;
                        transition = candidate;
                    }
                }
                if (transition == null) {
                    transition = this.getDefaultLeavingTransition();
                }
                if (transition == null) {
                    throw new IllegalStateException("decision cannot select transition: " + this);
                }
                log.debug((Object)("decision didn't select transition, taking default " + transition));
                transition.removeConditionEnforcement();
            }
            catch (Exception exception) {
                this.raiseException(exception, executionContext);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(surroundingClassLoader);
        }
        log.debug((Object)("decision " + this.name + " is taking '" + transition + "'"));
        executionContext.leaveNode(transition);
    }

    public List getDecisionConditions() {
        return this.decisionConditions;
    }

    public void setDecisionDelegation(Delegation decisionDelegation) {
        this.decisionDelegation = decisionDelegation;
    }
}

