/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.xcmis.search.config.IndexConfiguration;
import org.xcmis.search.config.IndexConfigurationException;
import org.xcmis.search.lucene.index.InMemoryIndexDataKeeperFactory;
import org.xcmis.search.lucene.index.IndexException;
import org.xcmis.search.lucene.index.IndexReaderNotFoundException;
import org.xcmis.search.lucene.index.IndexTransaction;
import org.xcmis.search.lucene.index.IndexTransactionException;
import org.xcmis.search.lucene.index.IndexTransactionModificationReport;
import org.xcmis.search.lucene.index.IndexTransactionModificationReportImpl;
import org.xcmis.search.lucene.index.LocalIndexDataManagerProxy;
import org.xcmis.search.lucene.index.LuceneIndexDataKeeperFactory;
import org.xcmis.search.lucene.index.LuceneIndexDataManager;
import org.xcmis.search.lucene.index.TransactionLogException;
import org.xcmis.search.lucene.index.TransactionableLuceneIndexDataManager;
import org.xcmis.search.lucene.index.merge.AggregatePolicy;
import org.xcmis.search.lucene.index.merge.MaxCandidatsCountAggrigatePolicy;
import org.xcmis.search.lucene.index.merge.PendingAggregatePolicy;
import org.xcmis.spi.utils.Logger;

public class CacheableIndexDataManager
extends LocalIndexDataManagerProxy {
    private final LuceneIndexDataKeeperFactory dataKeeperFactory;
    private final AggregatePolicy inMemoryAggregationPolicy;
    private static final Logger LOG = Logger.getLogger(CacheableIndexDataManager.class);
    private final List<LuceneIndexDataManager> memoryChains;
    private final PendingAggregatePolicy persistentAggregationPolicy;
    private volatile long lastFlushTime;
    private TimerTask flushTask;
    private static final Timer FLUSH_TIMER = new Timer(true);
    private static final int DEFAULT_IDLE_TIME = 10000;
    private boolean isStoped = false;
    private final Object updateMonitor = new Object();

    public CacheableIndexDataManager(IndexConfiguration indexConfuguration) throws IndexException, IndexConfigurationException {
        super(indexConfuguration);
        this.dataKeeperFactory = new InMemoryIndexDataKeeperFactory();
        this.memoryChains = new ArrayList<LuceneIndexDataManager>();
        this.inMemoryAggregationPolicy = new MaxCandidatsCountAggrigatePolicy(new PendingAggregatePolicy());
        this.persistentAggregationPolicy = new PendingAggregatePolicy();
        this.persistentAggregationPolicy.setMaxDirSize(Integer.MAX_VALUE);
        this.persistentAggregationPolicy.setMinDirSize(0x100000);
        this.persistentAggregationPolicy.setMaxDocuments4Dir(Integer.MAX_VALUE);
        this.persistentAggregationPolicy.setMinDocuments4Dir(100);
        this.persistentAggregationPolicy.setMinAggregateTime(1000);
        this.persistentAggregationPolicy.setMinModificationTime(3000);
        this.scheduleFlushTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexTransactionModificationReport aggregate(Collection<LuceneIndexDataManager> indexes) throws IndexException, IndexTransactionException {
        Collection<LuceneIndexDataManager> collection = indexes;
        synchronized (collection) {
            Collection<LuceneIndexDataManager> candidats2Save;
            Collection<LuceneIndexDataManager> candidats;
            if (indexes.size() > 2 && (candidats = this.inMemoryAggregationPolicy.findIndexDataManagerToAggrigate(indexes, 0L, 0L)).size() > 1) {
                LuceneIndexDataManager mergedChain = this.dataKeeperFactory.merge(candidats);
                for (LuceneIndexDataManager luceneIndexDataManager : candidats) {
                    this.dataKeeperFactory.dispose(luceneIndexDataManager);
                    indexes.remove(luceneIndexDataManager);
                }
                indexes.add(mergedChain);
            }
            if ((candidats2Save = this.persistentAggregationPolicy.findIndexDataManagerToAggrigate(indexes, 0L, 0L)).size() > 0) {
                Object object = this.updateMonitor;
                synchronized (object) {
                    super.aggregate(candidats2Save);
                    for (LuceneIndexDataManager luceneIndexDataManager : candidats2Save) {
                        this.dataKeeperFactory.dispose(luceneIndexDataManager);
                        ((TransactionableLuceneIndexDataManager)luceneIndexDataManager).getTransactionLog().removeLog();
                        indexes.remove(luceneIndexDataManager);
                    }
                    this.lastFlushTime = System.currentTimeMillis();
                }
            }
        }
        return null;
    }

    @Override
    public Directory getDirectory() throws IndexException {
        return super.getDirectory();
    }

    @Override
    public long getDirectorySize(boolean includeInherited) {
        long result = 0L;
        if (this.memoryChains.size() != 0) {
            if (includeInherited) {
                result = super.getDirectorySize(true);
            }
            for (LuceneIndexDataManager dm : this.memoryChains) {
                result += dm.getDirectorySize(includeInherited);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document getDocument(String uuid) throws IndexException {
        Document doc = null;
        List<LuceneIndexDataManager> list = this.memoryChains;
        synchronized (list) {
            for (int i = 0; i < this.memoryChains.size() && (doc = (Document)this.memoryChains.get(i).getDocument(uuid)) == null; ++i) {
            }
        }
        if (doc == null) {
            doc = super.getDocument(uuid);
        }
        return doc;
    }

    @Override
    public long getDocumentCount() {
        long result = super.getDocumentCount();
        for (LuceneIndexDataManager dm : this.memoryChains) {
            result += dm.getDocumentCount();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexReader getIndexReader() throws IndexException {
        List<LuceneIndexDataManager> list = this.memoryChains;
        synchronized (list) {
            Object object = this.updateMonitor;
            synchronized (object) {
                IndexReader result = super.getIndexReader();
                if (this.memoryChains.size() > 0) {
                    ArrayList<IndexReader> readers = new ArrayList<IndexReader>(this.memoryChains.size());
                    for (LuceneIndexDataManager chain : this.memoryChains) {
                        IndexReader indexReader = (IndexReader)chain.getIndexReader();
                        if (indexReader == null) continue;
                        readers.add(indexReader);
                    }
                    if (result != null) {
                        readers.add(result);
                    }
                    if (readers.size() > 1) {
                        IndexReader[] indexReaders = new IndexReader[readers.size()];
                        result = new MultiReader(readers.toArray(indexReaders));
                    } else if (readers.size() == 1) {
                        result = (IndexReader)readers.get(0);
                    } else {
                        throw new IndexReaderNotFoundException("No readers found");
                    }
                }
                if (result == null) {
                    try {
                        RAMDirectory directory = new RAMDirectory();
                        IndexWriter.MaxFieldLength fieldLength = new IndexWriter.MaxFieldLength(10000);
                        IndexWriter iw = new IndexWriter((Directory)directory, (Analyzer)new SimpleAnalyzer(), true, fieldLength);
                        iw.close();
                        result = IndexReader.open((Directory)directory);
                    }
                    catch (IOException e) {
                        throw new IndexException("Unable to initialize index: empty index ");
                    }
                }
                return result;
            }
        }
    }

    private void scheduleFlushTask() {
        if (this.flushTask != null) {
            this.flushTask.cancel();
        }
        FLUSH_TIMER.purge();
        this.flushTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long idleTime = System.currentTimeMillis() - CacheableIndexDataManager.this.lastFlushTime;
                if (idleTime > 10000L && CacheableIndexDataManager.this.memoryChains.size() > 0) {
                    List list = CacheableIndexDataManager.this.memoryChains;
                    synchronized (list) {
                        try {
                            CacheableIndexDataManager.this.flash();
                        }
                        catch (TransactionLogException e) {
                            LOG.error(e.getLocalizedMessage(), (Throwable)e);
                        }
                        catch (IndexTransactionException e) {
                            LOG.error(e.getLocalizedMessage(), (Throwable)e);
                        }
                        catch (IndexException e) {
                            LOG.error(e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                }
            }
        };
        FLUSH_TIMER.schedule(this.flushTask, 0L, 1000L);
        this.lastFlushTime = System.currentTimeMillis();
    }

    @Override
    public long getLastModifedTime() {
        return super.getLastModifedTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexTransactionModificationReport save(IndexTransaction<Document> changes) throws IndexException, IndexTransactionException {
        List<LuceneIndexDataManager> list = this.memoryChains;
        synchronized (list) {
            if (changes.hasModifacationsDocuments()) {
                changes = this.processModifed(changes);
            }
            if (150 > changes.getAddedDocuments().size()) {
                changes = changes.apply(this.processAdded(changes));
            }
            if (changes.hasAddedDocuments() || changes.hasModifacationsDocuments()) {
                super.save(changes);
            }
        }
        this.aggregate(this.memoryChains);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            if (this.memoryChains.size() > 0) {
                List<LuceneIndexDataManager> list = this.memoryChains;
                synchronized (list) {
                    this.flash();
                    this.isStoped = true;
                }
            }
            if (this.flushTask != null) {
                this.flushTask.cancel();
            }
            FLUSH_TIMER.purge();
            FLUSH_TIMER.cancel();
        }
        catch (ConcurrentModificationException e) {
            e.printStackTrace();
        }
        catch (IndexException e) {
            e.printStackTrace();
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flash() throws IndexException, IndexTransactionException, TransactionLogException {
        if (!this.isStoped) {
            Object object = this.updateMonitor;
            synchronized (object) {
                super.aggregate(this.memoryChains);
                for (LuceneIndexDataManager luceneIndexDataManager : this.memoryChains) {
                    this.dataKeeperFactory.dispose(luceneIndexDataManager);
                    ((TransactionableLuceneIndexDataManager)luceneIndexDataManager).getTransactionLog().removeLog();
                }
                this.memoryChains.clear();
                this.lastFlushTime = System.currentTimeMillis();
            }
        }
    }

    private void dump() {
        LOG.info("====" + this.memoryChains.size() + "=====");
        for (LuceneIndexDataManager luceneIndexDataManager : this.memoryChains) {
            LOG.info(luceneIndexDataManager.getDirectorySize(false) + "\t\t" + luceneIndexDataManager.getDocumentCount() + "\t\t" + (System.currentTimeMillis() - luceneIndexDataManager.getLastModifedTime()) + " msec");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexTransactionModificationReportImpl processAdded(IndexTransaction<Document> changes) throws IndexException {
        if (changes.getAddedDocuments().size() > 0) {
            LuceneIndexDataManager indexDataKeeper = this.dataKeeperFactory.createNewIndexDataKeeper(changes);
            indexDataKeeper.start();
            List<LuceneIndexDataManager> list = this.memoryChains;
            synchronized (list) {
                this.memoryChains.add(indexDataKeeper);
            }
        }
        return new IndexTransactionModificationReportImpl(changes.getAddedDocuments().keySet(), new HashSet<String>(), new HashSet<String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexTransaction<Document> processModifed(IndexTransaction<Document> changes) throws IndexException, IndexTransactionException {
        List<LuceneIndexDataManager> list = this.memoryChains;
        synchronized (list) {
            Iterator<LuceneIndexDataManager> it = this.memoryChains.iterator();
            while (it.hasNext()) {
                LuceneIndexDataManager chain = it.next();
                IndexTransactionModificationReport report = chain.save(changes);
                if (report.isModifed()) {
                    changes = changes.apply(report);
                    if (chain.getDocumentCount() == 0L) {
                        this.dataKeeperFactory.dispose(chain);
                        ((TransactionableLuceneIndexDataManager)chain).getTransactionLog().removeLog();
                        it.remove();
                    }
                }
                if (changes.hasModifacationsDocuments()) continue;
                break;
            }
        }
        return changes;
    }
}

