/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.LevensteinDistance;
import org.apache.lucene.search.spell.StringDistance;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.search.spell.SuggestWordQueue;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;

public class SpellChecker {
    public static final String F_WORD = "word";
    private static final Term F_WORD_TERM = new Term("word");
    Directory spellIndex;
    private float bStart = 2.0f;
    private float bEnd = 1.0f;
    private IndexSearcher searcher;
    private final Object searcherLock = new Object();
    private final Object modifyCurrentIndexLock = new Object();
    private volatile boolean closed = false;
    private float minScore = 0.5f;
    private StringDistance sd;

    public SpellChecker(Directory spellIndex, StringDistance sd) throws IOException {
        this.setSpellIndex(spellIndex);
        this.setStringDistance(sd);
    }

    public SpellChecker(Directory spellIndex) throws IOException {
        this(spellIndex, new LevensteinDistance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpellIndex(Directory spellIndexDir) throws IOException {
        Object object = this.modifyCurrentIndexLock;
        synchronized (object) {
            this.ensureOpen();
            if (!IndexReader.indexExists((Directory)spellIndexDir)) {
                IndexWriter writer = new IndexWriter(spellIndexDir, null, true, IndexWriter.MaxFieldLength.UNLIMITED);
                writer.close();
            }
            this.swapSearcher(spellIndexDir);
        }
    }

    public void setStringDistance(StringDistance sd) {
        this.sd = sd;
    }

    public StringDistance getStringDistance() {
        return this.sd;
    }

    public void setAccuracy(float minScore) {
        this.minScore = minScore;
    }

    public String[] suggestSimilar(String word, int numSug) throws IOException {
        return this.suggestSimilar(word, numSug, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] suggestSimilar(String word, int numSug, IndexReader ir, String field, boolean morePopular) throws IOException {
        IndexSearcher indexSearcher = this.obtainSearcher();
        try {
            int goalFreq;
            float min = this.minScore;
            int lengthWord = word.length();
            int freq = ir != null && field != null ? ir.docFreq(new Term(field, word)) : 0;
            int n = goalFreq = morePopular && ir != null && field != null ? freq : 0;
            if (!morePopular && freq > 0) {
                String[] stringArray = new String[]{word};
                return stringArray;
            }
            BooleanQuery query = new BooleanQuery();
            for (int ng = SpellChecker.getMin(lengthWord); ng <= SpellChecker.getMax(lengthWord); ++ng) {
                String key = "gram" + ng;
                String[] grams = SpellChecker.formGrams(word, ng);
                if (grams.length == 0) continue;
                if (this.bStart > 0.0f) {
                    SpellChecker.add(query, "start" + ng, grams[0], this.bStart);
                }
                if (this.bEnd > 0.0f) {
                    SpellChecker.add(query, "end" + ng, grams[grams.length - 1], this.bEnd);
                }
                for (int i = 0; i < grams.length; ++i) {
                    SpellChecker.add(query, key, grams[i]);
                }
            }
            int maxHits = 10 * numSug;
            ScoreDoc[] hits = indexSearcher.search((Query)query, null, (int)maxHits).scoreDocs;
            SuggestWordQueue sugQueue = new SuggestWordQueue(numSug);
            int stop = Math.min(hits.length, maxHits);
            SuggestWord sugWord = new SuggestWord();
            for (int i = 0; i < stop; ++i) {
                sugWord.string = indexSearcher.doc(hits[i].doc).get(F_WORD);
                if (sugWord.string.equals(word)) continue;
                sugWord.score = this.sd.getDistance(word, sugWord.string);
                if (sugWord.score < min) continue;
                if (ir != null && field != null) {
                    sugWord.freq = ir.docFreq(new Term(field, sugWord.string));
                    if (morePopular && goalFreq > sugWord.freq || sugWord.freq < 1) continue;
                }
                sugQueue.insertWithOverflow(sugWord);
                if (sugQueue.size() == numSug) {
                    min = ((SuggestWord)sugQueue.top()).score;
                }
                sugWord = new SuggestWord();
            }
            String[] list = new String[sugQueue.size()];
            for (int i = sugQueue.size() - 1; i >= 0; --i) {
                list[i] = ((SuggestWord)sugQueue.pop()).string;
            }
            String[] stringArray = list;
            return stringArray;
        }
        finally {
            this.releaseSearcher(indexSearcher);
        }
    }

    private static void add(BooleanQuery q, String name, String value, float boost) {
        TermQuery tq = new TermQuery(new Term(name, value));
        tq.setBoost(boost);
        q.add(new BooleanClause((Query)tq, BooleanClause.Occur.SHOULD));
    }

    private static void add(BooleanQuery q, String name, String value) {
        q.add(new BooleanClause((Query)new TermQuery(new Term(name, value)), BooleanClause.Occur.SHOULD));
    }

    private static String[] formGrams(String text, int ng) {
        int len = text.length();
        String[] res = new String[len - ng + 1];
        for (int i = 0; i < len - ng + 1; ++i) {
            res[i] = text.substring(i, i + ng);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearIndex() throws IOException {
        Object object = this.modifyCurrentIndexLock;
        synchronized (object) {
            this.ensureOpen();
            Directory dir = this.spellIndex;
            IndexWriter writer = new IndexWriter(dir, null, true, IndexWriter.MaxFieldLength.UNLIMITED);
            writer.close();
            this.swapSearcher(dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exist(String word) throws IOException {
        IndexSearcher indexSearcher = this.obtainSearcher();
        try {
            boolean bl = indexSearcher.docFreq(F_WORD_TERM.createTerm(word)) > 0;
            return bl;
        }
        finally {
            this.releaseSearcher(indexSearcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexDictionary(Dictionary dict, int mergeFactor, int ramMB) throws IOException {
        Object object = this.modifyCurrentIndexLock;
        synchronized (object) {
            this.ensureOpen();
            Directory dir = this.spellIndex;
            IndexWriter writer = new IndexWriter(dir, (Analyzer)new WhitespaceAnalyzer(), IndexWriter.MaxFieldLength.UNLIMITED);
            writer.setMergeFactor(mergeFactor);
            writer.setRAMBufferSizeMB((double)ramMB);
            Iterator iter = dict.getWordsIterator();
            while (iter.hasNext()) {
                String word = (String)iter.next();
                int len = word.length();
                if (len < 3 || this.exist(word)) continue;
                Document doc = SpellChecker.createDocument(word, SpellChecker.getMin(len), SpellChecker.getMax(len));
                writer.addDocument(doc);
            }
            writer.optimize();
            writer.close();
            this.swapSearcher(dir);
        }
    }

    public void indexDictionary(Dictionary dict) throws IOException {
        this.indexDictionary(dict, 300, 10);
    }

    private static int getMin(int l) {
        if (l > 5) {
            return 3;
        }
        if (l == 5) {
            return 2;
        }
        return 1;
    }

    private static int getMax(int l) {
        if (l > 5) {
            return 4;
        }
        if (l == 5) {
            return 3;
        }
        return 2;
    }

    private static Document createDocument(String text, int ng1, int ng2) {
        Document doc = new Document();
        doc.add((Fieldable)new Field(F_WORD, text, Field.Store.YES, Field.Index.NOT_ANALYZED));
        SpellChecker.addGram(text, doc, ng1, ng2);
        return doc;
    }

    private static void addGram(String text, Document doc, int ng1, int ng2) {
        int len = text.length();
        for (int ng = ng1; ng <= ng2; ++ng) {
            String key = "gram" + ng;
            String end = null;
            for (int i = 0; i < len - ng + 1; ++i) {
                String gram = text.substring(i, i + ng);
                doc.add((Fieldable)new Field(key, gram, Field.Store.NO, Field.Index.NOT_ANALYZED));
                if (i == 0) {
                    doc.add((Fieldable)new Field("start" + ng, gram, Field.Store.NO, Field.Index.NOT_ANALYZED));
                }
                end = gram;
            }
            if (end == null) continue;
            doc.add((Fieldable)new Field("end" + ng, end, Field.Store.NO, Field.Index.NOT_ANALYZED));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexSearcher obtainSearcher() {
        Object object = this.searcherLock;
        synchronized (object) {
            this.ensureOpen();
            this.searcher.getIndexReader().incRef();
            return this.searcher;
        }
    }

    private void releaseSearcher(IndexSearcher aSearcher) throws IOException {
        aSearcher.getIndexReader().decRef();
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new AlreadyClosedException("Spellchecker has been closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.searcherLock;
        synchronized (object) {
            this.ensureOpen();
            this.closed = true;
            if (this.searcher != null) {
                this.searcher.close();
            }
            this.searcher = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swapSearcher(Directory dir) throws IOException {
        IndexSearcher indexSearcher = this.createSearcher(dir);
        Object object = this.searcherLock;
        synchronized (object) {
            if (this.closed) {
                indexSearcher.close();
                throw new AlreadyClosedException("Spellchecker has been closed");
            }
            if (this.searcher != null) {
                this.searcher.close();
            }
            this.searcher = indexSearcher;
            this.spellIndex = dir;
        }
    }

    IndexSearcher createSearcher(Directory dir) throws IOException {
        return new IndexSearcher(dir, true);
    }

    boolean isClosed() {
        return this.closed;
    }
}

