/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.image;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.Sanselan;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.rewrite.image.OptimizerConfig;

abstract class BaseOptimizer {
    static final Map<String, ImageFormat> FORMAT_NAME_TO_IMAGE_FORMAT = ImmutableMap.of((Object)"png", (Object)ImageFormat.IMAGE_FORMAT_PNG, (Object)"gif", (Object)ImageFormat.IMAGE_FORMAT_GIF, (Object)"jpeg", (Object)ImageFormat.IMAGE_FORMAT_JPEG);
    final HttpResponseBuilder response;
    final OptimizerConfig config;
    protected ImageOutputter outputter;
    protected byte[] minBytes;
    protected int minLength;
    int reductionPct;

    public BaseOptimizer(OptimizerConfig config, HttpResponseBuilder response) {
        this.config = config;
        this.response = response;
        this.minLength = response.getContentLength();
        this.outputter = this.getOutputter();
    }

    protected ImageOutputter getOutputter() {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(this.getOriginalFormatName());
        if (writers.hasNext()) {
            ImageWriter writer = writers.next();
            ImageWriteParam param = writer.getDefaultWriteParam();
            if (this.getOriginalFormatName().equals("jpeg")) {
                param.setCompressionMode(2);
                param.setCompressionQuality(this.config.getJpegCompression());
            }
            return new ImageIOOutputter(writer, param);
        }
        return new SanselanOutputter(FORMAT_NAME_TO_IMAGE_FORMAT.get(this.getOriginalFormatName()));
    }

    protected void write(BufferedImage image) throws IOException {
        if (image == null) {
            return;
        }
        byte[] bytes = this.outputter.toBytes(image);
        if (this.minLength > bytes.length) {
            this.minBytes = bytes;
            this.minLength = this.minBytes.length;
            this.reductionPct = (this.response.getContentLength() - this.minLength) * 100 / this.response.getContentLength();
        }
    }

    public void rewrite(BufferedImage image) throws IOException {
        if (this.outputter == null) {
            return;
        }
        long time = System.currentTimeMillis();
        this.rewriteImpl(image);
        time = System.currentTimeMillis() - time;
        if (this.minBytes != null && this.minBytes.length != 0) {
            StringBuilder rewriteMsg = new StringBuilder(24);
            rewriteMsg.append("c=").append(this.minBytes.length * 100 / this.response.getContentLength());
            if (!this.getOutputContentType().equals(this.getOriginalContentType())) {
                rewriteMsg.append(";o=").append(this.getOriginalContentType());
            }
            rewriteMsg.append(";t=").append(time);
            this.response.clearAllHeaders().setHeader("Content-Type", this.getOutputContentType()).setHeader("X-Shindig-Rewrite", rewriteMsg.toString()).setResponse(this.minBytes);
        }
    }

    protected final byte[] getRewrittenImage() {
        return this.minBytes;
    }

    protected abstract void rewriteImpl(BufferedImage var1) throws IOException;

    protected abstract String getOutputContentType();

    protected abstract String getOriginalContentType();

    protected abstract String getOriginalFormatName();

    public static class SanselanOutputter
    implements ImageOutputter {
        ImageFormat format;
        ByteArrayOutputStream baos;

        public SanselanOutputter(ImageFormat format) {
            this.format = format;
        }

        public byte[] toBytes(BufferedImage image) throws IOException {
            if (this.baos == null) {
                this.baos = new ByteArrayOutputStream();
            } else {
                this.baos.reset();
            }
            try {
                Sanselan.writeImage((BufferedImage)image, (OutputStream)this.baos, (ImageFormat)this.format, (Map)Maps.newHashMap());
                return this.baos.toByteArray();
            }
            catch (ImageWriteException iwe) {
                throw new IOException(iwe.getMessage());
            }
        }
    }

    public static class ImageIOOutputter
    implements ImageOutputter {
        ImageWriter writer;
        ByteArrayOutputStream baos;
        ImageWriteParam writeParam;

        public ImageIOOutputter(ImageWriter writer, ImageWriteParam writeParam) {
            this.writer = writer;
            this.writeParam = (ImageWriteParam)Objects.firstNonNull((Object)writeParam, (Object)writer.getDefaultWriteParam());
        }

        public byte[] toBytes(BufferedImage image) throws IOException {
            if (this.baos == null) {
                this.baos = new ByteArrayOutputStream();
            } else {
                this.baos.reset();
            }
            this.writer.setOutput(ImageIO.createImageOutputStream(this.baos));
            IIOMetadata metadata = this.writer.getDefaultImageMetadata(new ImageTypeSpecifier(image.getColorModel(), image.getSampleModel()), this.writeParam);
            this.writer.write(new IIOImage(image, Collections.emptyList(), metadata));
            return this.baos.toByteArray();
        }
    }

    public static interface ImageOutputter {
        public byte[] toBytes(BufferedImage var1) throws IOException;
    }
}

