/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.common.servlet.InjectedServlet;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.LockedDomainService;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.servlet.ProxyHandler;
import org.apache.shindig.gadgets.servlet.ServletUtil;
import org.apache.shindig.gadgets.uri.ProxyUriManager;

public class ProxyServlet
extends InjectedServlet {
    private static final long serialVersionUID = 9085050443492307723L;
    private static final Logger LOG = Logger.getLogger(ProxyServlet.class.getName());
    private transient ProxyUriManager proxyUriManager;
    private transient LockedDomainService lockedDomainService;
    private transient ProxyHandler proxyHandler;

    @Inject
    public void setProxyHandler(ProxyHandler proxyHandler) {
        this.checkInitialized();
        this.proxyHandler = proxyHandler;
    }

    @Inject
    public void setProxyUriManager(ProxyUriManager proxyUriManager) {
        this.checkInitialized();
        this.proxyUriManager = proxyUriManager;
    }

    @Inject
    public void setLockedDomainService(LockedDomainService lockedDomainService) {
        this.checkInitialized();
        this.lockedDomainService = lockedDomainService;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse servletResponse) throws IOException {
        if (request.getHeader("If-Modified-Since") != null) {
            servletResponse.setStatus(304);
            return;
        }
        Uri reqUri = new UriBuilder(request).toUri();
        HttpResponse response = null;
        try {
            ProxyUriManager.ProxyUri proxyUri = this.proxyUriManager.process(reqUri);
            String host = request.getHeader("Host");
            if (!this.lockedDomainService.isSafeForOpenProxy(host)) {
                Uri resourceUri = proxyUri.getResource();
                String msg = "Embed request for url " + (resourceUri != null ? resourceUri.toString() : "n/a") + " made to wrong domain " + host;
                LOG.info(msg);
                throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, msg, 400);
            }
            response = this.proxyHandler.fetch(proxyUri);
        }
        catch (GadgetException e) {
            response = ServletUtil.errorResponse(new GadgetException(e.getCode(), e.getMessage(), 400));
        }
        ServletUtil.copyResponseToServlet(response, servletResponse);
    }
}

