/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ant;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.SQLExec;
import org.hibernate.cfg.Configuration;
import org.jbpm.ant.AntHelper;
import org.jbpm.db.JbpmSchema;
import org.jbpm.util.IoUtil;

public class JbpmSchemaTask
extends Task {
    String config = "hibernate.cfg.xml";
    String properties;
    String action = "create";
    String output;
    String delimiter = ";";
    String delimiterType = "normal";

    public void execute() throws BuildException {
        String[] script;
        JbpmSchema jbpmSchema = this.getJbpmSchema();
        if ("create".equalsIgnoreCase(this.action)) {
            script = jbpmSchema.getCreateSql();
        } else if ("update".equalsIgnoreCase(this.action)) {
            try {
                script = jbpmSchema.getUpdateSql();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        } else if ("drop".equalsIgnoreCase(this.action)) {
            script = jbpmSchema.getDropSql();
        } else if ("clean".equalsIgnoreCase(this.action)) {
            script = jbpmSchema.getCleanSql();
        } else {
            throw new BuildException("Unsupported action: " + this.action);
        }
        List exceptions = jbpmSchema.getExceptions();
        if (!exceptions.isEmpty()) {
            Iterator i = exceptions.iterator();
            while (i.hasNext()) {
                Object exception = i.next();
                this.log(exception.toString(), 0);
            }
        }
        try {
            this.saveScript(script, jbpmSchema);
        }
        catch (IOException e) {
            this.log(e.toString(), 0);
            throw new BuildException("Failed to write script to " + this.output);
        }
    }

    private JbpmSchema getJbpmSchema() {
        Configuration configuration = AntHelper.getConfiguration(this.config, this.properties);
        JbpmSchema jbpmSchema = new JbpmSchema(configuration);
        jbpmSchema.setDelimiter("row".equals(this.delimiterType) ? IoUtil.lineSeparator + this.delimiter : this.delimiter);
        return jbpmSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveScript(String[] script, JbpmSchema jbpmSchema) throws IOException {
        FileWriter writer = new FileWriter(this.output);
        try {
            jbpmSchema.writeSql(writer, script);
        }
        finally {
            ((Writer)writer).close();
        }
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setDelimiterType(SQLExec.DelimiterType delimiterType) {
        this.delimiterType = delimiterType.getValue();
    }

    public void setOutput(String output) {
        this.output = output;
    }
}

