/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.presentation.removeattach;

import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.ecm.webui.presentation.AbstractActionComponent;
import org.exoplatform.ecm.webui.presentation.action.UIPresentationEventListener;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.Event;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={RemoveAttachActionListener.class}, confirm="RemoveAttachmentComponent.msg.confirm-deleteattachment")})
public class RemoveAttachmentComponent
extends AbstractActionComponent {
    private static final Log LOG = ExoLogger.getLogger(RemoveAttachmentComponent.class);

    protected String loadConfirmMesssage(Event event, WebuiRequestContext context, String beanId) {
        String confirmKey = event.getConfirm();
        if (confirmKey.length() < 1) {
            return confirmKey;
        }
        try {
            String confirm = Utils.getResourceBundle("locale.portlet.i18n.WebUIDms", confirmKey, ((Object)((Object)this)).getClass().getClassLoader());
            return confirm.replaceAll("\\{0\\}", beanId);
        }
        catch (Exception e) {
            return confirmKey;
        }
    }

    public static void doDelete(Map<String, Object> variables) throws Exception {
        AbstractActionComponent uicomponent = (AbstractActionComponent)((Object)variables.get("uicomponent"));
        UIApplication uiApp = (UIApplication)uicomponent.getAncestorOfType(UIApplication.class);
        NodeFinder nodefinder = (NodeFinder)uicomponent.getApplicationComponent(NodeFinder.class);
        String wsname = String.valueOf(variables.get("workspaceName"));
        String nodepath = String.valueOf(variables.get("objectId"));
        WebuiRequestContext requestcontext = (WebuiRequestContext)variables.get("requestcontext");
        try {
            Node node = (Node)nodefinder.getItem(wsname, nodepath);
            Session session = node.getSession();
            Node parentNode = null;
            if (nodepath.startsWith("/")) {
                if (node.hasProperty("jcr:data")) {
                    node.setProperty("jcr:data", "");
                    node.save();
                } else {
                    parentNode = node.getParent();
                    node.remove();
                    parentNode.save();
                }
            } else if (node.hasProperty(nodepath)) {
                node.setProperty(nodepath, "");
                node.save();
            }
            session.save();
            uicomponent.updateAjax(requestcontext);
            return;
        }
        catch (Exception e) {
            LOG.error((Object)"an unexpected error occurs while removing the node", (Throwable)e);
            JCRExceptionManager.process(uiApp, e);
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveAttachActionListener
    extends UIPresentationEventListener<RemoveAttachmentComponent> {
        @Override
        protected void executeAction(Map<String, Object> variables) throws Exception {
            RemoveAttachmentComponent.doDelete(variables);
        }
    }
}

