/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.directory.IndexInputStream;
import org.exoplatform.services.jcr.impl.core.query.lucene.directory.IndexOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexInfos {
    public static final String DEFALUT_NAME = "indexes";
    private int counter = 0;
    private boolean dirty = false;
    private List<String> indexes = new ArrayList<String>();
    private Set<String> names = new HashSet<String>();
    private final String name;
    private Directory dir;
    private MultiIndex multiIndex;

    public IndexInfos() {
        this(DEFALUT_NAME);
    }

    public IndexInfos(String fileName) {
        this.name = fileName;
    }

    public String getFileName() {
        return this.name;
    }

    public void read() throws IOException {
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                IndexInfos.this.dir.list();
                IndexInfos.this.names.clear();
                IndexInfos.this.indexes.clear();
                if (IndexInfos.this.dir.fileExists(IndexInfos.this.name)) {
                    IndexInputStream in = new IndexInputStream(IndexInfos.this.dir.openInput(IndexInfos.this.name));
                    try {
                        DataInputStream di = new DataInputStream(in);
                        IndexInfos.this.counter = di.readInt();
                        for (int i = di.readInt(); i > 0; --i) {
                            String indexName = di.readUTF();
                            IndexInfos.this.indexes.add(indexName);
                            IndexInfos.this.names.add(indexName);
                        }
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                }
                return null;
            }
        });
    }

    public void write() throws IOException {
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                if (!IndexInfos.this.dirty) {
                    return null;
                }
                IndexOutputStream out = new IndexOutputStream(IndexInfos.this.dir.createOutput(IndexInfos.this.name + ".new"));
                try {
                    DataOutputStream dataOut = new DataOutputStream(out);
                    dataOut.writeInt(IndexInfos.this.counter);
                    dataOut.writeInt(IndexInfos.this.indexes.size());
                    for (int i = 0; i < IndexInfos.this.indexes.size(); ++i) {
                        dataOut.writeUTF(IndexInfos.this.getName(i));
                    }
                }
                finally {
                    ((OutputStream)out).close();
                }
                if (IndexInfos.this.dir.fileExists(IndexInfos.this.name)) {
                    IndexInfos.this.dir.deleteFile(IndexInfos.this.name);
                }
                IndexInfos.this.dir.renameFile(IndexInfos.this.name + ".new", IndexInfos.this.name);
                IndexInfos.this.dirty = false;
                return null;
            }
        });
    }

    public String getName(int i) {
        return this.indexes.get(i);
    }

    public Set<String> getNames() {
        return new HashSet<String>(this.indexes);
    }

    public int size() {
        return this.indexes.size();
    }

    public void addName(String name) {
        if (this.names.contains(name)) {
            throw new IllegalArgumentException("already contains: " + name);
        }
        this.indexes.add(name);
        this.names.add(name);
        this.dirty = true;
    }

    public void removeName(String name) {
        this.indexes.remove(name);
        this.names.remove(name);
        this.dirty = true;
    }

    public void removeName(int i) {
        String name = this.indexes.remove(i);
        this.names.remove(name);
        this.dirty = true;
    }

    public boolean contains(String name) {
        return this.names.contains(name);
    }

    public String newName() {
        this.dirty = true;
        return "_" + Integer.toString(this.counter++, 36);
    }

    public void setDirectory(Directory dir) {
        this.dir = dir;
    }

    protected void setNames(Set<String> names) {
        this.names.clear();
        this.indexes.clear();
        this.names.addAll(names);
        this.indexes.addAll(names);
        this.dirty = false;
    }

    public void setMultiIndex(MultiIndex multiIndex) {
        this.multiIndex = multiIndex;
    }

    public MultiIndex getMultiIndex() {
        return this.multiIndex;
    }

    protected boolean isDirty() {
        return this.dirty;
    }
}

