/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.RepositoryServiceConfiguration;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.ext.backup.BackupConfig;
import org.exoplatform.services.jcr.ext.backup.BackupJob;
import org.exoplatform.services.jcr.ext.backup.BackupOperationException;
import org.exoplatform.services.jcr.ext.backup.JobEntryInfo;
import org.exoplatform.services.jcr.ext.backup.server.WorkspaceRestoreExeption;
import org.exoplatform.services.jcr.impl.util.JCRDateFormat;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackupChainLog {
    protected static String VERSION_LOG_1_1 = "1.1";
    protected static Log logger = ExoLogger.getLogger("exo.jcr.component.ext.BackupChainLog");
    public static final String PREFIX = "backup-";
    private static final String SUFFIX = ".xml";
    private File log;
    private String configInfo;
    private final List<JobEntryInfo> jobEntries;
    private LogWriter logWriter;
    private LogReader logReader;
    private BackupConfig config;
    private String backupId;
    private Calendar startedTime;
    private Calendar finishedTime;
    private boolean finalized;
    private WorkspaceEntry originalWorkspaceEntry;
    private final String versionLog;
    private File rootDir;
    private String fullBackupType;
    private String incrementalBackupType;

    public BackupChainLog(File logDir, BackupConfig config, String fullBackupType, String incrementalBackupType, String backupId, RepositoryServiceConfiguration repositoryServiceConfiguration, File rootDir) throws BackupOperationException {
        try {
            this.finalized = false;
            this.versionLog = VERSION_LOG_1_1;
            this.log = new File(PrivilegedFileHelper.getCanonicalPath(logDir) + File.separator + PREFIX + backupId + SUFFIX);
            PrivilegedFileHelper.createNewFile(this.log);
            this.rootDir = rootDir;
            this.backupId = backupId;
            this.fullBackupType = fullBackupType;
            this.incrementalBackupType = incrementalBackupType;
            this.config = config;
            this.jobEntries = new ArrayList<JobEntryInfo>();
            this.originalWorkspaceEntry = this.getWorkspaceEntry(config, repositoryServiceConfiguration);
            this.logWriter = new LogWriter(this.log);
            this.logWriter.write(config, fullBackupType, incrementalBackupType);
            this.logWriter.writeWorkspaceEntry(this.originalWorkspaceEntry, repositoryServiceConfiguration);
        }
        catch (IOException e) {
            throw new BackupOperationException(e);
        }
        catch (XMLStreamException e) {
            throw new BackupOperationException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new BackupOperationException(e);
        }
        catch (JiBXException e) {
            throw new BackupOperationException(e);
        }
        catch (RepositoryException e) {
            throw new BackupOperationException(e);
        }
        catch (RepositoryConfigurationException e) {
            throw new BackupOperationException(e);
        }
    }

    private WorkspaceEntry getWorkspaceEntry(BackupConfig config, RepositoryServiceConfiguration repositoryServiceConfiguration) throws BackupOperationException {
        RepositoryEntry repository = null;
        try {
            repository = repositoryServiceConfiguration.getRepositoryConfiguration(config.getRepository());
        }
        catch (RepositoryConfigurationException e) {
            throw new BackupOperationException("Can not get repository \"" + config.getRepository() + "\"", e);
        }
        WorkspaceEntry wEntry = null;
        for (WorkspaceEntry entry : repository.getWorkspaceEntries()) {
            if (!entry.getName().equals(config.getWorkspace())) continue;
            wEntry = entry;
            break;
        }
        if (wEntry == null) {
            throw new BackupOperationException("Worksapce \"" + config.getWorkspace() + "\" was not exsisted in repository \"" + repository.getName() + "\".");
        }
        return wEntry;
    }

    public BackupChainLog(File log) throws BackupOperationException {
        this.log = log;
        this.backupId = log.getName().replaceAll(PREFIX, "").replaceAll(SUFFIX, "");
        try {
            this.logReader = new LogReader(log);
            this.logReader.readLogFile();
            this.logReader.jobEntrysNormalize();
            this.versionLog = this.logReader.getVersionLog();
            this.config = this.logReader.getBackupConfig();
            this.startedTime = this.logReader.getBeginTime();
            this.finishedTime = this.logReader.getEndTime();
            this.jobEntries = this.logReader.getJobEntryInfoNormalizeList();
            this.originalWorkspaceEntry = this.logReader.getOriginalWorkspaceEntry();
            this.fullBackupType = this.logReader.getFullBackupType();
            this.incrementalBackupType = this.logReader.getIncrementalBackupType();
            for (JobEntryInfo info : this.jobEntries) {
                if (info.getType() != 2) continue;
                this.config.setBackupType(1);
                break;
            }
        }
        catch (FileNotFoundException e) {
            throw new BackupOperationException(e);
        }
        catch (XMLStreamException e) {
            throw new BackupOperationException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new BackupOperationException(e);
        }
        catch (MalformedURLException e) {
            throw new BackupOperationException(e);
        }
        catch (ValueFormatException e) {
            throw new BackupOperationException(e);
        }
        catch (Exception e) {
            throw new BackupOperationException(e);
        }
    }

    public void addJobEntry(BackupJob job) {
        try {
            JobEntryInfo info = new JobEntryInfo();
            info.setDate(Calendar.getInstance());
            info.setType(job.getType());
            info.setState(job.getState());
            info.setURL(job.getStorageURL());
            this.logWriter.write(info, this.config);
        }
        catch (Exception e) {
            logger.error((Object)"Can't add job", e);
        }
    }

    public String getBackupId() {
        return this.backupId;
    }

    public String getConfigInfo() {
        return this.configInfo;
    }

    public List<JobEntryInfo> getJobEntryInfos() {
        return this.jobEntries;
    }

    public void endLog() {
        this.finalized = true;
        this.logWriter.writeEndLog();
        try {
            FileInputStream in = PrivilegedFileHelper.fileInputStream(this.log);
            File dest = new File(this.config.getBackupDir() + File.separator + this.log.getName());
            if (!PrivilegedFileHelper.exists(dest)) {
                FileOutputStream out = PrivilegedFileHelper.fileOutputStream(dest);
                byte[] buf = new byte[(int)PrivilegedFileHelper.length(this.log)];
                ((InputStream)in).read(buf);
                String sConfig = new String(buf, "UTF-8");
                sConfig = sConfig.replaceAll("<backup-dir>.+</backup-dir>", "<backup-dir>.</backup-dir>");
                ((OutputStream)out).write(sConfig.getBytes("UTF-8"));
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Can't write log", e);
        }
    }

    public Collection<JobEntryInfo> getJobEntryStates() {
        HashMap<Integer, JobEntryInfo> infos = new HashMap<Integer, JobEntryInfo>();
        for (JobEntryInfo jobEntry : this.jobEntries) {
            infos.put(jobEntry.getID(), jobEntry);
        }
        return infos.values();
    }

    public BackupConfig getBackupConfig() {
        return this.config;
    }

    public String getLogFilePath() {
        return PrivilegedFileHelper.getAbsolutePath(this.log);
    }

    public Calendar getStartedTime() {
        return this.startedTime;
    }

    public Calendar getFinishedTime() {
        return this.finishedTime;
    }

    public WorkspaceEntry getOriginalWorkspaceEntry() {
        return this.originalWorkspaceEntry;
    }

    public boolean isFinilized() {
        return this.finalized;
    }

    public String getFullBackupType() {
        return this.fullBackupType;
    }

    public String getIncrementalBackupType() {
        return this.incrementalBackupType;
    }

    private class LogWriter {
        protected Log logger = ExoLogger.getLogger("exo.jcr.component.ext.LogWriter");
        private File logFile;
        XMLStreamWriter writer;

        public LogWriter(File file) throws FileNotFoundException, XMLStreamException, FactoryConfigurationError {
            this.logFile = file;
            try {
                this.writer = SecurityHelper.doPrivilegedExceptionAction(new PrivilegedExceptionAction<XMLStreamWriter>(){

                    @Override
                    public XMLStreamWriter run() throws Exception {
                        return XMLOutputFactory.newInstance().createXMLStreamWriter(new FileOutputStream(LogWriter.this.logFile), "UTF-8");
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof FileNotFoundException) {
                    throw (FileNotFoundException)cause;
                }
                if (cause instanceof XMLStreamException) {
                    throw (XMLStreamException)cause;
                }
                if (cause instanceof FactoryConfigurationError) {
                    throw (FactoryConfigurationError)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
            this.writer.writeStartDocument();
            this.writer.writeStartElement("backup-chain-log");
            this.writer.writeStartElement("version-log");
            this.writer.writeCharacters(BackupChainLog.this.versionLog);
            this.writer.writeEndElement();
            this.writer.flush();
        }

        public void writeWorkspaceEntry(WorkspaceEntry originalWorkspaceEntry, RepositoryServiceConfiguration serviceConfiguration) throws XMLStreamException, IOException, JiBXException, RepositoryException, RepositoryConfigurationException {
            IBindingFactory bfact;
            File config = new File(PrivilegedFileHelper.getCanonicalPath(BackupChainLog.this.config.getBackupDir()) + File.separator + "original-workspace-config.xml");
            PrivilegedFileHelper.createNewFile(config);
            FileOutputStream saveStream = PrivilegedFileHelper.fileOutputStream(config);
            RepositoryEntry baseRepositoryEntry = serviceConfiguration.getRepositoryConfiguration(BackupChainLog.this.config.getRepository());
            RepositoryEntry repositoryEntry = new RepositoryEntry();
            repositoryEntry.addWorkspace(originalWorkspaceEntry);
            repositoryEntry.setSystemWorkspaceName(baseRepositoryEntry.getSystemWorkspaceName());
            repositoryEntry.setAccessControl(baseRepositoryEntry.getAccessControl());
            repositoryEntry.setAuthenticationPolicy(baseRepositoryEntry.getAuthenticationPolicy());
            repositoryEntry.setDefaultWorkspaceName(baseRepositoryEntry.getDefaultWorkspaceName());
            repositoryEntry.setName(baseRepositoryEntry.getName());
            repositoryEntry.setSecurityDomain(baseRepositoryEntry.getSecurityDomain());
            repositoryEntry.setSessionTimeOut(baseRepositoryEntry.getSessionTimeOut());
            ArrayList<RepositoryEntry> repositoryEntries = new ArrayList<RepositoryEntry>();
            repositoryEntries.add(repositoryEntry);
            RepositoryServiceConfiguration newRepositoryServiceConfiguration = new RepositoryServiceConfiguration(serviceConfiguration.getDefaultRepositoryName(), repositoryEntries);
            try {
                bfact = SecurityHelper.doPrivilegedExceptionAction(new PrivilegedExceptionAction<IBindingFactory>(){

                    @Override
                    public IBindingFactory run() throws Exception {
                        return BindingDirectory.getFactory(RepositoryServiceConfiguration.class);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof JiBXException) {
                    throw (JiBXException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
            IMarshallingContext mctx = bfact.createMarshallingContext();
            mctx.marshalDocument((Object)newRepositoryServiceConfiguration, "ISO-8859-1", null, (OutputStream)saveStream);
            ((OutputStream)saveStream).close();
            this.writer.writeStartElement("original-workspace-config");
            this.writer.writeCharacters(config.getName());
            this.writer.writeEndElement();
        }

        public synchronized void write(BackupConfig config, String fullBackupType, String incrementalBackupType) throws XMLStreamException, IOException {
            this.writer.writeStartElement("backup-config");
            this.writer.writeStartElement("full-backup-type");
            this.writer.writeCharacters(fullBackupType);
            this.writer.writeEndElement();
            this.writer.writeStartElement("incremental-backup-type");
            this.writer.writeCharacters(incrementalBackupType);
            this.writer.writeEndElement();
            if (config.getBackupDir() != null) {
                this.writer.writeStartElement("backup-dir");
                String path = this.isRootBackupManagerDir(this.logFile) ? PrivilegedFileHelper.getCanonicalPath(config.getBackupDir()) : ".";
                this.writer.writeCharacters(path);
                this.writer.writeEndElement();
            }
            if (config.getRepository() != null) {
                this.writer.writeStartElement("repository");
                this.writer.writeCharacters(config.getRepository());
                this.writer.writeEndElement();
            }
            if (config.getWorkspace() != null) {
                this.writer.writeStartElement("workspace");
                this.writer.writeCharacters(config.getWorkspace());
                this.writer.writeEndElement();
            }
            this.writer.writeStartElement("incremental-job-period");
            this.writer.writeCharacters(Long.toString(config.getIncrementalJobPeriod()));
            this.writer.writeEndElement();
            this.writer.writeStartElement("incremental-job-number");
            this.writer.writeCharacters(Integer.toString(config.getIncrementalJobNumber()));
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.writer.flush();
        }

        public synchronized void write(JobEntryInfo info, BackupConfig config) throws XMLStreamException, IOException {
            this.writer.writeStartElement("job-entry-info");
            this.writer.writeStartElement("type");
            this.writer.writeCharacters(info.getType() == 1 ? "FULL" : "INCREMENTAL");
            this.writer.writeEndElement();
            this.writer.writeStartElement("state");
            this.writer.writeCharacters(this.getState(info.getState()));
            this.writer.writeEndElement();
            this.writer.writeStartElement("url");
            this.writer.writeCharacters(this.getRelativeUrl(info.getURL(), config.getBackupDir()));
            this.writer.writeEndElement();
            this.writer.writeStartElement("date");
            this.writer.writeCharacters(JCRDateFormat.format((Calendar)info.getDate()));
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.writer.flush();
        }

        private String getRelativeUrl(URL url, File backupDir) throws IOException {
            String str = PrivilegedFileHelper.getCanonicalPath(new File(url.getFile()));
            return url.getProtocol() + ":" + str.replace(PrivilegedFileHelper.getCanonicalPath(BackupChainLog.this.config.getBackupDir()) + File.separator, "");
        }

        private boolean isRootBackupManagerDir(File log) throws IOException {
            return PrivilegedFileHelper.getCanonicalPath(log.getParentFile()).equals(PrivilegedFileHelper.getCanonicalPath(BackupChainLog.this.rootDir));
        }

        public synchronized void writeEndLog() {
            try {
                this.writer.writeEndElement();
                this.writer.writeEndDocument();
                this.writer.flush();
            }
            catch (Exception e) {
                this.logger.error((Object)"Can't write log", e);
            }
        }

        private String getState(int iState) {
            String sState = "" + iState;
            switch (iState) {
                case 4: {
                    sState = "FINISHED";
                    break;
                }
                case 0: {
                    sState = "STARTING";
                    break;
                }
                case 1: {
                    sState = "WAITING";
                    break;
                }
                case 2: {
                    sState = "WORKING";
                }
            }
            return sState;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LogReader {
        protected Log logger = ExoLogger.getLogger("exo.jcr.component.ext.LogReader");
        private File logFile;
        private XMLStreamReader reader;
        private BackupConfig config;
        private List<JobEntryInfo> jobEntries;
        private List<JobEntryInfo> jobEntriesNormalize;
        private WorkspaceEntry originalWorkspaceEntry;
        private String version;
        private String iBackupType;
        private String fBackupType;

        public LogReader(File logFile) throws FileNotFoundException, XMLStreamException, FactoryConfigurationError {
            this.logFile = logFile;
            this.jobEntries = new ArrayList<JobEntryInfo>();
            this.reader = XMLInputFactory.newInstance().createXMLStreamReader(PrivilegedFileHelper.fileInputStream(this.logFile), "UTF-8");
        }

        public String getIncrementalBackupType() {
            return this.iBackupType;
        }

        public String getFullBackupType() {
            return this.fBackupType;
        }

        public String getVersionLog() {
            return this.version;
        }

        public WorkspaceEntry getOriginalWorkspaceEntry() {
            return this.originalWorkspaceEntry;
        }

        public BackupConfig getBackupConfig() {
            return this.config;
        }

        public List<JobEntryInfo> getJobEntryInfoList() {
            return this.jobEntries;
        }

        public List<JobEntryInfo> getJobEntryInfoNormalizeList() {
            return this.jobEntriesNormalize;
        }

        public Calendar getBeginTime() {
            return this.jobEntries.get(0).getDate();
        }

        public Calendar getEndTime() {
            return this.jobEntries.get(this.jobEntries.size() - 1).getDate();
        }

        public void readLogFile() throws Exception {
            boolean endDocument = false;
            while (!endDocument) {
                int eventCode = this.reader.next();
                switch (eventCode) {
                    case 1: {
                        String name = this.reader.getLocalName();
                        if (name.equals("backup-config")) {
                            this.config = this.readBackupConfig();
                        }
                        if (name.equals("job-entry-info")) {
                            this.jobEntries.add(this.readJobEntryInfo());
                        }
                        if (name.equals("original-workspace-config")) {
                            this.originalWorkspaceEntry = this.readWorkspaceEntry();
                        }
                        if (!name.equals("version-log")) break;
                        this.version = this.readContent();
                        break;
                    }
                    case 8: {
                        endDocument = true;
                    }
                }
            }
        }

        private WorkspaceEntry readWorkspaceEntry() throws Exception {
            IBindingFactory factory;
            String configName = this.readContent();
            File configFile = new File(PrivilegedFileHelper.getCanonicalPath(this.getBackupConfig().getBackupDir()) + File.separator + configName);
            if (!PrivilegedFileHelper.exists(configFile)) {
                throw new WorkspaceRestoreExeption("The backup set is not contains original workspace configuration : " + PrivilegedFileHelper.getCanonicalPath(this.getBackupConfig().getBackupDir()));
            }
            try {
                factory = SecurityHelper.doPrivilegedExceptionAction(new PrivilegedExceptionAction<IBindingFactory>(){

                    @Override
                    public IBindingFactory run() throws Exception {
                        return BindingDirectory.getFactory(RepositoryServiceConfiguration.class);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof JiBXException) {
                    throw (JiBXException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
            IUnmarshallingContext uctx = factory.createUnmarshallingContext();
            RepositoryServiceConfiguration conf = (RepositoryServiceConfiguration)uctx.unmarshalDocument((InputStream)PrivilegedFileHelper.fileInputStream(configFile), null);
            RepositoryEntry repositoryEntry = conf.getRepositoryConfiguration(this.getBackupConfig().getRepository());
            if (repositoryEntry.getWorkspaceEntries().size() != 1) {
                throw new WorkspaceRestoreExeption("The oririginal configuration should be contains only one workspace entry :" + PrivilegedFileHelper.getCanonicalPath(configFile));
            }
            if (!((WorkspaceEntry)repositoryEntry.getWorkspaceEntries().get(0)).getName().equals(this.getBackupConfig().getWorkspace())) {
                throw new WorkspaceRestoreExeption("The oririginal configuration should be contains only one workspace entry with name \"" + this.getBackupConfig().getWorkspace() + "\" :" + PrivilegedFileHelper.getCanonicalPath(configFile));
            }
            return (WorkspaceEntry)repositoryEntry.getWorkspaceEntries().get(0);
        }

        private JobEntryInfo readJobEntryInfo() throws XMLStreamException, ValueFormatException, IOException {
            JobEntryInfo info = new JobEntryInfo();
            boolean endJobEntryInfo = false;
            while (!endJobEntryInfo) {
                int eventCode = this.reader.next();
                switch (eventCode) {
                    case 1: {
                        String name = this.reader.getLocalName();
                        if (name.equals("type")) {
                            info.setType(this.getType(this.readContent()));
                        }
                        if (name.equals("state")) {
                            info.setState(this.getState(this.readContent()));
                        }
                        if (name.equals("url")) {
                            if (this.version != null && this.version.equals(VERSION_LOG_1_1)) {
                                String path = this.readContent().replace("file:", "file:" + PrivilegedFileHelper.getCanonicalPath(this.config.getBackupDir()) + File.separator);
                                info.setURL(new URL(path));
                            } else {
                                info.setURL(new URL(this.readContent()));
                            }
                        }
                        if (!name.equals("date")) break;
                        info.setDate(JCRDateFormat.parse((String)this.readContent()));
                        break;
                    }
                    case 2: {
                        String tagName = this.reader.getLocalName();
                        if (!tagName.equals("job-entry-info")) break;
                        endJobEntryInfo = true;
                    }
                }
            }
            return info;
        }

        private int getState(String content) {
            int state = -1;
            if (content.equals("FINISHED")) {
                state = 4;
            }
            if (content.equals("STARTING")) {
                state = 0;
            }
            if (content.equals("WAITING")) {
                state = 1;
            }
            if (content.equals("WORKING")) {
                state = 2;
            }
            return state;
        }

        private int getType(String content) {
            int type = -1;
            if (content.equals("FULL")) {
                type = 1;
            }
            if (content.equals("INCREMENTAL")) {
                type = 2;
            }
            return type;
        }

        private BackupConfig readBackupConfig() throws XMLStreamException, IOException {
            BackupConfig conf = new BackupConfig();
            boolean endBackupConfig = false;
            while (!endBackupConfig) {
                int eventCode = this.reader.next();
                switch (eventCode) {
                    case 1: {
                        String name = this.reader.getLocalName();
                        if (name.equals("backup-dir")) {
                            if (this.version != null && this.version.equals(VERSION_LOG_1_1)) {
                                String dir = this.readContent();
                                if (dir.equals(".")) {
                                    String path = PrivilegedFileHelper.getCanonicalPath(this.logFile.getParentFile());
                                    conf.setBackupDir(new File(path));
                                } else {
                                    conf.setBackupDir(new File(dir));
                                }
                            } else {
                                conf.setBackupDir(new File(this.readContent()));
                            }
                        }
                        if (name.equals("repository")) {
                            conf.setRepository(this.readContent());
                        }
                        if (name.equals("workspace")) {
                            conf.setWorkspace(this.readContent());
                        }
                        if (name.equals("incremental-job-period")) {
                            conf.setIncrementalJobPeriod(Long.valueOf(this.readContent()));
                        }
                        if (name.equals("incremental-job-number")) {
                            conf.setIncrementalJobNumber(Integer.valueOf(this.readContent()));
                        }
                        if (name.equals("full-backup-type")) {
                            this.fBackupType = this.readContent();
                        }
                        if (!name.equals("incremental-backup-type")) break;
                        this.iBackupType = this.readContent();
                        break;
                    }
                    case 2: {
                        String tagName = this.reader.getLocalName();
                        if (!tagName.equals("backup-config")) break;
                        endBackupConfig = true;
                    }
                }
            }
            return conf;
        }

        private String readContent() throws XMLStreamException {
            String content = null;
            int eventCode = this.reader.next();
            if (eventCode == 4) {
                content = this.reader.getText();
            }
            return content;
        }

        public void jobEntrysNormalize() {
            this.jobEntriesNormalize = new ArrayList<JobEntryInfo>();
            for (int i = 0; i < this.jobEntries.size(); ++i) {
                JobEntryInfo entryInfo = this.jobEntries.get(i);
                boolean alreadyExist = false;
                for (int j = 0; j < this.jobEntriesNormalize.size(); ++j) {
                    if (!this.jobEntriesNormalize.get(j).getURL().toString().equals(entryInfo.getURL().toString())) continue;
                    alreadyExist = true;
                }
                if (alreadyExist) continue;
                this.jobEntriesNormalize.add(entryInfo);
            }
        }
    }
}

