/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.servlet;

import com.google.caja.ancillary.servlet.StaticFiles;
import com.google.caja.service.TestHttpServletRequest;
import com.google.caja.service.TestHttpServletResponse;
import com.google.caja.util.CajaTestCase;
import java.util.Arrays;

public class StaticFilesTest
extends CajaTestCase {
    public final void testBogusUrls() {
        StaticFiles f = new StaticFiles("cacheId");
        StaticFilesTest.assertFalse((boolean)f.exists("files/bogus"));
        StaticFilesTest.assertFalse((boolean)f.exists("files/bogus.html"));
        StaticFilesTest.assertTrue((boolean)f.exists("files/index.js"));
        StaticFilesTest.assertTrue((boolean)f.exists("files/styles.css"));
    }

    public final void testServesBinary() throws Exception {
        StaticFiles f = new StaticFiles("cacheId");
        TestHttpServletRequest req = new TestHttpServletRequest("");
        TestHttpServletResponse resp = new TestHttpServletResponse();
        f.serve("files/tools-28.gif", req, resp);
        StaticFilesTest.assertEquals((int)200, (int)resp.getStatus());
        StaticFilesTest.assertEquals((String)"image/gif", (String)resp.getHeaders().get("content-type"));
        byte[] bytes = (byte[])resp.getOutputObject();
        byte[] first6 = new byte[6];
        byte[] golden = "GIF89a".getBytes("UTF-8");
        System.arraycopy(bytes, 0, first6, 0, 6);
        StaticFilesTest.assertTrue((String)(Arrays.toString(first6) + " != " + Arrays.toString(golden)), (boolean)Arrays.equals(golden, first6));
    }

    public final void testServesTextCompressed() throws Exception {
        StaticFiles f = new StaticFiles("cacheId");
        TestHttpServletRequest req = new TestHttpServletRequest("");
        TestHttpServletResponse resp = new TestHttpServletResponse();
        f.serve("files/styles.css", req, resp);
        StaticFilesTest.assertEquals((int)200, (int)resp.getStatus());
        StaticFilesTest.assertEquals((String)"text/css; charset=UTF-8", (String)resp.getHeaders().get("content-type"));
        String css = (String)resp.getOutputObject();
        StaticFilesTest.assertTrue((boolean)css.startsWith("body{background:#fff"));
        StaticFilesTest.assertFalse((boolean)css.matches("\\s[{}]|[{}]\\s"));
    }

    public final void test404s() throws Exception {
        StaticFiles f = new StaticFiles("cacheId");
        TestHttpServletRequest req = new TestHttpServletRequest("");
        TestHttpServletResponse resp = new TestHttpServletResponse();
        f.serve("files/nosuchfile.txt", req, resp);
        StaticFilesTest.assertEquals((int)404, (int)resp.getStatus());
    }

    public final void testTip() throws Exception {
        StaticFiles f = new StaticFiles("cacheId");
        TestHttpServletRequest req = new TestHttpServletRequest("");
        TestHttpServletResponse resp = new TestHttpServletResponse();
        f.serve("files/NO_SIDE_EFFECT_tip.html", req, resp);
        StaticFilesTest.assertEquals((int)200, (int)resp.getStatus());
        StaticFilesTest.assertTrue((boolean)((String)resp.getOutputObject()).contains("Operation Has No Effect</title>"));
    }
}

