/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Maps {
    public static <K, V> Map<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> Map<K, V> newHashMap(Map<? extends K, ? extends V> map) {
        return new HashMap<K, V>(map);
    }

    public static <K, V> Map<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> Map<K, V> newLinkedHashMap(Map<? extends K, ? extends V> map) {
        return new LinkedHashMap<K, V>(map);
    }

    public static <K, V> Map<K, V> newIdentityHashMap() {
        return new IdentityHashMap();
    }

    public static <K, V> Map<K, V> newIdentityHashMap(Map<? extends K, ? extends V> map) {
        return new IdentityHashMap<K, V>(map);
    }

    public static <K extends Comparable<K>, V> SortedMap<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <K extends Comparable<K>, V> SortedMap<K, V> newTreeMap(Map<? extends K, ? extends V> map) {
        return new TreeMap<K, V>(map);
    }

    public static <K, V> SortedMap<K, V> newTreeMap(Comparator<? super K> cmp) {
        return new TreeMap(cmp);
    }

    public static <K, V> SortedMap<K, V> newTreeMap(Comparator<? super K> cmp, Map<? extends K, ? extends V> map) {
        TreeMap<? extends K, ? extends V> m = new TreeMap<K, V>(cmp);
        m.putAll(map);
        return m;
    }

    public static <K, V> ImmutableMapBuilder<K, V> immutableMap() {
        return new ImmutableMapBuilder(new LinkedHashMap());
    }

    public static <K, V> ImmutableMapBuilder<K, V> immutableSortedMap(Comparator<? super K> keyCmp) {
        return new ImmutableMapBuilder(new TreeMap(keyCmp));
    }

    private static <K, V> Map<K, V> makeEnumMap(Class<? extends Enum> t) {
        return new EnumMap(t);
    }

    private Maps() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ImmutableMapBuilder<K, V> {
        private Map<K, V> map;
        private boolean canUseEnumMap = true;
        private Class<? extends Enum> enumKeyType;

        ImmutableMapBuilder(Map<K, V> emptyMap) {
            this.map = emptyMap;
        }

        public ImmutableMapBuilder<K, V> put(K key, V value) {
            if (this.canUseEnumMap) {
                if (this.enumKeyType != null) {
                    if (!this.enumKeyType.isInstance(key)) {
                        this.canUseEnumMap = false;
                        this.enumKeyType = null;
                    }
                } else if (key instanceof Enum) {
                    this.enumKeyType = ((Enum)Enum.class.cast(key)).getClass();
                } else {
                    this.canUseEnumMap = false;
                }
            }
            this.map.put(key, value);
            return this;
        }

        public ImmutableMapBuilder<K, V> putAll(Map<K, V> map) {
            if (this.canUseEnumMap) {
                for (Map.Entry<K, V> e : map.entrySet()) {
                    this.put(e.getKey(), e.getValue());
                }
            } else {
                map.putAll(map);
            }
            return this;
        }

        public Map<K, V> create() {
            Map map;
            if (this.map.isEmpty()) {
                return Collections.emptyMap();
            }
            if (this.canUseEnumMap) {
                map = Maps.makeEnumMap(this.enumKeyType);
                map.putAll(this.map);
            } else {
                map = this.map;
            }
            if (map == null) {
                throw new IllegalStateException();
            }
            this.map = null;
            return Collections.unmodifiableMap(map);
        }
    }
}

