/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import com.google.caja.lexer.Keyword;
import com.google.caja.parser.ParserBase;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SafeIdentifierMaker
implements Iterator<String> {
    private final char[] alphabet;
    private int counter = -1;

    SafeIdentifierMaker(char[] alphabet) {
        this.alphabet = alphabet;
    }

    public SafeIdentifierMaker() {
        this(SafeIdentifierMaker.charRanges('a', 'z', 'A', 'Z'));
    }

    @Override
    public String next() {
        StringBuilder sb;
        String word;
        int nLetters = this.alphabet.length;
        do {
            if (this.counter + 1 == Integer.MAX_VALUE) {
                throw new NoSuchElementException();
            }
            sb = new StringBuilder();
            int n = ++this.counter;
            while (n >= 0) {
                sb.append(this.alphabet[n % nLetters]);
                n = n / nLetters - 1;
            }
        } while (!this.isSafeIdentifier(word = sb.reverse().toString()));
        return word;
    }

    @Override
    public boolean hasNext() {
        return this.counter < Integer.MAX_VALUE;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean isSafeIdentifier(String ident) {
        return !ident.endsWith("__") && ParserBase.isJavascriptIdentifier(ident) && !Keyword.isKeyword(ident) && !"arguments".equals(ident) && !"eval".equals(ident);
    }

    private static char[] charRanges(char ... startsAndEnds) {
        assert (startsAndEnds.length % 2 == 0);
        int len = 0;
        for (int i = 0; i < startsAndEnds.length; i += 2) {
            len += startsAndEnds[i + 1] + '\u0001' - startsAndEnds[i];
        }
        char[] ranges = new char[len];
        int k = 0;
        for (int i = 0; i < startsAndEnds.length; i += 2) {
            char j;
            char e = startsAndEnds[i + 1];
            assert (j <= e);
            for (j = startsAndEnds[i]; j <= e; j = (char)(j + '\u0001')) {
                int n = k++;
                char c = j;
                ranges[n] = c;
            }
        }
        assert (k == ranges.length);
        return ranges;
    }
}

