/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.rightclick.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.VersionException;
import org.exoplatform.ecm.jcr.model.ClipboardCommand;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotInTrashFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotTrashHomeNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsPasteableFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIWorkingAreaActionListener;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.link.LinkUtils;
import org.exoplatform.services.cms.relations.RelationsService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={PasteActionListener.class})})
public class PasteManageComponent
extends UIAbstractManagerComponent {
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsNotInTrashFilter(), new IsPasteableFilter(), new IsNotTrashHomeNodeFilter()});
    private static final String RELATION_PROP = "exo:relation";
    private static final Log LOG = ExoLogger.getLogger(PasteManageComponent.class);

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public static void pasteManage(Event<PasteManageComponent> event, UIJCRExplorer uiExplorer) throws Exception {
        Node destNode;
        UIWorkingArea uiWorkingArea = (UIWorkingArea)((PasteManageComponent)((Object)event.getSource())).getParent();
        String destPath = event.getRequestContext().getRequestParameter("objectId");
        String nodePath = null;
        Session session = null;
        if (destPath != null) {
            Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(destPath);
            String wsName = null;
            if (matcher.find()) {
                wsName = matcher.group(1);
                nodePath = matcher.group(2);
                session = uiExplorer.getSessionByWorkspace(wsName);
            } else {
                throw new IllegalArgumentException("The ObjectId is invalid '" + destPath + "'");
            }
        }
        UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
        if (uiExplorer.getAllClipBoard().size() < 1) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.no-node", null, 1));
            return;
        }
        try {
            destNode = destPath == null ? uiExplorer.getCurrentNode() : uiExplorer.getNodeByPath(nodePath, session);
            session = destNode.getSession();
            if (destPath == null) {
                destPath = session.getWorkspace().getName() + ":" + destNode.getPath();
            }
        }
        catch (PathNotFoundException path) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
            return;
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return;
        }
        if (!PermissionUtil.canAddNode((Node)destNode)) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.can-not-paste-node", null, 1));
            uiExplorer.updateAjax(event);
            return;
        }
        if (uiExplorer.nodeIsLocked(destNode)) {
            Object[] arg = new Object[]{destPath};
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked", arg, 1));
            return;
        }
        if (!destNode.isCheckedOut()) {
            uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.node-checkedin", null));
            return;
        }
        try {
            if (uiWorkingArea.getVirtualClipboards().isEmpty()) {
                PasteManageComponent.processPaste(uiExplorer.getAllClipBoard().getLast(), destPath, event);
            } else {
                PasteManageComponent.processPasteMultiple(destPath, event, uiExplorer);
            }
        }
        catch (PathNotFoundException pe) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.cannot-readsource", null));
            return;
        }
        session.save();
        uiExplorer.updateAjax(event);
    }

    public static void processPaste(ClipboardCommand currentClipboard, String destPath, Event<?> event) throws Exception {
        PasteManageComponent.processPaste(currentClipboard, destPath, event, false, true);
    }

    private static void processPasteMultiple(String destPath, Event<?> event, UIJCRExplorer uiExplorer) throws Exception {
        int pasteNum = 0;
        UIWorkingArea uiWorkingArea = (UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class);
        List<ClipboardCommand> virtualClipboards = uiWorkingArea.getVirtualClipboards();
        for (ClipboardCommand clipboard : virtualClipboards) {
            if (++pasteNum == virtualClipboards.size()) {
                PasteManageComponent.processPaste(clipboard, destPath, event, true, true);
                break;
            }
            PasteManageComponent.processPaste(clipboard, destPath, event, true, false);
        }
    }

    private static void updateClipboard(List<ClipboardCommand> clipboardCommands, Map<ClipboardCommand, Node> mapClipboard) throws Exception {
        for (ClipboardCommand clipboard : clipboardCommands) {
            if (!"cut".equals(clipboard.getType())) continue;
            Node srcNode = mapClipboard.get(clipboard);
            srcNode.refresh(true);
            clipboard.setSrcPath(srcNode.getPath());
        }
    }

    private static Map<ClipboardCommand, Node> parseToMap(List<ClipboardCommand> clipboardCommands, UIJCRExplorer uiExplorer) throws Exception {
        HashMap<ClipboardCommand, Node> mapClipboard = new HashMap<ClipboardCommand, Node>();
        for (ClipboardCommand clipboard : clipboardCommands) {
            String srcPath = clipboard.getSrcPath();
            String type = clipboard.getType();
            String srcWorkspace = clipboard.getWorkspace();
            if (!"cut".equals(type)) continue;
            Session srcSession = uiExplorer.getSessionByWorkspace(srcWorkspace);
            Node srcNode = uiExplorer.getNodeByPath(srcPath, srcSession, false);
            clipboard.setSrcPath(srcNode.getPath());
            mapClipboard.put(clipboard, srcNode);
        }
        return mapClipboard;
    }

    private static void processPaste(ClipboardCommand currentClipboard, String destPath, Event<?> event, boolean isMultiSelect, boolean isLastPaste) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIComponent)event.getSource()).getAncestorOfType(UIJCRExplorer.class);
        UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
        String srcPath = currentClipboard.getSrcPath();
        String type = currentClipboard.getType();
        String srcWorkspace = currentClipboard.getWorkspace();
        Session srcSession = uiExplorer.getSessionByWorkspace(srcWorkspace);
        Node srcNode = uiExplorer.getNodeByPath(srcPath, srcSession, false);
        srcPath = srcNode.getPath();
        srcSession = srcNode.getSession();
        srcWorkspace = srcSession.getWorkspace().getName();
        Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(destPath);
        String destWorkspace = null;
        if (!matcher.find()) {
            throw new IllegalArgumentException("The ObjectId is invalid '" + destPath + "'");
        }
        destWorkspace = matcher.group(1);
        destPath = matcher.group(2);
        Session destSession = uiExplorer.getSessionByWorkspace(destWorkspace);
        Node destNode = uiExplorer.getNodeByPath(destPath, destSession);
        destPath = destNode.getPath();
        destSession = destNode.getSession();
        if ("cut".equals(type) && srcPath.equals(destPath)) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-cutting", null, 1));
            return;
        }
        if (!"/".equals(destPath)) {
            destPath = destPath.concat("/");
        }
        destPath = destPath.concat(srcNode.getName());
        ActionServiceContainer actionContainer = (ActionServiceContainer)uiExplorer.getApplicationComponent(ActionServiceContainer.class);
        try {
            if ("copy".equals(type)) {
                PasteManageComponent.pasteByCopy(destSession, srcWorkspace, srcPath, destPath);
                Node selectedNode = (Node)destSession.getItem(destPath);
                actionContainer.initiateObservation(selectedNode, uiExplorer.getRepositoryName());
            } else {
                PasteManageComponent.pasteByCut(currentClipboard, uiExplorer, destSession, srcWorkspace, srcPath, destPath, actionContainer, uiExplorer.getRepositoryName(), isMultiSelect, isLastPaste);
            }
        }
        catch (ConstraintViolationException ce) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.current-node-not-allow-paste", null, 1));
            uiExplorer.updateAjax(event);
            return;
        }
        catch (VersionException ve) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.copied-node-in-versioning", null, 1));
            uiExplorer.updateAjax(event);
            return;
        }
        catch (ItemExistsException iee) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.paste-node-same-name", null, 1));
            uiExplorer.updateAjax(event);
            return;
        }
        catch (LoginException e) {
            if ("cut".equals(type)) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.cannot-login-node", null, 1));
                uiExplorer.updateAjax(event);
                return;
            }
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.cannot-paste-nodetype", null, 1));
            uiExplorer.updateAjax(event);
            return;
        }
        catch (AccessDeniedException ace) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.access-denied", null, 1));
            uiExplorer.updateAjax(event);
            return;
        }
        catch (LockException locke) {
            Object[] arg = new Object[]{srcPath};
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.paste-lock-exception", arg, 1));
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            uiExplorer.updateAjax(event);
            return;
        }
    }

    private static void removeReferences(Node destNode) throws Exception {
        NodeType[] mixinTypes = destNode.getMixinNodeTypes();
        Session session = destNode.getSession();
        for (int i = 0; i < mixinTypes.length; ++i) {
            if (!mixinTypes[i].getName().equals("exo:categorized") || !destNode.hasProperty("exo:categorized")) continue;
            Node valueNode = null;
            Value valueAdd = session.getValueFactory().createValue(valueNode);
            destNode.setProperty("exo:categorized", new Value[]{valueAdd});
        }
        destNode.save();
    }

    private static void pasteByCopy(Session session, String srcWorkspaceName, String srcPath, String destPath) throws Exception {
        block9: {
            Workspace workspace = session.getWorkspace();
            if (workspace.getName().equals(srcWorkspaceName)) {
                workspace.copy(srcPath, destPath);
                Node destNode = (Node)session.getItem(destPath);
                PasteManageComponent.removeReferences(destNode);
            } else {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Copy to another workspace");
                    }
                    workspace.copy(srcWorkspaceName, srcPath, destPath);
                }
                catch (Exception e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)"an unexpected error occurs while pasting the node", (Throwable)e);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Copy to other workspace by clone");
                    }
                    try {
                        workspace.clone(srcWorkspaceName, srcPath, destPath, false);
                    }
                    catch (Exception f) {
                        if (!LOG.isErrorEnabled()) break block9;
                        LOG.error((Object)"an unexpected error occurs while pasting the node", (Throwable)f);
                    }
                }
            }
        }
    }

    private static void pasteByCut(ClipboardCommand currentClipboard, UIJCRExplorer uiExplorer, Session session, String srcWorkspace, String srcPath, String destPath, ActionServiceContainer actionContainer, String repository, boolean isMultiSelect, boolean isLastPaste) throws Exception {
        UIWorkingArea uiWorkingArea = (UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class);
        Workspace workspace = session.getWorkspace();
        if (workspace.getName().equals(srcWorkspace) && srcPath.equals(destPath)) {
            return;
        }
        LinkedList<ClipboardCommand> allClipboard = uiExplorer.getAllClipBoard();
        List<ClipboardCommand> virtualClipboard = uiWorkingArea.getVirtualClipboards();
        Map<ClipboardCommand, Node> mapAllClipboardNode = PasteManageComponent.parseToMap(allClipboard, uiExplorer);
        Map<ClipboardCommand, Node> mapVirtualClipboardNode = PasteManageComponent.parseToMap(virtualClipboard, uiExplorer);
        RelationsService relationsService = (RelationsService)uiExplorer.getApplicationComponent(RelationsService.class);
        ArrayList<Node> refList = new ArrayList<Node>();
        boolean isReference = false;
        PropertyIterator references = null;
        Node srcNode = (Node)uiExplorer.getSessionByWorkspace(srcWorkspace).getItem(srcPath);
        try {
            references = srcNode.getReferences();
            isReference = true;
        }
        catch (Exception e) {
            isReference = false;
        }
        if (isReference && references != null && references.getSize() > 0L) {
            while (references.hasNext()) {
                Property pro = references.nextProperty();
                Node refNode = pro.getParent();
                if (!refNode.hasProperty(RELATION_PROP)) continue;
                relationsService.removeRelation(refNode, srcPath);
                refNode.save();
                refList.add(refNode);
            }
        }
        uiExplorer.addLockToken(srcNode);
        if (workspace.getName().equals(srcWorkspace)) {
            try {
                workspace.move(srcPath, destPath);
                LockUtil.changeLockToken((String)srcPath, (Node)((Node)session.getItem(destPath)));
                session.save();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new MessageException(new ApplicationMessage("UIPopupMenu.msg.bound-exception", null, 1));
            }
            if (!isMultiSelect || isMultiSelect && isLastPaste) {
                Node desNode = null;
                try {
                    desNode = (Node)session.getItem(destPath);
                }
                catch (PathNotFoundException pathNotFoundException) {
                    uiExplorer.setCurrentPath(LinkUtils.getParentPath((String)uiExplorer.getCurrentPath()));
                    desNode = uiExplorer.getCurrentNode();
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    uiExplorer.setCurrentPath(LinkUtils.getParentPath((String)uiExplorer.getCurrentPath()));
                    desNode = uiExplorer.getCurrentNode();
                }
                if (!session.itemExists(uiExplorer.getCurrentPath())) {
                    uiExplorer.setCurrentPath(LinkUtils.getParentPath((String)uiExplorer.getCurrentPath()));
                }
                if (!desNode.getPath().equals(uiExplorer.getCurrentPath())) {
                    actionContainer.initiateObservation(desNode, repository);
                }
                for (int i = 0; i < refList.size(); ++i) {
                    Node addRef = (Node)refList.get(i);
                    relationsService.addRelation(addRef, destPath, session.getWorkspace().getName());
                    addRef.save();
                }
                uiWorkingArea.getVirtualClipboards().clear();
                Node currentNode = uiExplorer.getCurrentNode();
                String realCurrentPath = currentNode.getPath();
                if (srcWorkspace.equals(currentNode.getSession().getWorkspace().getName()) && (srcPath.equals(realCurrentPath) || realCurrentPath.startsWith(srcPath))) {
                    uiExplorer.setCurrentPath(LinkUtils.getParentPath((String)uiExplorer.getCurrentPath()));
                }
            }
        } else {
            workspace.clone(srcWorkspace, srcPath, destPath, false);
            if (!isMultiSelect || isMultiSelect && isLastPaste) {
                uiWorkingArea.getVirtualClipboards().clear();
            }
        }
        session.save();
        uiExplorer.getAllClipBoard().remove(currentClipboard);
        PasteManageComponent.updateClipboard(uiWorkingArea.getVirtualClipboards(), mapVirtualClipboardNode);
        PasteManageComponent.updateClipboard(uiExplorer.getAllClipBoard(), mapAllClipboardNode);
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PasteActionListener
    extends UIWorkingAreaActionListener<PasteManageComponent> {
        public void processEvent(Event<PasteManageComponent> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((PasteManageComponent)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            PasteManageComponent.pasteManage(event, uiExplorer);
        }
    }
}

