/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.collaboration;

import java.io.FileNotFoundException;
import java.security.AccessControlException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Path(value="/contents/editing/")
public class InlineEditingService
implements ResourceContainer {
    private static Log log = ExoLogger.getLogger(InlineEditingService.class);
    public static final String EXO_TITLE = "exo:title";
    public static final String EXO_SUMMARY = "exo:summary";
    public static final String EXO_TEXT = "exo:text";
    public static final String EXO_RSS_ENABLE = "exo:rss-enable";
    public static final String POST_EDIT_CONTENT_EVENT = "CmsService.event.postEdit";
    private final String localeFile = "locale.portlet.i18n.WebUIDms";

    @POST
    @Path(value="/title/")
    public Response editTitle(@FormParam(value="newValue") String newTitle, @QueryParam(value="repositoryName") String repositoryName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="nodeUIID") String nodeUIID, @QueryParam(value="siteName") String siteName, @QueryParam(value="language") String language) {
        return this.modifyProperty(EXO_TITLE, newTitle, repositoryName, workspaceName, nodeUIID, siteName, language);
    }

    @POST
    @Path(value="/summary/")
    public Response editSummary(@FormParam(value="newValue") String newSummary, @QueryParam(value="repositoryName") String repositoryName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="nodeUIID") String nodeUIID, @QueryParam(value="siteName") String siteName, @QueryParam(value="language") String language) {
        return this.modifyProperty(EXO_SUMMARY, newSummary, repositoryName, workspaceName, nodeUIID, siteName, language);
    }

    @POST
    @Path(value="/text/")
    public Response editText(@FormParam(value="newValue") String newText, @QueryParam(value="repositoryName") String repositoryName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="nodeUIID") String nodeUIID, @QueryParam(value="siteName") String siteName, @QueryParam(value="language") String language) {
        return this.modifyProperty(EXO_TEXT, newText, repositoryName, workspaceName, nodeUIID, siteName, language);
    }

    @POST
    @Path(value="/property/")
    public Response editProperty(@QueryParam(value="propertyName") String propertyName, @FormParam(value="newValue") String newValue, @QueryParam(value="repositoryName") String repositoryName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="nodeUIID") String nodeUIID, @QueryParam(value="siteName") String siteName, @QueryParam(value="language") String language) {
        String decodedPropertyName = Text.unescapeIllegalJcrChars((String)propertyName);
        return this.modifyProperty(decodedPropertyName, newValue, repositoryName, workspaceName, nodeUIID, siteName, language);
    }

    public Response modifyProperty(String propertyName, String newValue, String repositoryName, String workspaceName, String nodeUIID, String siteName, String language) {
        CacheControl cacheControl;
        Element localeMsg;
        Document document;
        block27: {
            String message;
            String messageKey;
            ResourceBundle resourceBundle;
            block26: {
                block25: {
                    resourceBundle = null;
                    messageKey = "";
                    message = "";
                    document = null;
                    localeMsg = null;
                    try {
                        Locale locale = new Locale(language);
                        ResourceBundleService resourceBundleService = (ResourceBundleService)WCMCoreUtils.getService(ResourceBundleService.class);
                        resourceBundle = resourceBundleService.getResourceBundle("locale.portlet.i18n.WebUIDms", locale);
                    }
                    catch (Exception ex) {
                        if (!log.isErrorEnabled()) break block25;
                        log.error((Object)"Error when perform create ResourceBundle: ", (Throwable)ex);
                    }
                }
                try {
                    document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                }
                catch (Exception ex) {
                    if (!log.isErrorEnabled()) break block26;
                    log.error((Object)"Error when perform create Document object: ", (Throwable)ex);
                }
            }
            cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            cacheControl.setNoStore(true);
            try {
                SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
                ExoContainer container = ExoContainerContext.getCurrentContainer();
                RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
                ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
                Session session = sessionProvider.getSession(workspaceName, manageableRepository);
                try {
                    localeMsg = document.createElement("bundle");
                    Node node = session.getNodeByUUID(nodeUIID);
                    node = (Node)session.getItem(node.getPath());
                    if (InlineEditingService.canSetProperty(node)) {
                        if (!this.sameValue(newValue, node, propertyName) && newValue.length() > 0) {
                            newValue = Text.unescapeIllegalJcrChars((String)newValue.trim());
                            PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
                            String containerName = containerInfo.getContainerName();
                            ListenerService listenerService = (ListenerService)WCMCoreUtils.getService(ListenerService.class, (String)containerName);
                            if (propertyName.equals(EXO_TITLE) && !node.hasProperty(EXO_TITLE)) {
                                node.addMixin(EXO_RSS_ENABLE);
                            }
                            if (!propertyName.contains("/")) {
                                if (node.getProperty(propertyName).getDefinition().isMultiple()) {
                                    Value[] currentValue = node.getProperty(propertyName).getValues();
                                    if (currentValue == null) {
                                        currentValue = new Value[]{session.getValueFactory().createValue(newValue)};
                                    }
                                    node.setProperty(propertyName, currentValue);
                                } else {
                                    node.setProperty(propertyName, newValue);
                                }
                            } else {
                                int iSlash = propertyName.lastIndexOf("/");
                                String subnodePath = propertyName.substring(0, iSlash);
                                String subnodeProperty = propertyName.substring(iSlash + 1);
                                Node subnode = node.getNode(subnodePath);
                                if (subnode.getProperty(subnodeProperty).getDefinition().isMultiple()) {
                                    Value[] currentValue = subnode.getProperty(subnodeProperty).getValues();
                                    if (currentValue == null) {
                                        currentValue = new Value[]{session.getValueFactory().createValue(newValue)};
                                    }
                                    subnode.setProperty(subnodeProperty, currentValue);
                                } else {
                                    subnode.setProperty(subnodeProperty, newValue);
                                }
                            }
                            ConversationState conversationState = ConversationState.getCurrent();
                            conversationState.setAttribute("siteName", (Object)siteName);
                            listenerService.broadcast(POST_EDIT_CONTENT_EVENT, null, (Object)node);
                            session.save();
                        }
                        break block27;
                    }
                    messageKey = "AccessDeniedException.msg";
                    message = resourceBundle.getString(messageKey);
                    localeMsg.setAttribute("message", message);
                    document.appendChild(localeMsg);
                    return Response.ok((Object)new DOMSource(document), (String)"text/xml").cacheControl(cacheControl).build();
                }
                catch (AccessDeniedException ace) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"AccessDeniedException: ", (Throwable)ace);
                    }
                    messageKey = "AccessDeniedException.msg";
                    message = resourceBundle.getString(messageKey);
                    localeMsg.setAttribute("message", message);
                    document.appendChild(localeMsg);
                    return Response.ok((Object)new DOMSource(document), (String)"text/xml").cacheControl(cacheControl).build();
                }
                catch (FileNotFoundException fie) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"FileNotFoundException: ", (Throwable)fie);
                    }
                    messageKey = "ItemNotFoundException.msg";
                    message = resourceBundle.getString(messageKey);
                    localeMsg.setAttribute("message", message);
                    document.appendChild(localeMsg);
                    return Response.ok((Object)new DOMSource(document), (String)"text/xml").cacheControl(cacheControl).build();
                }
                catch (LockException lockex) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"LockException", (Throwable)lockex);
                    }
                    messageKey = "LockException.msg";
                    message = resourceBundle.getString(messageKey);
                    localeMsg.setAttribute("message", message);
                    document.appendChild(localeMsg);
                    return Response.ok((Object)new DOMSource(document), (String)"text/xml").cacheControl(cacheControl).build();
                }
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Error when perform edit title: ", (Throwable)e);
                }
                messageKey = "UIPresentation.label.Exception";
                message = resourceBundle.getString(messageKey);
                localeMsg.setAttribute("message", message);
                document.appendChild(localeMsg);
                return Response.ok((Object)new DOMSource(document), (String)"text/xml").cacheControl(cacheControl).build();
            }
        }
        localeMsg.setAttribute("message", "OK");
        document.appendChild(localeMsg);
        return Response.ok((Object)new DOMSource(document), (String)"text/xml").cacheControl(cacheControl).build();
    }

    private boolean sameValue(String newValue, Node node, String propertyName) throws Exception {
        if (!node.hasProperty(propertyName)) {
            return newValue == null || newValue.length() == 0;
        }
        if (node.getProperty(propertyName).getDefinition().isMultiple()) {
            try {
                return node.getProperty(propertyName).getValues()[0].getString().equals(newValue);
            }
            catch (Exception e) {
                return false;
            }
        }
        return node.getProperty(propertyName).getString().equals(newValue);
    }

    public static boolean canSetProperty(Node node) throws RepositoryException {
        return InlineEditingService.checkPermission(node, "set_property");
    }

    private static boolean checkPermission(Node node, String permissionType) throws RepositoryException {
        try {
            ((ExtendedNode)node).checkPermission(permissionType);
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }
}

