/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.impl;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.jcr.util.VersionHistoryImporter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final Log LOG = ExoLogger.getLogger(Utils.class);
    private static final String ILLEGAL_SEARCH_CHARACTERS = "\\!^()+{}[]:\"-";
    public static final String MAPPING_FILE = "mapping.properties";
    public static final String EXO_SYMLINK = "exo:symlink";
    private static LinkManager linkManager = WCMCoreUtils.getService(LinkManager.class);
    private static TrashService trashService = WCMCoreUtils.getService(TrashService.class);
    private static NodeHierarchyCreator nodeHierarchyCreator = WCMCoreUtils.getService(NodeHierarchyCreator.class);
    private static SessionProviderService sessionProviderService = WCMCoreUtils.getService(SessionProviderService.class);
    private static String trashPath;
    private static String trashWorkspace;
    private static SessionProvider sessionProvider;

    public static Node makePath(Node rootNode, String path, String nodetype) throws PathNotFoundException, RepositoryException {
        return Utils.makePath(rootNode, path, nodetype, null);
    }

    public static Node makePath(Node rootNode, String path, String nodetype, Map permissions) throws PathNotFoundException, RepositoryException {
        String[] tokens = path.split("/");
        Node node = rootNode;
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (token.length() <= 0) continue;
            if (node.hasNode(token)) {
                node = node.getNode(token);
                continue;
            }
            node = node.addNode(token, nodetype);
            node.getSession().save();
            node = (Node)node.getSession().getItem(node.getPath());
            if (node.canAddMixin("exo:privilegeable")) {
                node.addMixin("exo:privilegeable");
            }
            if (permissions == null) continue;
            ((ExtendedNode)node).setPermissions(permissions);
        }
        rootNode.save();
        return node;
    }

    public static void processImportHistory(Node currentNode, InputStream versionHistorySourceStream, Map<String, String> mapHistoryValue) throws Exception {
        for (String uuid : mapHistoryValue.keySet()) {
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(versionHistorySourceStream));
            byte[] data = new byte[1024];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                int available = -1;
                if (entry.getName().equals(uuid + ".xml")) {
                    block8: {
                        while ((available = zipInputStream.read(data, 0, 1024)) > -1) {
                            out.write(data, 0, available);
                        }
                        try {
                            ByteArrayInputStream inputStream = new ByteArrayInputStream(out.toByteArray());
                            String value = mapHistoryValue.get(uuid);
                            Node versionableNode = currentNode.getSession().getNodeByUUID(uuid);
                            Utils.importHistory((NodeImpl)versionableNode, inputStream, Utils.getBaseVersionUUID(value), Utils.getPredecessors(value), Utils.getVersionHistory(value));
                            currentNode.getSession().save();
                        }
                        catch (ItemNotFoundException item) {
                            currentNode.getSession().refresh(false);
                            if (LOG.isErrorEnabled()) {
                                LOG.error((Object)("Can not found versionable node" + (Object)((Object)item)), (Throwable)item);
                            }
                        }
                        catch (Exception e) {
                            currentNode.getSession().refresh(false);
                            if (!LOG.isErrorEnabled()) break block8;
                            LOG.error((Object)("Import version history failed " + e), (Throwable)e);
                        }
                    }
                    zipInputStream.closeEntry();
                    entry = zipInputStream.getNextEntry();
                    continue;
                }
                zipInputStream.closeEntry();
                entry = zipInputStream.getNextEntry();
            }
            out.close();
            zipInputStream.close();
        }
    }

    private static void importHistory(NodeImpl versionableNode, InputStream versionHistoryStream, String baseVersionUuid, String[] predecessors, String versionHistory) throws RepositoryException, IOException {
        VersionHistoryImporter versionHistoryImporter = new VersionHistoryImporter(versionableNode, versionHistoryStream, baseVersionUuid, predecessors, versionHistory);
        versionHistoryImporter.doImport();
    }

    public static Map<String, String> getMapImportHistory(InputStream importHistorySourceStream) throws Exception {
        ZipInputStream zipInputStream = new ZipInputStream(importHistorySourceStream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        ZipEntry entry = zipInputStream.getNextEntry();
        HashMap<String, String> mapHistoryValue = new HashMap<String, String>();
        while (entry != null) {
            int available = -1;
            if (entry.getName().equals(MAPPING_FILE)) {
                String strLine;
                while ((available = zipInputStream.read(data, 0, 1024)) > -1) {
                    out.write(data, 0, available);
                }
                ByteArrayInputStream inputStream = new ByteArrayInputStream(out.toByteArray());
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                while ((strLine = br.readLine()) != null) {
                    if (strLine.indexOf("=") <= -1) continue;
                    mapHistoryValue.put(strLine.split("=")[0], strLine.split("=")[1]);
                }
                ((InputStream)inputStream).close();
                zipInputStream.closeEntry();
                break;
            }
            entry = zipInputStream.getNextEntry();
        }
        out.close();
        zipInputStream.close();
        return mapHistoryValue;
    }

    private static String getBaseVersionUUID(String valueHistory) {
        String[] arrHistoryValue = valueHistory.split(";");
        return arrHistoryValue[1];
    }

    private static String[] getPredecessors(String valueHistory) {
        String[] arrHistoryValue = valueHistory.split(";");
        String strPredecessors = arrHistoryValue[1];
        if (strPredecessors.indexOf(",") > -1) {
            return strPredecessors.split(",");
        }
        return new String[]{strPredecessors};
    }

    private static String getVersionHistory(String valueHistory) {
        String[] arrHistoryValue = valueHistory.split(";");
        return arrHistoryValue[0];
    }

    public static String getPersonalDrivePath(String parameterizedDrivePath, String userId) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
        NodeHierarchyCreator nodeHierarchyCreator = WCMCoreUtils.getService(NodeHierarchyCreator.class);
        Node userNode = nodeHierarchyCreator.getUserNode(sessionProvider, userId);
        return StringUtils.replaceOnce((String)parameterizedDrivePath, (String)(nodeHierarchyCreator.getJcrPath("usersPath") + "/${userId}"), (String)userNode.getPath());
    }

    public static List<PropertyDefinition> getProperties(Node node) throws Exception {
        ArrayList<PropertyDefinition> properties = new ArrayList<PropertyDefinition>();
        NodeType nodetype = node.getPrimaryNodeType();
        ArrayList<NodeType> types = new ArrayList<NodeType>();
        types.add(nodetype);
        NodeType[] mixins = node.getMixinNodeTypes();
        if (mixins != null) {
            types.addAll(Arrays.asList(mixins));
        }
        for (NodeType nodeType : types) {
            for (PropertyDefinition property : nodeType.getPropertyDefinitions()) {
                String name = property.getName();
                if (name.equals("exo:internalUse") || property.isProtected() || node.hasProperty(name)) continue;
                properties.add(property);
            }
        }
        return properties;
    }

    public static boolean isInTrash(Node node) throws RepositoryException {
        TrashService trashService = WCMCoreUtils.getService(TrashService.class);
        return trashService.isInTrash(node);
    }

    public static String getTitle(Node node) throws Exception {
        Node content;
        String title = null;
        if (node.hasProperty("exo:title")) {
            title = node.getProperty("exo:title").getValue().getString();
        } else if (node.hasNode("jcr:content") && (content = node.getNode("jcr:content")).hasProperty("dc:title")) {
            try {
                title = content.getProperty("dc:title").getValues()[0].getString();
            }
            catch (Exception ex) {
                title = null;
            }
        }
        if (title == null) {
            if (node.isNodeType("nt:frozenNode")) {
                String uuid = node.getProperty("jcr:frozenUuid").getString();
                Node originalNode = node.getSession().getNodeByUUID(uuid);
                title = originalNode.getName();
            } else {
                title = node.getName();
            }
        }
        return Text.unescapeIllegalJcrChars((String)title);
    }

    public static String escapeIllegalCharacterInQuery(String query) {
        String ret = query;
        if (ret != null) {
            for (char c : ILLEGAL_SEARCH_CHARACTERS.toCharArray()) {
                ret = ret.replace(c + "", "\\" + c);
            }
        }
        return ret;
    }

    public static void removeDeadSymlinks(Node node) throws Exception {
        if (Utils.isInTrash(node)) {
            return;
        }
        trashPath = nodeHierarchyCreator.getJcrPath("newDocumentsTrashPath");
        trashWorkspace = WCMCoreUtils.getService(RepositoryService.class).getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
        sessionProvider = sessionProviderService.getSystemSessionProvider(null);
        Utils.removeDeadSymlinksRecursively(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void removeDeadSymlinksRecursively(Node node) throws Exception {
        block9: {
            if (node.isNodeType(EXO_SYMLINK)) return;
            try {
                List<Node> symlinks = linkManager.getAllLinks(node, EXO_SYMLINK);
                Iterator<Object> i$ = symlinks.iterator();
                while (i$.hasNext()) {
                    Node symlink;
                    Node node2 = symlink = i$.next();
                    synchronized (node2) {
                        trashService.moveToTrash(symlink, trashPath, trashWorkspace, sessionProvider, 1);
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block9;
                LOG.warn((Object)e.getMessage());
            }
        }
        try {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            NodeIterator iter = node.getNodes();
            while (iter.hasNext()) {
                childNodes.add(iter.nextNode());
            }
            for (Node child : childNodes) {
                Utils.removeDeadSymlinksRecursively(child);
            }
            return;
        }
        catch (Exception e) {
            if (!LOG.isWarnEnabled()) return;
            LOG.warn((Object)e.getMessage());
        }
    }

    public static Node getChildOfType(Node node, String childType) throws Exception {
        if (node == null) {
            return null;
        }
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            if (!child.isNodeType(childType)) continue;
            return child;
        }
        return null;
    }

    public static boolean hasChild(Node node, String childType) throws Exception {
        return Utils.getChildOfType(node, childType) != null;
    }
}

