/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.thumbnail.impl;

import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public final class ThumbnailUtils {
    private static final Log LOG = ExoLogger.getLogger(ThumbnailUtils.class);

    static Node getThumbnailFolder(Node parentNode) throws RepositoryException {
        block4: {
            if (!parentNode.hasNode("exo:thumbnails")) {
                try {
                    Node thumbnailFolder = parentNode.addNode("exo:thumbnails", "exo:thumbnails");
                    parentNode.getSession().save();
                    if (thumbnailFolder.canAddMixin("exo:hiddenable")) {
                        thumbnailFolder.addMixin("exo:hiddenable");
                    }
                    parentNode.getSession().save();
                    return thumbnailFolder;
                }
                catch (ItemExistsException e) {
                    if (!LOG.isWarnEnabled()) break block4;
                    LOG.warn((Object)e.getMessage());
                }
            }
        }
        return parentNode.getNode("exo:thumbnails");
    }

    static Node getThumbnailNode(Node thumbnailFolder, String identifier) throws RepositoryException {
        block3: {
            if (!thumbnailFolder.hasNode(identifier)) {
                try {
                    Node thumbnailNode = thumbnailFolder.addNode(identifier, "exo:thumbnail");
                    thumbnailFolder.getSession().save();
                    return thumbnailNode;
                }
                catch (ItemExistsException e) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn((Object)e.getMessage());
                }
            }
        }
        return thumbnailFolder.getNode(identifier);
    }
}

