/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.watch.impl;

import groovy.text.GStringTemplateEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.portlet.PortletRequest;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.watch.WatchDocumentService;
import org.exoplatform.services.cms.watch.impl.MessageConfig;
import org.exoplatform.services.cms.watch.impl.WatchDocumentServiceImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailNotifyListener
implements EventListener {
    private NodeLocation observedNode_;
    public static final String EMAIL_WATCHERS_PROP = "exo:emailWatcher";
    private static final String SITE_EXPLORER = "siteExplorer";
    private static final String PATH_PARAM = "path";
    private static final Log LOG = ExoLogger.getLogger(EmailNotifyListener.class);

    public EmailNotifyListener(Node oNode) {
        this.observedNode_ = NodeLocation.getNodeLocationByNode(oNode);
    }

    public void onEvent(EventIterator arg0) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        MailService mailService = (MailService)container.getComponentInstanceOfType(MailService.class);
        WatchDocumentServiceImpl watchService = (WatchDocumentServiceImpl)container.getComponentInstanceOfType(WatchDocumentService.class);
        MessageConfig messageConfig = watchService.getMessageConfig();
        List<String> emailList = this.getEmailList(NodeLocation.getNodeByLocation(this.observedNode_));
        for (String receiver : emailList) {
            try {
                Message message = this.createMessage(receiver, messageConfig);
                mailService.sendMessage(message);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
    }

    private Message createMessage(String receiver, MessageConfig messageConfig) throws Exception {
        Message message = new Message();
        message.setFrom(messageConfig.getSender());
        message.setTo(receiver);
        message.setSubject(messageConfig.getSubject());
        GStringTemplateEngine engine = new GStringTemplateEngine();
        HashMap<String, String> binding = new HashMap<String, String>();
        Query query = new Query();
        query.setEmail(receiver);
        binding.put("user_name", ((User[])WCMCoreUtils.getService(OrganizationService.class).getUserHandler().findUsersByQuery(query).load(0, 1))[0].getFullName());
        binding.put("doc_title", NodeLocation.getNodeByLocation(this.observedNode_).getProperty("exo:title").getValue().getString());
        binding.put("doc_name", NodeLocation.getNodeByLocation(this.observedNode_).getName());
        binding.put("doc_url", this.getViewableLink());
        message.setBody(engine.createTemplate(messageConfig.getContent()).make(binding).toString());
        message.setMimeType(messageConfig.getMimeType());
        return message;
    }

    private String getViewableLink() throws Exception {
        PortalRequestContext pContext = Util.getPortalRequestContext();
        NodeURL nodeURL = (NodeURL)pContext.createURL(NodeURL.TYPE);
        String nodePath = NodeLocation.getNodeByLocation(this.observedNode_).getPath();
        ManageDriveService manageDriveService = WCMCoreUtils.getService(ManageDriveService.class);
        List<DriveData> driveList = manageDriveService.getDriveByUserRoles(pContext.getRemoteUser(), this.getMemberships());
        DriveData drive = this.getDrive(driveList, WCMCoreUtils.getRepository().getConfiguration().getDefaultWorkspaceName(), NodeLocation.getNodeByLocation(this.observedNode_).getPath());
        String driverName = drive.getName();
        String nodePathInDrive = "/".equals(drive.getHomePath()) ? nodePath : nodePath.substring(drive.getHomePath().length());
        UserNode siteExNode = this.getUserNodeByURI(SITE_EXPLORER);
        nodeURL.setNode(siteExNode);
        nodeURL.setQueryParameterValue(PATH_PARAM, "/" + driverName + nodePathInDrive);
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequest portletRequest = portletRequestContext.getRequest();
        String baseURI = portletRequest.getScheme() + "://" + portletRequest.getServerName() + ":" + String.format("%s", portletRequest.getServerPort());
        return baseURI + nodeURL.toString();
    }

    private DriveData getDrive(List<DriveData> lstDrive, String workspace, String nodePath) throws RepositoryException {
        DriveData driveData = null;
        String[] elements = nodePath.split("/");
        String driveMapper = "";
        block0: for (int i = 0; i < elements.length; ++i) {
            driveMapper = i == 1 ? elements[i] : "/" + elements[i];
            for (DriveData drive : lstDrive) {
                if (!workspace.equals(drive.getWorkspace()) || !driveMapper.equals(drive.getHomePath())) continue;
                driveData = drive;
                continue block0;
            }
        }
        return driveData;
    }

    private UserNode getUserNodeByURI(String uri) {
        UserPortal userPortal = Util.getPortalRequestContext().getUserPortalConfig().getUserPortal();
        List allNavs = userPortal.getNavigations();
        for (UserNavigation nav : allNavs) {
            UserNode userNode;
            if (!nav.getKey().getType().equals((Object)SiteType.GROUP) || (userNode = userPortal.resolvePath(nav, null, uri)) == null) continue;
            return userNode;
        }
        return null;
    }

    public List<String> getMemberships() {
        String userId = Util.getPortalRequestContext().getRemoteUser();
        ArrayList<String> userMemberships = new ArrayList<String>();
        userMemberships.add(userId);
        Collection<MembershipEntry> memberships = this.getUserMembershipsFromIdentityRegistry(userId);
        if (memberships != null) {
            for (MembershipEntry membership : memberships) {
                String role = membership.getMembershipType() + ":" + membership.getGroup();
                userMemberships.add(role);
            }
        }
        return userMemberships;
    }

    private Collection<MembershipEntry> getUserMembershipsFromIdentityRegistry(String authenticatedUser) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        IdentityRegistry identityRegistry = (IdentityRegistry)container.getComponentInstanceOfType(IdentityRegistry.class);
        Identity currentUserIdentity = identityRegistry.getIdentity(authenticatedUser);
        return currentUserIdentity.getMemberships();
    }

    private List<String> getEmailList(Node observedNode) {
        ArrayList<String> emailList;
        block4: {
            emailList = new ArrayList<String>();
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            OrganizationService orgService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
            try {
                if (observedNode.hasProperty(EMAIL_WATCHERS_PROP)) {
                    Value[] watcherNames;
                    for (Value value : watcherNames = observedNode.getProperty(EMAIL_WATCHERS_PROP).getValues()) {
                        String userName = value.getString();
                        User user = orgService.getUserHandler().findUserByName(userName);
                        if (user == null) continue;
                        emailList.add(user.getEmail());
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
        return emailList;
    }
}

