/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy.tree.info;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import org.exoplatform.ecm.permission.PermissionBean;
import org.exoplatform.ecm.permission.info.UIPermissionInputSet;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyManagerTrees;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeContainer;
import org.exoplatform.ecm.webui.component.admin.taxonomy.action.UIActionForm;
import org.exoplatform.ecm.webui.component.admin.taxonomy.action.UIActionTaxonomyManager;
import org.exoplatform.ecm.webui.component.admin.taxonomy.tree.info.UIPermissionTreeInfo;
import org.exoplatform.ecm.webui.component.admin.taxonomy.tree.info.UIPermissionTreeManager;
import org.exoplatform.ecm.webui.selector.UIAnyPermission;
import org.exoplatform.ecm.webui.selector.UIGroupMemberSelector;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.taxonomy.TaxonomyTreeData;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={NextAddActionActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={PreviousActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ResetActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectUserActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectMemberActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={AddAnyActionListener.class})})
public class UIPermissionTreeForm
extends UIForm
implements UISelectable {
    public static final String PERMISSION = "permission";
    public static final String POPUP_SELECT = "TaxoTreeSelectUserOrGroupPopup";
    public static final String SELECT_GROUP_ID = "TaxoTreeSelectUserOrGroup";
    private static final Log LOG = ExoLogger.getLogger((String)"admin.UIPermissionTreeForm");
    private NodeLocation currentNode;
    private PermissionBean permBean;

    public UIPermissionTreeForm() throws Exception {
        this.addChild((UIComponent)new UIPermissionInputSet(PERMISSION));
        this.setActions(new String[]{"Previous", "Save", "Reset", "NextAddAction"});
    }

    private void refresh() {
        this.reset();
        this.checkAll(false);
    }

    private void checkAll(boolean check) {
        UIPermissionInputSet uiInputSet = (UIPermissionInputSet)this.getChildById(PERMISSION);
        for (String perm : PermissionType.ALL) {
            uiInputSet.getUIFormCheckBoxInput(perm).setChecked(check);
        }
    }

    protected boolean isEditable(Node node) throws Exception {
        return PermissionUtil.canChangePermission((Node)node);
    }

    public void fillForm(String user, ExtendedNode node) throws Exception {
        UIPermissionInputSet uiInputSet = (UIPermissionInputSet)this.getChildById(PERMISSION);
        this.refresh();
        uiInputSet.getUIStringInput("userOrGroup").setValue((Object)user);
        if (node != null) {
            if (user.equals(Utils.getNodeOwner((Node)node))) {
                for (String perm : PermissionType.ALL) {
                    uiInputSet.getUIFormCheckBoxInput(perm).setChecked(true);
                }
            } else {
                List permsList = node.getACL().getPermissionEntries();
                Iterator perIter = permsList.iterator();
                StringBuilder userPermission = new StringBuilder();
                while (perIter.hasNext()) {
                    AccessControlEntry accessControlEntry = (AccessControlEntry)perIter.next();
                    if (!user.equals(accessControlEntry.getIdentity())) continue;
                    userPermission.append(accessControlEntry.getPermission()).append(" ");
                }
                for (String perm : PermissionType.ALL) {
                    boolean isCheck = userPermission.toString().contains(perm);
                    uiInputSet.getUIFormCheckBoxInput(perm).setChecked(isCheck);
                }
            }
        } else {
            UIPermissionTreeInfo uiInfo = (UIPermissionTreeInfo)((UIContainer)this.getParent()).getChild(UIPermissionTreeInfo.class);
            for (PermissionBean permBeanTemp : uiInfo.getPermBeans()) {
                if (!permBeanTemp.getUsersOrGroups().equals(user)) continue;
                this.getUIFormCheckBoxInput("read").setValue((Object)permBeanTemp.isRead());
                this.getUIFormCheckBoxInput("add_node").setValue((Object)permBeanTemp.isAddNode());
                this.getUIFormCheckBoxInput("remove").setValue((Object)permBeanTemp.isRemove());
                this.getUIFormCheckBoxInput("set_property").setValue((Object)permBeanTemp.isSetProperty());
                break;
            }
        }
    }

    protected void lockForm(boolean isLock) {
        UIPermissionInputSet uiInputSet = (UIPermissionInputSet)this.getChildById(PERMISSION);
        if (isLock) {
            this.setActions(new String[]{"Previous", "Reset", "NextAddAction"});
            uiInputSet.setActionInfo("userOrGroup", null);
        } else {
            this.setActions(new String[]{"Previous", "Save", "Reset", "NextAddAction"});
            uiInputSet.setActionInfo("userOrGroup", new String[]{"SelectUser", "SelectMember", "AddAny"});
        }
        for (String perm : PermissionType.ALL) {
            uiInputSet.getUIFormCheckBoxInput(perm).setEnable(!isLock);
        }
    }

    private String getExoOwner(Node node) throws Exception {
        return Utils.getNodeOwner((Node)node);
    }

    public Node getCurrentNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.currentNode);
    }

    public void setCurrentNode(Node currentNode) {
        this.currentNode = NodeLocation.getNodeLocationByNode((Node)currentNode);
    }

    public PermissionBean getPermBean() {
        return this.permBean;
    }

    public void setPermBean(PermissionBean permBean) {
        this.permBean = permBean;
    }

    public void doSelect(String selectField, Object value) {
        block2: {
            try {
                ExtendedNode node = (ExtendedNode)this.getCurrentNode();
                this.checkAll(false);
                this.fillForm(value.toString(), node);
                this.lockForm(value.toString().equals(this.getExoOwner((Node)node)));
                this.getUIStringInput(selectField).setValue((Object)value.toString());
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PreviousActionListener
    extends EventListener<UIPermissionTreeForm> {
        public void execute(Event<UIPermissionTreeForm> event) throws Exception {
            UITaxonomyTreeContainer uiTaxonomyTreeContainer = (UITaxonomyTreeContainer)((UIPermissionTreeForm)((Object)event.getSource())).getAncestorOfType(UITaxonomyTreeContainer.class);
            uiTaxonomyTreeContainer.viewStep(1);
            UITaxonomyManagerTrees uiTaxonomyManagerTrees = (UITaxonomyManagerTrees)uiTaxonomyTreeContainer.getAncestorOfType(UITaxonomyManagerTrees.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaxonomyManagerTrees);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectMemberActionListener
    extends EventListener<UIPermissionTreeForm> {
        public void execute(Event<UIPermissionTreeForm> event) throws Exception {
            UIPermissionTreeForm uiForm = (UIPermissionTreeForm)((Object)event.getSource());
            UIGroupMemberSelector uiGroupMember = (UIGroupMemberSelector)uiForm.createUIComponent(UIGroupMemberSelector.class, null, UIPermissionTreeForm.SELECT_GROUP_ID);
            ((UIAnyPermission)uiGroupMember.getChild(UIAnyPermission.class)).setId("TaxoTreeAnyPermission");
            ((UIBreadcumbs)uiGroupMember.getChild(UIBreadcumbs.class)).setId("TaxoTreeBreadcumbMembershipSelector");
            ((UITree)uiGroupMember.getChild(UITree.class)).setId("TaxoTreeMembershipSelector");
            uiGroupMember.setSourceComponent((UIComponent)uiForm, new String[]{"userOrGroup"});
            ((UIPermissionTreeManager)uiForm.getAncestorOfType(UIPermissionTreeManager.class)).initPopupPermission((UIComponent)uiGroupMember);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddAnyActionListener
    extends EventListener<UIPermissionTreeForm> {
        public void execute(Event<UIPermissionTreeForm> event) throws Exception {
            UIPermissionTreeForm uiForm = (UIPermissionTreeForm)((Object)event.getSource());
            UIPermissionInputSet uiInputSet = (UIPermissionInputSet)uiForm.getChildById(UIPermissionTreeForm.PERMISSION);
            uiInputSet.getUIStringInput("userOrGroup").setValue((Object)IdentityConstants.ANY);
            uiForm.checkAll(false);
            uiInputSet.getUIFormCheckBoxInput("read").setChecked(true);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectUserActionListener
    extends EventListener<UIPermissionTreeForm> {
        public void execute(Event<UIPermissionTreeForm> event) throws Exception {
            UIPermissionTreeForm uiForm = (UIPermissionTreeForm)((Object)event.getSource());
            ((UIPermissionTreeManager)uiForm.getParent()).initUserSelector();
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NextAddActionActionListener
    extends EventListener<UIPermissionTreeForm> {
        public void execute(Event<UIPermissionTreeForm> event) throws Exception {
            UIPermissionTreeForm uiForm = (UIPermissionTreeForm)((Object)event.getSource());
            UIPermissionTreeInfo uiPermInfo = (UIPermissionTreeInfo)((UIContainer)uiForm.getParent()).getChild(UIPermissionTreeInfo.class);
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            if (uiPermInfo.getPermBeans().size() < 1) {
                uiApp.addMessage(new ApplicationMessage("UIPermissionTreeForm.msg.have-not-any-permission", null, 1));
                return;
            }
            UITaxonomyTreeContainer uiTaxonomyTreeContainer = (UITaxonomyTreeContainer)uiForm.getAncestorOfType(UITaxonomyTreeContainer.class);
            UITaxonomyManagerTrees uiTaxonomyManagerTrees = (UITaxonomyManagerTrees)uiTaxonomyTreeContainer.getAncestorOfType(UITaxonomyManagerTrees.class);
            TaxonomyTreeData taxonomyTreeData = uiTaxonomyTreeContainer.getTaxonomyTreeData();
            if (!taxonomyTreeData.isEdit()) {
                UIActionTaxonomyManager uiActionTaxonomyManager = (UIActionTaxonomyManager)uiTaxonomyTreeContainer.getChild(UIActionTaxonomyManager.class);
                UIActionForm uiActionForm = (UIActionForm)uiActionTaxonomyManager.getChild(UIActionForm.class);
                uiActionForm.createNewAction(null, "exo:taxonomyAction", true);
                uiActionForm.setWorkspace(taxonomyTreeData.getTaxoTreeWorkspace());
            }
            uiTaxonomyTreeContainer.viewStep(3);
            uiTaxonomyTreeContainer.setRenderedChild(UIActionTaxonomyManager.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaxonomyManagerTrees);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIPermissionTreeForm> {
        public void execute(Event<UIPermissionTreeForm> event) throws Exception {
            UIPermissionTreeForm uiForm = (UIPermissionTreeForm)((Object)event.getSource());
            Node currentNode = uiForm.getCurrentNode();
            UIPermissionTreeManager uiParent = (UIPermissionTreeManager)uiForm.getParent();
            UITaxonomyTreeContainer uiContainer = (UITaxonomyTreeContainer)uiForm.getAncestorOfType(UITaxonomyTreeContainer.class);
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            String userOrGroup = (String)((UIPermissionInputSet)uiForm.getChild(UIPermissionInputSet.class)).getUIStringInput("userOrGroup").getValue();
            ArrayList<String> permsList = new ArrayList<String>();
            ArrayList<String> permsRemoveList = new ArrayList<String>();
            PermissionBean permBean = new PermissionBean();
            permBean.setUsersOrGroups(userOrGroup);
            permBean.setRead(uiForm.getUIFormCheckBoxInput("read").isChecked());
            permBean.setAddNode(uiForm.getUIFormCheckBoxInput("add_node").isChecked());
            permBean.setRemove(uiForm.getUIFormCheckBoxInput("remove").isChecked());
            permBean.setSetProperty(uiForm.getUIFormCheckBoxInput("set_property").isChecked());
            for (String perm : PermissionType.ALL) {
                if (uiForm.getUIFormCheckBoxInput(perm).isChecked()) {
                    permsList.add(perm);
                    continue;
                }
                permsRemoveList.add(perm);
            }
            if ((uiForm.getUIFormCheckBoxInput("add_node").isChecked() || uiForm.getUIFormCheckBoxInput("remove").isChecked() || uiForm.getUIFormCheckBoxInput("set_property").isChecked()) && !permsList.contains("read")) {
                permsList.add("read");
            }
            if (Utils.isNameEmpty((String)userOrGroup)) {
                uiApp.addMessage(new ApplicationMessage("UIPermissionTreeForm.msg.userOrGroup-required", null, 1));
                return;
            }
            if (permsList.size() == 0) {
                uiApp.addMessage(new ApplicationMessage("UIPermissionTreeForm.msg.checkbox-require", null, 1));
                return;
            }
            String[] permsArray = permsList.toArray(new String[permsList.size()]);
            uiForm.setPermBean(permBean);
            if (currentNode != null) {
                String lockToken;
                if (currentNode.isLocked() && (lockToken = LockUtil.getLockToken((Node)currentNode)) != null) {
                    currentNode.getSession().addLockToken(lockToken);
                }
                if (!currentNode.isCheckedOut()) {
                    uiApp.addMessage(new ApplicationMessage("UIPermissionTreeForm.msg.node-checkedin", null, 1));
                    return;
                }
                ExtendedNode node = (ExtendedNode)currentNode;
                if (PermissionUtil.canChangePermission((Node)node)) {
                    if (node.canAddMixin("exo:privilegeable")) {
                        node.addMixin("exo:privilegeable");
                        node.setPermission(Utils.getNodeOwner((Node)node), PermissionType.ALL);
                    }
                    for (String perm : permsRemoveList) {
                        try {
                            node.removePermission(userOrGroup, perm);
                        }
                        catch (AccessDeniedException ade) {
                            uiApp.addMessage(new ApplicationMessage("UIPermissionTreeForm.msg.access-denied", null, 1));
                            return;
                        }
                    }
                    if (PermissionUtil.canChangePermission((Node)node)) {
                        node.setPermission(userOrGroup, permsArray);
                    }
                } else {
                    uiApp.addMessage(new ApplicationMessage("UIPermissionTreeForm.msg.not-change-permission", null, 1));
                    return;
                }
                ((UIPermissionTreeInfo)uiParent.getChild(UIPermissionTreeInfo.class)).updateGrid();
                node.save();
                currentNode.getSession().save();
                TaxonomyService taxonomyService = (TaxonomyService)uiForm.getApplicationComponent(TaxonomyService.class);
                taxonomyService.updateTaxonomyTree(uiContainer.getTaxonomyTreeData().getTaxoTreeName(), currentNode);
            }
            uiForm.refresh();
            UIPermissionTreeInfo uiInfo = (UIPermissionTreeInfo)uiParent.getChild(UIPermissionTreeInfo.class);
            uiInfo.updateGrid();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiParent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResetActionListener
    extends EventListener<UIPermissionTreeForm> {
        public void execute(Event<UIPermissionTreeForm> event) throws Exception {
            UIPermissionTreeForm uiForm = (UIPermissionTreeForm)((Object)event.getSource());
            uiForm.lockForm(false);
            uiForm.refresh();
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }
}

