/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ecm.publication.plugins.workflow;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Value;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.ecm.publication.plugins.workflow.UIWorkflowPublicationActionForm;
import org.exoplatform.services.ecm.publication.plugins.workflow.WorkflowMoveNodeAction;
import org.exoplatform.services.ecm.publication.plugins.workflow.WorkflowPublicationPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:resources/templates/workflow/workflowPublicationView.gtmpl", events={@EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={UnpublishActionListener.class}), @EventConfig(listeners={UnsubcriberLifeCycleActionListener.class})})
public class UIWorkflowPublicationViewForm
extends UIForm {
    private String repositoryName = "";
    private NodeLocation currentNode = null;
    private final String EXO_PUBLISH = "exo:published";
    private IdentityRegistry identityRegistry = (IdentityRegistry)this.getApplicationComponent(IdentityRegistry.class);
    private static final Log LOG = ExoLogger.getLogger(UIWorkflowPublicationViewForm.class);

    public UIWorkflowPublicationViewForm() throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        this.repositoryName = repositoryService.getCurrentRepository().getConfiguration().getName();
        this.setActions(new String[]{"Cancel"});
    }

    public void setCurrentNode(Node node) throws Exception {
        this.currentNode = NodeLocation.getNodeLocationByNode((Node)node);
        String userId = node.getSession().getUserID();
        Property rolesProp = node.getProperty("publication:validator");
        Value roles = rolesProp.getValue();
        if (node.isNodeType("exo:published")) {
            if (node.getProperty("publication:currentState").getString().equals("content publishing") && this.checkExcetuteable(userId, roles)) {
                PublicationService publicationService = (PublicationService)this.getApplicationComponent(PublicationService.class);
                ((PublicationPlugin)publicationService.getPublicationPlugins().get("Workflow")).changeState(node, "published", new HashMap());
                this.setActions(new String[]{"Unpublish", "Cancel"});
            } else if (node.getProperty("publication:currentState").getString().equals("published") && this.checkExcetuteable(userId, roles)) {
                this.setActions(new String[]{"Unpublish", "Cancel"});
            } else {
                this.setActions(new String[]{"UnsubcriberLifeCycle", "Cancel"});
            }
        } else {
            this.setActions(new String[]{"Cancel"});
        }
    }

    public String getLinkStateImage(Locale locale) {
        try {
            DownloadService dS = (DownloadService)this.getApplicationComponent(DownloadService.class);
            PublicationService service = (PublicationService)this.getApplicationComponent(PublicationService.class);
            byte[] bytes = service.getStateImage(this.getCurrentNode(), locale);
            ByteArrayInputStream iS = new ByteArrayInputStream(bytes);
            String id = dS.addDownloadResource((DownloadResource)new InputStreamDownloadResource((InputStream)iS, "image/gif"));
            return dS.getDownloadLink(id);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
            return "Error in getStateImage";
        }
    }

    public Node getCurrentNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.currentNode);
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    private boolean checkExcetuteable(String userId, Value roles) throws Exception {
        if (IdentityConstants.SYSTEM.equalsIgnoreCase(userId)) {
            return true;
        }
        Identity identity = this.identityRegistry.getIdentity(userId);
        if (identity == null) {
            return false;
        }
        if ("*".equalsIgnoreCase(roles.getString())) {
            return true;
        }
        MembershipEntry membershipEntry = MembershipEntry.parse((String)roles.getString());
        return identity.isMemberOf(membershipEntry);
    }

    public String getLabel(String fieldName, String type) throws Exception {
        PublicationService publicationService = (PublicationService)this.getApplicationComponent(PublicationService.class);
        WorkflowPublicationPlugin plugin = (WorkflowPublicationPlugin)((Object)publicationService.getPublicationPlugins().get("Workflow"));
        Locale locale = ((UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class)).getLocale();
        try {
            return plugin.getLocalizedAndSubstituteMessage(locale, this.getId() + "." + type + "." + fieldName, null);
        }
        catch (Exception e) {
            return fieldName;
        }
    }

    public void initPopup(UIContainer uiContainer, UIComponent uiComp) throws Exception {
        uiContainer.removeChildById("PopupEditWorkflow");
        UIPopupWindow uiPopup = (UIPopupWindow)uiContainer.addChild(UIPopupWindow.class, null, "PopupEditWorkflow");
        uiPopup.setUIComponent(uiComp);
        uiPopup.setWindowSize(640, 300);
        uiPopup.setShow(true);
        uiPopup.setShowMask(true);
        uiPopup.setResizable(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnsubcriberLifeCycleActionListener
    extends EventListener<UIWorkflowPublicationViewForm> {
        public void execute(Event<UIWorkflowPublicationViewForm> event) throws Exception {
            UIWorkflowPublicationViewForm viewForm = (UIWorkflowPublicationViewForm)((Object)event.getSource());
            Node selectedNode = viewForm.getCurrentNode();
            UIApplication uiApp = (UIApplication)viewForm.getAncestorOfType(UIApplication.class);
            PublicationService publicationService = (PublicationService)viewForm.getApplicationComponent(PublicationService.class);
            WorkflowPublicationPlugin plugin = (WorkflowPublicationPlugin)((Object)publicationService.getPublicationPlugins().get("Workflow"));
            Locale locale = ((UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class)).getLocale();
            if (!selectedNode.isCheckedOut()) {
                String msg = plugin.getLocalizedAndSubstituteMessage(locale, "UIWorkflowPublicationActionForm.msg.node-checkedin", null);
                uiApp.addMessage(new ApplicationMessage(msg, null, 1));
                return;
            }
            if (publicationService.isUnsubcribeLifecycle(selectedNode)) {
                String msg = plugin.getLocalizedAndSubstituteMessage(locale, "UIWorkflowPublicationActionForm.msg.unsubcriber-lifecycle", null);
                uiApp.addMessage(new ApplicationMessage(msg, null, 1));
                return;
            }
            UIContainer container = (UIContainer)viewForm.getAncestorOfType(UIContainer.class);
            UIPopupWindow popupWindow = (UIPopupWindow)container.getParent();
            popupWindow.setRendered(false);
            event.getRequestContext().addUIComponentToUpdateByAjax(popupWindow.getParent());
            publicationService.unsubcribeLifecycle(selectedNode);
            String msg = plugin.getLocalizedAndSubstituteMessage(locale, "UIWorkflowPublicationActionForm.msg.unsubcriber-lifecycle-finish", null);
            uiApp.addMessage(new ApplicationMessage(msg, null));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnpublishActionListener
    extends EventListener<UIWorkflowPublicationViewForm> {
        public void execute(Event<UIWorkflowPublicationViewForm> event) throws Exception {
            UIWorkflowPublicationViewForm viewForm = (UIWorkflowPublicationViewForm)((Object)event.getSource());
            RepositoryService repositoryService = (RepositoryService)viewForm.getApplicationComponent(RepositoryService.class);
            UIContainer container = (UIContainer)viewForm.getParent();
            Node currentNode = viewForm.getCurrentNode();
            PublicationService publicationService = (PublicationService)viewForm.getApplicationComponent(PublicationService.class);
            ((PublicationPlugin)publicationService.getPublicationPlugins().get("Workflow")).changeState(currentNode, "backup", new HashMap());
            String nodePath = currentNode.getPath();
            String srcWorkspace = currentNode.getSession().getWorkspace().getName();
            String destWorkspace = "backup";
            StringBuffer realDestPath = new StringBuffer();
            realDestPath.append(currentNode.getProperty("exo:backupPath").getString());
            if (!"/".equals(realDestPath.toString())) {
                realDestPath.append("/");
            }
            realDestPath.append(currentNode.getName());
            WorkflowMoveNodeAction.moveNode(repositoryService, nodePath, srcWorkspace, destWorkspace, realDestPath.toString(), viewForm.getRepositoryName());
            UIApplication uiApp = (UIApplication)viewForm.getAncestorOfType(UIApplication.class);
            WorkflowPublicationPlugin plugin = (WorkflowPublicationPlugin)((Object)publicationService.getPublicationPlugins().get("Workflow"));
            Locale locale = ((UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class)).getLocale();
            String msg = plugin.getLocalizedAndSubstituteMessage(locale, "UIWorkflowPublicationViewForm.msg.unpublish-success", null);
            uiApp.addMessage(new ApplicationMessage(msg, null, 2));
            UIPopupWindow popupWindow = (UIPopupWindow)container.getParent();
            popupWindow.setRendered(false);
            UIComponent component = popupWindow.getParent();
            if (component != null && component.getParent() != null) {
                event.getRequestContext().addUIComponentToUpdateByAjax(component.getParent());
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax(component);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditActionListener
    extends EventListener<UIWorkflowPublicationViewForm> {
        public void execute(Event<UIWorkflowPublicationViewForm> event) throws Exception {
            UIWorkflowPublicationViewForm workflowViewForm = (UIWorkflowPublicationViewForm)((Object)event.getSource());
            UIContainer container = (UIContainer)workflowViewForm.getParent();
            UIWorkflowPublicationActionForm actionForm = (UIWorkflowPublicationActionForm)container.createUIComponent(UIWorkflowPublicationActionForm.class, null, null);
            actionForm.createNewAction(workflowViewForm.getCurrentNode(), "Workflow", true);
            actionForm.setWorkspaceName(workflowViewForm.getCurrentNode().getSession().getWorkspace().getName());
            workflowViewForm.initPopup(container, (UIComponent)actionForm);
            event.getRequestContext().addUIComponentToUpdateByAjax(workflowViewForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIWorkflowPublicationViewForm> {
        public void execute(Event<UIWorkflowPublicationViewForm> event) throws Exception {
            UIWorkflowPublicationViewForm uiForm = (UIWorkflowPublicationViewForm)((Object)event.getSource());
            UIContainer container = (UIContainer)uiForm.getAncestorOfType(UIContainer.class);
            UIPopupWindow popupWindow = (UIPopupWindow)container.getParent();
            popupWindow.setRendered(false);
            event.getRequestContext().addUIComponentToUpdateByAjax(popupWindow.getParent());
        }
    }
}

