/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.watch.impl;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.watch.WatchDocumentService;
import org.exoplatform.services.cms.watch.impl.EmailNotifyListener;
import org.exoplatform.services.cms.watch.impl.MessageConfig;
import org.exoplatform.services.cms.watch.impl.MessageConfigPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WatchDocumentServiceImpl
implements WatchDocumentService,
Startable {
    public static final String EXO_WATCHABLE_MIXIN = "exo:watchable";
    public static final String EMAIL_WATCHERS_PROP = "exo:emailWatcher";
    public static final String RSS_WATCHERS_PROP = "exo:rssWatcher";
    private static final String WATCHABLE_MIXIN_QUERY = "//element(*,exo:watchable)";
    private RepositoryService repoService_;
    private MessageConfig messageConfig_;
    private TemplateService templateService_;
    private static final Log LOG = ExoLogger.getLogger(WatchDocumentServiceImpl.class);

    public WatchDocumentServiceImpl(InitParams params, RepositoryService repoService, TemplateService templateService) {
        this.repoService_ = repoService;
        this.templateService_ = templateService;
    }

    @Override
    public void initializeMessageConfig(MessageConfigPlugin msgConfigPlugin) {
        this.messageConfig_ = msgConfigPlugin.getMessageConfig();
    }

    @Override
    public int getNotificationType(Node documentNode, String userName) throws Exception {
        NodeType[] mixinTypes = documentNode.getMixinNodeTypes();
        NodeType watchableMixin = null;
        if (mixinTypes.length > 0) {
            for (NodeType nodeType : mixinTypes) {
                if (!nodeType.getName().equalsIgnoreCase(EXO_WATCHABLE_MIXIN)) continue;
                watchableMixin = nodeType;
                break;
            }
        }
        if (watchableMixin == null) {
            return -1;
        }
        boolean notifyByEmail = this.checkNotifyTypeOfWatcher(documentNode, userName, EMAIL_WATCHERS_PROP);
        boolean notifyByRss = this.checkNotifyTypeOfWatcher(documentNode, userName, RSS_WATCHERS_PROP);
        if (notifyByEmail && notifyByRss) {
            return 0;
        }
        if (notifyByEmail) {
            return 1;
        }
        if (notifyByRss) {
            return 2;
        }
        return -1;
    }

    @Override
    public void watchDocument(Node documentNode, String userName, int notifyType) throws Exception {
        Session session = documentNode.getSession();
        Value newWatcher = session.getValueFactory().createValue(userName);
        if (!documentNode.isNodeType(EXO_WATCHABLE_MIXIN)) {
            documentNode.addMixin(EXO_WATCHABLE_MIXIN);
            if (notifyType == 1) {
                documentNode.setProperty(EMAIL_WATCHERS_PROP, new Value[]{newWatcher});
                documentNode.save();
                session.save();
                EmailNotifyListener listener = new EmailNotifyListener(documentNode);
                this.observeNode(documentNode, listener);
            }
            session.save();
        } else {
            ArrayList<Value> watcherList = new ArrayList<Value>();
            if (notifyType == 1) {
                if (documentNode.hasProperty(EMAIL_WATCHERS_PROP)) {
                    for (Value watcher : documentNode.getProperty(EMAIL_WATCHERS_PROP).getValues()) {
                        watcherList.add(watcher);
                    }
                    watcherList.add(newWatcher);
                }
                documentNode.setProperty(EMAIL_WATCHERS_PROP, watcherList.toArray(new Value[watcherList.size()]));
                documentNode.save();
            }
            session.save();
        }
    }

    @Override
    public void unwatchDocument(Node documentNode, String userName, int notificationType) throws Exception {
        if (!documentNode.isNodeType(EXO_WATCHABLE_MIXIN)) {
            return;
        }
        Session session = documentNode.getSession();
        if (notificationType == 1) {
            Value[] watchers = documentNode.getProperty(EMAIL_WATCHERS_PROP).getValues();
            ArrayList<Value> watcherList = new ArrayList<Value>();
            for (Value watcher : watchers) {
                if (watcher.getString().equals(userName)) continue;
                watcherList.add(watcher);
            }
            documentNode.setProperty(EMAIL_WATCHERS_PROP, watcherList.toArray(new Value[watcherList.size()]));
        }
        documentNode.save();
        session.save();
    }

    private void observeNode(Node node, EventListener listener) throws Exception {
        String workspace = node.getSession().getWorkspace().getName();
        Session systemSession = this.repoService_.getCurrentRepository().getSystemSession(workspace);
        List<String> list = this.getDocumentNodeTypes(node);
        String[] observedNodeTypeNames = list.toArray(new String[list.size()]);
        ObservationManager observationManager = systemSession.getWorkspace().getObservationManager();
        observationManager.addEventListener(listener, 16, node.getPath(), true, null, observedNodeTypeNames, false);
        systemSession.logout();
    }

    private boolean checkNotifyTypeOfWatcher(Node documentNode, String userName, String notificationType) throws Exception {
        if (documentNode.hasProperty(notificationType)) {
            Value[] watchers;
            for (Value value : watchers = documentNode.getProperty(notificationType).getValues()) {
                if (!userName.equalsIgnoreCase(value.getString())) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> getDocumentNodeTypes(Node node) throws Exception {
        ArrayList<String> nodeTypeNameList = new ArrayList<String>();
        NodeType primaryType = node.getPrimaryNodeType();
        if (this.templateService_.isManagedNodeType(primaryType.getName())) {
            nodeTypeNameList.add(primaryType.getName());
        }
        for (NodeType nodeType : node.getMixinNodeTypes()) {
            if (!this.templateService_.isManagedNodeType(nodeType.getName())) continue;
            nodeTypeNameList.add(nodeType.getName());
        }
        return nodeTypeNameList;
    }

    private void reInitObserver() throws Exception {
        String[] workspaceNames;
        RepositoryEntry repo = this.repoService_.getCurrentRepository().getConfiguration();
        ManageableRepository repository = this.repoService_.getCurrentRepository();
        for (String workspace : workspaceNames = repository.getWorkspaceNames()) {
            QueryManager queryManager;
            Session session;
            block8: {
                session = repository.getSystemSession(workspace);
                queryManager = null;
                try {
                    queryManager = session.getWorkspace().getQueryManager();
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block8;
                    LOG.error((Object)"Unexpected error", (Throwable)e);
                }
            }
            if (queryManager == null) {
                session.logout();
                continue;
            }
            try {
                Query query = queryManager.createQuery(WATCHABLE_MIXIN_QUERY, "xpath");
                QueryResult queryResult = query.execute();
                NodeIterator iter = queryResult.getNodes();
                while (iter.hasNext()) {
                    Node observedNode = iter.nextNode();
                    EmailNotifyListener emailNotifyListener = new EmailNotifyListener(observedNode);
                    ObservationManager manager = session.getWorkspace().getObservationManager();
                    List<String> list = this.getDocumentNodeTypes(observedNode);
                    String[] observedNodeTypeNames = list.toArray(new String[list.size()]);
                    manager.addEventListener((EventListener)emailNotifyListener, 16, observedNode.getPath(), true, null, observedNodeTypeNames, false);
                }
                session.logout();
            }
            catch (Exception e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("==>>> Cannot init observer for node: " + e.getLocalizedMessage() + " in '" + repo.getName() + "' repository"));
                }
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
    }

    protected MessageConfig getMessageConfig() {
        return this.messageConfig_;
    }

    public void start() {
        block2: {
            try {
                this.reInitObserver();
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn((Object)"==>>> Exeption when startd WatchDocumentSerice!!!!");
            }
        }
    }

    public void stop() {
    }
}

