/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.portal.listener;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.portal.config.DataStorageImpl;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.portal.artifacts.CreatePortalArtifactsService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateLivePortalEventListener
extends Listener<DataStorageImpl, PortalConfig> {
    private static Log log = ExoLogger.getLogger(CreateLivePortalEventListener.class);
    private boolean autoCreatedDrive = true;
    private ArrayList<String> targetDrives = null;
    public static String AUTO_CREATE_DRIVE = "autoCreatedDrive";
    public static String TARGET_DRIVES = "targetDrives";

    public CreateLivePortalEventListener() {
    }

    public CreateLivePortalEventListener(InitParams params) throws Exception {
        if (params != null) {
            ValuesParam targets;
            ValueParam autoCreated = params.getValueParam(AUTO_CREATE_DRIVE);
            if (autoCreated != null) {
                this.autoCreatedDrive = Boolean.parseBoolean(autoCreated.getValue());
            }
            if ((targets = params.getValuesParam(TARGET_DRIVES)) != null) {
                this.targetDrives = targets.getValues();
            }
        }
    }

    public final void onEvent(Event<DataStorageImpl, PortalConfig> event) throws Exception {
        block11: {
            SessionProvider sessionProvider;
            ExoContainer container;
            PortalConfig portalConfig;
            block10: {
                LivePortalManagerService livePortalManagerService;
                block9: {
                    portalConfig = (PortalConfig)event.getData();
                    if (!PortalConfig.PORTAL_TYPE.equals(portalConfig.getType())) {
                        return;
                    }
                    container = ExoContainerContext.getCurrentContainer();
                    livePortalManagerService = (LivePortalManagerService)container.getComponentInstanceOfType(LivePortalManagerService.class);
                    sessionProvider = WCMCoreUtils.getSystemSessionProvider();
                    try {
                        livePortalManagerService.addLivePortal(sessionProvider, portalConfig);
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Create new resource storage for portal: " + portalConfig.getName()));
                        }
                    }
                    catch (Exception e) {
                        if (!log.isErrorEnabled()) break block9;
                        log.error((Object)("Error when create new resource storage: " + portalConfig.getName()), (Throwable)e);
                    }
                }
                if (this.autoCreatedDrive || !this.autoCreatedDrive && this.targetDrives != null && this.targetDrives.contains(portalConfig.getName())) {
                    ManageDriveService manageDriveService = (ManageDriveService)container.getComponentInstanceOfType(ManageDriveService.class);
                    WCMConfigurationService configurationService = (WCMConfigurationService)container.getComponentInstanceOfType(WCMConfigurationService.class);
                    try {
                        Node portal = livePortalManagerService.getLivePortal(sessionProvider, portalConfig.getName());
                        this.createPortalDrive(portal, portalConfig, configurationService, manageDriveService);
                    }
                    catch (Exception e) {
                        if (!log.isErrorEnabled()) break block10;
                        log.error((Object)("Error when create drive for portal: " + portalConfig.getName()), (Throwable)e);
                    }
                }
            }
            CreatePortalArtifactsService artifactsInitializerService = (CreatePortalArtifactsService)container.getComponentInstanceOfType(CreatePortalArtifactsService.class);
            try {
                artifactsInitializerService.deployArtifactsToPortal(sessionProvider, portalConfig.getName());
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block11;
                log.error((Object)("Error when create drive for portal: " + portalConfig.getName()), (Throwable)e);
            }
        }
    }

    private void createPortalDrive(Node portal, PortalConfig portalConfig, WCMConfigurationService wcmConfigService, ManageDriveService driveService) throws Exception {
        Session session = portal.getSession();
        String workspace = session.getWorkspace().getName();
        DriveData mainDriveData = wcmConfigService.getSiteDriveConfig();
        String permission = portalConfig.getEditPermission();
        String portalPath = portal.getPath();
        String homePath = mainDriveData.getHomePath();
        homePath = homePath.replaceAll("\\{siteName\\}", portal.getName());
        homePath = homePath.replaceAll("\\{sitePath\\}", portalPath);
        String views = mainDriveData.getViews();
        String icon = mainDriveData.getIcon();
        boolean viewReferences = mainDriveData.getViewPreferences();
        boolean viewNonDocument = mainDriveData.getViewNonDocument();
        boolean viewSideBar = mainDriveData.getViewSideBar();
        boolean showHiddenNode = mainDriveData.getShowHiddenNode();
        String allowCreateFolder = mainDriveData.getAllowCreateFolders();
        String allowNodeTypesOnTree = mainDriveData.getAllowNodeTypesOnTree();
        String driveName = String.format("%s-category", portal.getName());
        driveService.addDrive(driveName, workspace, permission, homePath, views, icon, viewReferences, viewNonDocument, viewSideBar, showHiddenNode, allowCreateFolder, allowNodeTypesOnTree);
        if (log.isInfoEnabled()) {
            log.info((Object)("Create new drive for portal: " + portalConfig.getName()));
        }
    }
}

