/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.LinkedHashMap;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.xml.Deserializer;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.config.AbstractRepositoryServiceConfiguration;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.nodetype.JiBX_binding_nodetypevaluesMungeAdapter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Managed
@NameTemplate(value={@Property(key="service", value="RepositoryServiceConfiguration")})
public class RepositoryServiceConfiguration
extends AbstractRepositoryServiceConfiguration
implements IUnmarshallable,
IMarshallable {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.RepositoryServiceConfiguration");
    public static final String JiBX_bindingList = "|org.exoplatform.services.jcr.config.JiBX_bindingFactory|";

    public RepositoryServiceConfiguration() {
    }

    public RepositoryServiceConfiguration(String defaultRepositoryName, List<RepositoryEntry> repositoryEntries) {
        this.defaultRepositoryName = defaultRepositoryName;
        this.repositoryConfigurations = repositoryEntries;
    }

    public final RepositoryEntry getRepositoryConfiguration(String name) throws RepositoryConfigurationException {
        for (int i = 0; i < this.getRepositoryConfigurations().size(); ++i) {
            RepositoryEntry conf = this.getRepositoryConfigurations().get(i);
            if (!conf.getName().equals(name)) continue;
            return conf;
        }
        throw new RepositoryConfigurationException("Repository not configured " + name);
    }

    protected final void init(InputStream is) throws RepositoryConfigurationException {
        try {
            IBindingFactory factory = BindingDirectory.getFactory(RepositoryServiceConfiguration.class);
            IUnmarshallingContext uctx = factory.createUnmarshallingContext();
            RepositoryServiceConfiguration conf = (RepositoryServiceConfiguration)uctx.unmarshalDocument(is, null);
            this.defaultRepositoryName = conf.getDefaultRepositoryName();
            this.repositoryConfigurations = conf.getRepositoryConfigurations();
        }
        catch (JiBXException e) {
            throw new RepositoryConfigurationException("Error in config initialization " + (Object)((Object)e), e);
        }
    }

    protected final void merge(InputStream is) throws RepositoryConfigurationException {
        try {
            List<RepositoryEntry> repositoryEntries;
            IBindingFactory factory;
            try {
                factory = (IBindingFactory)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<IBindingFactory>(){

                    @Override
                    public IBindingFactory run() throws Exception {
                        return BindingDirectory.getFactory(RepositoryServiceConfiguration.class);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof JiBXException) {
                    throw (JiBXException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
            IUnmarshallingContext uctx = factory.createUnmarshallingContext();
            RepositoryServiceConfiguration conf = (RepositoryServiceConfiguration)uctx.unmarshalDocument(is, null);
            if (this.defaultRepositoryName == null) {
                this.defaultRepositoryName = conf.getDefaultRepositoryName();
            }
            if ((repositoryEntries = conf.getRepositoryConfigurations()) == null || repositoryEntries.isEmpty()) {
                return;
            }
            if (this.repositoryConfigurations == null || this.repositoryConfigurations.isEmpty()) {
                this.repositoryConfigurations = repositoryEntries;
                return;
            }
            LinkedHashMap<String, RepositoryEntry> mapRepoEntries = new LinkedHashMap<String, RepositoryEntry>();
            for (RepositoryEntry entry : this.repositoryConfigurations) {
                mapRepoEntries.put(entry.getName(), entry);
            }
            for (RepositoryEntry entry : repositoryEntries) {
                RepositoryEntry currentEntry = (RepositoryEntry)mapRepoEntries.get(entry.getName());
                if (currentEntry == null) {
                    mapRepoEntries.put(entry.getName(), entry);
                    continue;
                }
                currentEntry.merge(entry);
            }
            this.getRepositoryConfigurations().clear();
            this.getRepositoryConfigurations().addAll(mapRepoEntries.values());
        }
        catch (JiBXException e) {
            throw new RepositoryConfigurationException("Error in config initialization " + (Object)((Object)e), e);
        }
    }

    @Override
    public boolean isRetainable() {
        return false;
    }

    public void retain() throws RepositoryException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Managed
    @ManagedDescription(value="The configuration of all the repositories in XML format.")
    public String getConfigurationXML() {
        StringWriter sw;
        block9: {
            sw = new StringWriter();
            IBindingFactory bfact = BindingDirectory.getFactory(RepositoryServiceConfiguration.class);
            IMarshallingContext mctx = bfact.createMarshallingContext();
            mctx.setIndent(2);
            mctx.marshalDocument((Object)this, "UTF-8", null, (Writer)sw);
            Object var5_6 = null;
            try {
                sw.close();
            }
            catch (IOException ignore) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("An exception occurred: " + ignore.getMessage()));
                }
                break block9;
            }
            {
                catch (Exception e) {
                    String string;
                    block10: {
                        LOG.warn((Object)"Cannot convert the configuration to XML format", (Throwable)e);
                        string = null;
                        Object var5_7 = null;
                        try {
                            sw.close();
                        }
                        catch (IOException ignore) {
                            if (!LOG.isTraceEnabled()) break block10;
                            LOG.trace((Object)("An exception occurred: " + ignore.getMessage()));
                        }
                    }
                    return string;
                }
            }
            catch (Throwable throwable) {
                block11: {
                    Object var5_8 = null;
                    try {
                        sw.close();
                    }
                    catch (IOException ignore) {
                        if (!LOG.isTraceEnabled()) break block11;
                        LOG.trace((Object)("An exception occurred: " + ignore.getMessage()));
                    }
                }
                throw throwable;
            }
        }
        return sw.toString();
    }

    public static /* synthetic */ RepositoryServiceConfiguration JiBX_binding_newinstance_2_0(RepositoryServiceConfiguration arg1, UnmarshallingContext arg2) throws JiBXException {
        if (arg1 == null) {
            arg1 = new RepositoryServiceConfiguration();
        }
        return arg1;
    }

    public static /* synthetic */ RepositoryServiceConfiguration JiBX_binding_unmarshalAttr_2_0(RepositoryServiceConfiguration arg1, UnmarshallingContext arg2) throws JiBXException {
        arg2.pushTrackedObject((Object)arg1);
        RepositoryServiceConfiguration repositoryServiceConfiguration = arg1;
        String string = arg2.attributeText(null, "default-repository");
        arg1.defaultRepositoryName = string == null ? null : Deserializer.resolveString((String)string);
        arg2.popObject();
        return arg1;
    }

    public static /* synthetic */ RepositoryServiceConfiguration JiBX_binding_unmarshal_2_0(RepositoryServiceConfiguration arg1, UnmarshallingContext arg2) throws JiBXException {
        arg2.pushObject((Object)arg1);
        RepositoryServiceConfiguration repositoryServiceConfiguration = arg1;
        arg2.parsePastStartTag(null, "repositories");
        arg1.repositoryConfigurations = JiBX_binding_nodetypevaluesMungeAdapter.JiBX_binding_unmarshal_1_8(JiBX_binding_nodetypevaluesMungeAdapter.JiBX_binding_newinstance_1_8(arg1.repositoryConfigurations, arg2), arg2);
        arg2.parsePastCurrentEndTag(null, "repositories");
        arg2.popObject();
        return arg1;
    }

    public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller("org.exoplatform.services.jcr.config.RepositoryServiceConfiguration").unmarshal((Object)this, arg1);
    }

    public /* synthetic */ String JiBX_getName() {
        return "org.exoplatform.services.jcr.config.RepositoryServiceConfiguration";
    }

    public static /* synthetic */ void JiBX_binding_marshalAttr_2_0(RepositoryServiceConfiguration arg1, MarshallingContext arg2) throws JiBXException {
        arg2.pushObject((Object)arg1);
        MarshallingContext marshallingContext = arg2.attribute(0, "default-repository", arg1.defaultRepositoryName);
        arg2.popObject();
    }

    public static /* synthetic */ void JiBX_binding_marshal_2_0(RepositoryServiceConfiguration arg1, MarshallingContext arg2) throws JiBXException {
        arg2.pushObject((Object)arg1);
        MarshallingContext marshallingContext = arg2;
        MarshallingContext marshallingContext2 = arg2.startTag(0, "repositories");
        JiBX_binding_nodetypevaluesMungeAdapter.JiBX_binding_marshal_1_8(arg1.repositoryConfigurations, arg2);
        marshallingContext2.endTag(0, "repositories");
        arg2.popObject();
    }

    public /* synthetic */ void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller("org.exoplatform.services.jcr.config.RepositoryServiceConfiguration").marshal((Object)this, arg1);
    }
}

