/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.jcr.cli;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import org.exoplatform.frameworks.jcr.cli.AbstractCliCommand;
import org.exoplatform.frameworks.jcr.cli.CliAppContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class HelpCommand
extends AbstractCliCommand {
    private static final Log LOG = ExoLogger.getLogger((String)"org.exoplatform.frameworks.jcr.cli.HelpCommand");
    private TreeMap<String, String> map = new TreeMap();
    private final int WORD_LENGTH = 15;

    public HelpCommand() {
        this.map.put("addnode", "<name>, <type> add node as child node of current node");
        this.map.put("mkdir", "<name>, <type> add node as child node of current node");
        this.map.put("login", "[<workspace name>] login to workspace");
        this.map.put("getitem", "<absPath> or <relPath> or <..> change the current item");
        this.map.put("cd", "<absPath> or <relPath> or < ..> change the current item, node names should not contain spaces");
        this.map.put("getnode", "<relPath> change the current node");
        this.map.put("cdn", "<relPath> change the current node");
        this.map.put("getproperty", "<relPath> change the current property");
        this.map.put("cdp", "<relPath> change the current property");
        this.map.put("getnodes", "<> get the list of nodes");
        this.map.put("lsn", "<> get the list of nodes");
        this.map.put("getproperties", "<> get the list of properties");
        this.map.put("lsp", "<> get the list of properties");
        this.map.put("ls", "<> get the list of the nodes and properties");
        this.map.put("setproperty", "<name>, <value>, <type> set the property");
        this.map.put("setp", "<name>, <value>, <type> set the property");
        this.map.put("getcontextinfo", "<> show the info of the current context");
        this.map.put("info", "<> show the info of the current context");
        this.map.put("remove", "<> remove the current item and go to parent item");
        this.map.put("rem", "<> remove the current item and go to parent item");
        this.map.put("copynode", "<srcAbsPath>, <destAbsPath> copy the node at srcAbsPath to the new location at destAbsPath");
        this.map.put("copy", "<srcAbsPath>, <destAbsPath> copy the node at srcAbsPath to the new location at destAbsPath");
        this.map.put("movenode", "<srcAbsPath>, <destAbsPath> move the node at srcAbsPath to the new location at destAbsPath");
        this.map.put("move", "<srcAbsPath>, <destAbsPath> move the node at srcAbsPath to the new location at destAbsPath");
        this.map.put("|", "<console size> limit the count of lines to output, e.g. |20 will displayed only 20 lines, works in standalone mode only");
    }

    public boolean perform(CliAppContext ctx) {
        StringBuilder output = new StringBuilder();
        try {
            String findHelpCommand;
            block13: {
                findHelpCommand = null;
                try {
                    findHelpCommand = ctx.getParameter(0);
                }
                catch (Exception e) {
                    if (!LOG.isTraceEnabled()) break block13;
                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
            }
            if (findHelpCommand != null) {
                Set<String> keys = this.map.keySet();
                Iterator<String> iterator = keys.iterator();
                boolean found = false;
                while (iterator.hasNext()) {
                    String currentHelpCommand = iterator.next();
                    if (!findHelpCommand.equals(currentHelpCommand)) continue;
                    StringBuilder findHelpCommandFormatted = new StringBuilder(currentHelpCommand);
                    int commandLength = currentHelpCommand.length();
                    if (commandLength < 15) {
                        for (int i = currentHelpCommand.length(); i < 15; ++i) {
                            findHelpCommandFormatted.append(" ");
                        }
                    }
                    output.append((CharSequence)findHelpCommandFormatted).append(" - ").append(this.map.get(findHelpCommand)).append("\n");
                    found = true;
                    break;
                }
                if (!found) {
                    output.append("Can't find help for the: ").append(findHelpCommand).append(" command\n");
                }
            } else {
                Set<String> keys = this.map.keySet();
                for (String currentHelpCommand : keys) {
                    StringBuilder currentHelpCommandFormatted = new StringBuilder(currentHelpCommand);
                    int commandLength = currentHelpCommand.length();
                    if (commandLength < 15) {
                        for (int i = currentHelpCommand.length(); i < 15; ++i) {
                            currentHelpCommandFormatted.append(" ");
                        }
                    }
                    output.append((CharSequence)currentHelpCommandFormatted).append(" - ").append(this.map.get(currentHelpCommand)).append("\n");
                }
            }
        }
        catch (Exception e) {
            output = new StringBuilder("Can't execute command - ").append(e.getMessage()).append("\n");
        }
        ctx.setOutput(output.toString());
        return false;
    }
}

