/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.fckeditor;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.ecm.connector.fckeditor.FCKUtils;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.portal.PortalFolderSchemaHandler;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.connector.BaseConnector;
import org.exoplatform.wcm.connector.fckeditor.LinkFileHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Path(value="/wcmLink/")
public class LinkConnector
extends BaseConnector
implements ResourceContainer {
    private LinkFileHandler linkFileHandler = new LinkFileHandler();
    private static Log log = ExoLogger.getLogger(LinkFileHandler.class);

    @GET
    @Path(value="/getFoldersAndFiles/")
    public Response getFoldersAndFiles(@QueryParam(value="repositoryName") String repositoryName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="jcrPath") String jcrPath, @QueryParam(value="currentFolder") String currentFolder, @QueryParam(value="currentPortal") String currentPortal, @QueryParam(value="command") String command, @QueryParam(value="type") String type) throws Exception {
        block3: {
            try {
                Response response = this.buildXMLResponseOnExpand(currentFolder, currentPortal, workspaceName, repositoryName, jcrPath, command);
                if (response != null) {
                    return response;
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Error when perform getFoldersAndFiles: ", (Throwable)e);
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        return Response.ok().header("Last-Modified", (Object)dateFormat.format(new Date())).build();
    }

    protected Response buildXMLResponseOnExpand(String currentFolder, String runningPortal, String workspaceName, String repositoryName, String jcrPath, String command) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        Node sharedPortal = this.livePortalManagerService.getLiveSharedPortal(sessionProvider, repositoryName);
        Node currentPortalNode = this.getCurrentPortalNode(repositoryName, jcrPath, runningPortal, sharedPortal);
        if (currentFolder.length() == 0 || "/".equals(currentFolder)) {
            return this.buildXMLResponseForRoot(currentPortalNode, sharedPortal, command);
        }
        String currentPortalRelPath = "/" + currentPortalNode.getName() + "/";
        String sharePortalRelPath = "/" + sharedPortal.getName() + "/";
        if (!currentPortalNode.getPath().equals(sharedPortal.getPath()) && currentFolder.startsWith(sharePortalRelPath)) {
            if (currentFolder.equals(sharePortalRelPath)) {
                return this.buildXMLResponseForPortal(sharedPortal, null, command);
            }
            Node currentContentStorageNode = this.getCorrectContentStorage(sharedPortal, null, currentFolder);
            return this.buildXMLResponseForContentStorage(currentContentStorageNode, command);
        }
        if (!currentPortalNode.getPath().equals(sharedPortal.getPath()) && currentFolder.startsWith(currentPortalRelPath)) {
            return this.buildXMLResponseCommon(currentPortalNode, null, currentFolder, command);
        }
        return this.buildXMLResponseCommon(sharedPortal, null, currentFolder, command);
    }

    protected Response buildXMLResponseForContentStorage(Node node, String command) throws Exception {
        Element rootElement = FCKUtils.createRootElement(command, node, this.folderHandler.getFolderType(node));
        Document document = rootElement.getOwnerDocument();
        Element folders = document.createElement("Foders");
        Element files = document.createElement("Files");
        NodeIterator iterator = node.getNodes();
        while (iterator.hasNext()) {
            String sourceType;
            String fileType;
            Node child = iterator.nextNode();
            if (child.isNodeType("exo:hiddenable")) continue;
            String folderType = this.folderHandler.getFolderType(child);
            if (folderType != null) {
                Element folder = this.folderHandler.createFolderElement(document, child, folderType);
                folders.appendChild(folder);
            }
            if ((fileType = this.linkFileHandler.getFileType(child, sourceType = this.getContentStorageType())) == null) continue;
            Element file = this.linkFileHandler.createFileElement(document, child, fileType);
            files.appendChild(file);
        }
        rootElement.appendChild(folders);
        rootElement.appendChild(files);
        return this.getResponse(document);
    }

    protected Node getRootContentStorage(Node parentNode) throws Exception {
        try {
            PortalFolderSchemaHandler folderSchemaHandler = (PortalFolderSchemaHandler)this.webSchemaConfigService.getWebSchemaHandlerByType(PortalFolderSchemaHandler.class);
            return folderSchemaHandler.getLinkFolder(parentNode);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e);
            }
            return null;
        }
    }

    protected String getContentStorageType() throws Exception {
        return "link";
    }
}

