/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.core.lock.LockTableHandler;
import org.exoplatform.services.jcr.impl.core.lock.jbosscache.CacheableLockManagerImpl;
import org.exoplatform.services.jcr.impl.core.lock.jbosscache.JBCLockTableHandler;
import org.exoplatform.services.jcr.impl.core.lock.jbosscache.JBCShareableLockTableHandler;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class LockTableHandlerFactory {
    protected static final Log LOG = ExoLogger.getExoLogger((String)"exo.jcr.component.core.LockTableHandlerFactory");

    public static LockTableHandler getHandler(WorkspaceEntry workspaceEntry) {
        String lockManagerFqn = workspaceEntry.getLockManager().getType();
        String jbcLockManagerFqn = "org.exoplatform.services.jcr.impl.core.lock.jbosscache.CacheableLockManagerImpl";
        String ispnLockManagerFqn = "org.exoplatform.services.jcr.impl.core.lock.infinispan.ISPNCacheableLockManagerImpl";
        String ispnLockTableHandlerFqn = "org.exoplatform.services.jcr.impl.core.lock.infinispan.ISPNLockTableHandler";
        if (jbcLockManagerFqn.equals(lockManagerFqn)) {
            if (LockTableHandlerFactory.isJbcCacheShareable(workspaceEntry).booleanValue()) {
                return new JBCShareableLockTableHandler(workspaceEntry);
            }
            return new JBCLockTableHandler(workspaceEntry);
        }
        if (ispnLockManagerFqn.equals(lockManagerFqn)) {
            try {
                Constructor<?>[] ispnLockTableHandlerClassConstructors;
                Class<?> ispnLockTableHandlerClass = Class.forName(ispnLockTableHandlerFqn);
                for (Constructor<?> constructor : ispnLockTableHandlerClassConstructors = ispnLockTableHandlerClass.getDeclaredConstructors()) {
                    Class<?>[] parameterTypes = constructor.getParameterTypes();
                    if (parameterTypes.length != 1 || parameterTypes[0] != WorkspaceEntry.class) continue;
                    return (LockTableHandler)constructor.newInstance(workspaceEntry);
                }
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (InstantiationException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        throw new UnsupportedOperationException("Currently supported only CacheableLockManagerImpl and ISPNCacheableLockManagerImpl");
    }

    private static Boolean isJbcCacheShareable(WorkspaceEntry workspaceEntry) {
        return workspaceEntry.getLockManager().getParameterBoolean("jbosscache-shareable", CacheableLockManagerImpl.JBOSSCACHE_SHAREABLE_DEFAULT);
    }
}

