/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database;

import com.sun.rowset.CachedRowSetImpl;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.database.DAO;
import org.exoplatform.services.database.DBObject;
import org.exoplatform.services.database.DBObjectQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBPageList<T extends DBObject>
extends PageList {
    protected DAO<T> dao_;
    protected String query_;

    public DBPageList(int pageSize, DAO<T> dao, DBObjectQuery<T> query) throws Exception {
        super(pageSize);
        this.dao_ = dao;
        this.query_ = query.toQuery();
        Object retObj = this.dao_.loadDBField(query.toCountQuery());
        if (retObj instanceof Integer) {
            super.setAvailablePage(((Integer)retObj).intValue());
        } else if (retObj instanceof BigDecimal) {
            super.setAvailablePage(((BigDecimal)retObj).intValue());
        } else {
            super.setAvailablePage(((Long)retObj).intValue());
        }
    }

    public DBPageList(int pageSize, DAO<T> dao, String query, String queryCounter) throws Exception {
        super(pageSize);
        this.dao_ = dao;
        this.query_ = query;
        Object retObj = this.dao_.loadDBField(queryCounter);
        if (retObj instanceof Integer) {
            super.setAvailablePage(((Integer)retObj).intValue());
        } else if (retObj instanceof BigDecimal) {
            super.setAvailablePage(((BigDecimal)retObj).intValue());
        } else {
            super.setAvailablePage(((Long)retObj).intValue());
        }
    }

    protected void populateCurrentPage(int currentPage) throws Exception {
        this.currentPage_ = currentPage;
        if (this.currentListPage_ != null) {
            this.currentListPage_.clear();
        } else {
            this.currentListPage_ = new ArrayList();
        }
        this.loadPageList(this, this.query_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPageList(DBPageList<T> pageList, String query) throws Exception {
        Connection connection = null;
        try {
            connection = this.dao_.getExoDatasource().getConnection();
            Statement statement = connection.createStatement(1004, 1007);
            ResultSet resultSet = statement.executeQuery(query);
            CachedRowSetImpl crs = new CachedRowSetImpl();
            crs.setPageSize(pageList.getPageSize());
            crs.populate(resultSet, (pageList.getCurrentPage() - 1) * pageList.getPageSize() + 1);
            while (crs.next()) {
                T bean = this.dao_.createInstance();
                this.dao_.getDBObjectMapper().mapResultSet(crs, bean);
                this.currentListPage_.add(bean);
            }
            resultSet.close();
            statement.close();
        }
        finally {
            this.dao_.getExoDatasource().closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getAll() throws Exception {
        Connection connection = null;
        try {
            connection = this.dao_.getExoDatasource().getConnection();
            Statement statement = connection.createStatement(1004, 1007);
            ResultSet resultSet = statement.executeQuery(this.query_);
            ArrayList<T> list = new ArrayList<T>();
            while (resultSet.next()) {
                T bean = this.dao_.createInstance();
                this.dao_.getDBObjectMapper().mapResultSet(resultSet, bean);
                list.add(bean);
            }
            resultSet.close();
            statement.close();
            ArrayList<T> arrayList = list;
            return arrayList;
        }
        finally {
            this.dao_.getExoDatasource().closeConnection(connection);
        }
    }
}

