/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jgroups.Address;
import org.jgroups.protocols.FILE_PING;
import org.jgroups.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class S3_PING
extends FILE_PING {
    protected String access_key = null;
    protected String secret_access_key = null;
    protected String prefix = null;
    protected AWSAuthConnection conn = null;

    @Override
    public boolean setProperties(Properties props) {
        String str = props.getProperty("access_key");
        if (str != null) {
            this.access_key = str;
            props.remove("access_key");
        }
        if ((str = props.getProperty("secret_access_key")) != null) {
            this.secret_access_key = str;
            props.remove("secret_access_key");
        }
        if ((str = props.getProperty("prefix")) != null) {
            this.prefix = str;
            props.remove("prefix");
        }
        if (this.access_key == null || this.secret_access_key == null) {
            throw new IllegalArgumentException("access_key and secret_access_key must be non-null");
        }
        return super.setProperties(props);
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.conn = new AWSAuthConnection(this.access_key, this.secret_access_key);
        if (this.prefix != null && this.prefix.length() > 0) {
            ListAllMyBucketsResponse bucket_list = this.conn.listAllMyBuckets(null);
            List buckets = bucket_list.entries;
            if (buckets != null) {
                boolean found = false;
                for (Object tmp : buckets) {
                    if (!(tmp instanceof Bucket)) continue;
                    Bucket bucket = (Bucket)tmp;
                    if (!bucket.name.startsWith(this.prefix)) continue;
                    this.location = bucket.name;
                    found = true;
                }
                if (!found) {
                    this.location = this.prefix + "-" + UUID.randomUUID().toString();
                }
            }
        }
        if (!this.conn.checkBucketExists(this.location)) {
            this.conn.createBucket((String)this.location, (String)AWSAuthConnection.LOCATION_DEFAULT, null).connection.getResponseMessage();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                S3_PING.this.remove(S3_PING.this.group_addr, S3_PING.this.local_addr);
            }
        });
    }

    @Override
    protected void createRootDir() {
    }

    @Override
    protected List<Address> readAll(String clustername) {
        if (clustername == null) {
            return null;
        }
        ArrayList<Address> retval = new ArrayList<Address>();
        try {
            ListBucketResponse rsp = this.conn.listBucket(this.location, clustername, null, null, null);
            if (rsp.entries != null) {
                for (ListEntry key : rsp.entries) {
                    byte[] buf;
                    GetResponse val = this.conn.get(this.location, key.key, null);
                    if (val.object == null || (buf = val.object.data) == null) continue;
                    try {
                        Address addr = (Address)Util.objectFromByteBuffer(buf);
                        retval.add(addr);
                    }
                    catch (Exception e) {
                        this.log.error((Object)"failed marshalling buffer to address", (Throwable)e);
                    }
                }
            }
            return retval;
        }
        catch (IOException ex) {
            this.log.error((Object)"failed reading addresses", (Throwable)ex);
            return retval;
        }
    }

    @Override
    protected void writeToFile(Address addr, String clustername) {
        if (clustername == null || addr == null) {
            return;
        }
        String key = clustername + "/" + addr.toString();
        try {
            TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>();
            headers.put("Content-Type", Arrays.asList("text/plain"));
            byte[] buf = Util.objectToByteBuffer(addr);
            S3Object val = new S3Object(buf, null);
            this.conn.put((String)this.location, (String)key, (S3Object)val, headers).connection.getResponseMessage();
        }
        catch (Exception e) {
            this.log.error((Object)("failed marshalling address " + addr + " to buffer"), (Throwable)e);
        }
    }

    @Override
    protected void remove(String clustername, Address addr) {
        if (clustername == null || addr == null) {
            return;
        }
        String key = clustername + "/" + addr.toString();
        try {
            TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>();
            headers.put("Content-Type", Arrays.asList("text/plain"));
            this.conn.delete((String)this.location, (String)key, headers).connection.getResponseMessage();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("removing " + this.location + "/" + key));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"failure removing data", (Throwable)e);
        }
    }

    static class Base64 {
        public static final int NO_OPTIONS = 0;
        public static final int ENCODE = 1;
        public static final int DECODE = 0;
        public static final int GZIP = 2;
        public static final int DONT_BREAK_LINES = 8;
        private static final int MAX_LINE_LENGTH = 76;
        private static final byte EQUALS_SIGN = 61;
        private static final byte NEW_LINE = 10;
        private static final String PREFERRED_ENCODING = "UTF-8";
        private static final byte[] ALPHABET;
        private static final byte[] _NATIVE_ALPHABET;
        private static final byte[] DECODABET;
        private static final byte WHITE_SPACE_ENC = -5;
        private static final byte EQUALS_SIGN_ENC = -1;

        private Base64() {
        }

        private static byte[] encode3to4(byte[] b4, byte[] threeBytes, int numSigBytes) {
            Base64.encode3to4(threeBytes, 0, numSigBytes, b4, 0);
            return b4;
        }

        private static byte[] encode3to4(byte[] source, int srcOffset, int numSigBytes, byte[] destination, int destOffset) {
            int inBuff = (numSigBytes > 0 ? source[srcOffset] << 24 >>> 8 : 0) | (numSigBytes > 1 ? source[srcOffset + 1] << 24 >>> 16 : 0) | (numSigBytes > 2 ? source[srcOffset + 2] << 24 >>> 24 : 0);
            switch (numSigBytes) {
                case 3: {
                    destination[destOffset] = ALPHABET[inBuff >>> 18];
                    destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                    destination[destOffset + 2] = ALPHABET[inBuff >>> 6 & 0x3F];
                    destination[destOffset + 3] = ALPHABET[inBuff & 0x3F];
                    return destination;
                }
                case 2: {
                    destination[destOffset] = ALPHABET[inBuff >>> 18];
                    destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                    destination[destOffset + 2] = ALPHABET[inBuff >>> 6 & 0x3F];
                    destination[destOffset + 3] = 61;
                    return destination;
                }
                case 1: {
                    destination[destOffset] = ALPHABET[inBuff >>> 18];
                    destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                    destination[destOffset + 2] = 61;
                    destination[destOffset + 3] = 61;
                    return destination;
                }
            }
            return destination;
        }

        public static String encodeObject(Serializable serializableObject) {
            return Base64.encodeObject(serializableObject, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String encodeObject(Serializable serializableObject, int options) {
            ByteArrayOutputStream baos = null;
            java.io.OutputStream b64os = null;
            ObjectOutputStream oos = null;
            DeflaterOutputStream gzos = null;
            int gzip = options & 2;
            int dontBreakLines = options & 8;
            try {
                baos = new ByteArrayOutputStream();
                b64os = new OutputStream(baos, 1 | dontBreakLines);
                if (gzip == 2) {
                    gzos = new GZIPOutputStream(b64os);
                    oos = new ObjectOutputStream(gzos);
                } else {
                    oos = new ObjectOutputStream(b64os);
                }
                oos.writeObject(serializableObject);
            }
            catch (IOException e) {
                e.printStackTrace();
                String string = null;
                return string;
            }
            finally {
                try {
                    oos.close();
                }
                catch (Exception e) {}
                try {
                    gzos.close();
                }
                catch (Exception e) {}
                try {
                    b64os.close();
                }
                catch (Exception e) {}
                try {
                    baos.close();
                }
                catch (Exception e) {}
            }
            try {
                return new String(baos.toByteArray(), PREFERRED_ENCODING);
            }
            catch (UnsupportedEncodingException uue) {
                return new String(baos.toByteArray());
            }
        }

        public static String encodeBytes(byte[] source) {
            return Base64.encodeBytes(source, 0, source.length, 0);
        }

        public static String encodeBytes(byte[] source, int options) {
            return Base64.encodeBytes(source, 0, source.length, options);
        }

        public static String encodeBytes(byte[] source, int off, int len) {
            return Base64.encodeBytes(source, off, len, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String encodeBytes(byte[] source, int off, int len, int options) {
            int dontBreakLines = options & 8;
            int gzip = options & 2;
            if (gzip == 2) {
                ByteArrayOutputStream baos = null;
                DeflaterOutputStream gzos = null;
                OutputStream b64os = null;
                try {
                    baos = new ByteArrayOutputStream();
                    b64os = new OutputStream(baos, 1 | dontBreakLines);
                    gzos = new GZIPOutputStream(b64os);
                    ((GZIPOutputStream)gzos).write(source, off, len);
                    gzos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    String string = null;
                    return string;
                }
                finally {
                    try {
                        gzos.close();
                    }
                    catch (Exception e) {}
                    try {
                        b64os.close();
                    }
                    catch (Exception e) {}
                    try {
                        baos.close();
                    }
                    catch (Exception e) {}
                }
                try {
                    return new String(baos.toByteArray(), PREFERRED_ENCODING);
                }
                catch (UnsupportedEncodingException uue) {
                    return new String(baos.toByteArray());
                }
            }
            boolean breakLines = dontBreakLines == 0;
            int len43 = len * 4 / 3;
            byte[] outBuff = new byte[len43 + (len % 3 > 0 ? 4 : 0) + (breakLines ? len43 / 76 : 0)];
            int d = 0;
            int e = 0;
            int len2 = len - 2;
            int lineLength = 0;
            while (d < len2) {
                Base64.encode3to4(source, d + off, 3, outBuff, e);
                if (breakLines && (lineLength += 4) == 76) {
                    outBuff[e + 4] = 10;
                    ++e;
                    lineLength = 0;
                }
                d += 3;
                e += 4;
            }
            if (d < len) {
                Base64.encode3to4(source, d + off, len - d, outBuff, e);
                e += 4;
            }
            try {
                return new String(outBuff, 0, e, PREFERRED_ENCODING);
            }
            catch (UnsupportedEncodingException uue) {
                return new String(outBuff, 0, e);
            }
        }

        private static int decode4to3(byte[] source, int srcOffset, byte[] destination, int destOffset) {
            if (source[srcOffset + 2] == 61) {
                int outBuff = (DECODABET[source[srcOffset]] & 0xFF) << 18 | (DECODABET[source[srcOffset + 1]] & 0xFF) << 12;
                destination[destOffset] = (byte)(outBuff >>> 16);
                return 1;
            }
            if (source[srcOffset + 3] == 61) {
                int outBuff = (DECODABET[source[srcOffset]] & 0xFF) << 18 | (DECODABET[source[srcOffset + 1]] & 0xFF) << 12 | (DECODABET[source[srcOffset + 2]] & 0xFF) << 6;
                destination[destOffset] = (byte)(outBuff >>> 16);
                destination[destOffset + 1] = (byte)(outBuff >>> 8);
                return 2;
            }
            try {
                int outBuff = (DECODABET[source[srcOffset]] & 0xFF) << 18 | (DECODABET[source[srcOffset + 1]] & 0xFF) << 12 | (DECODABET[source[srcOffset + 2]] & 0xFF) << 6 | DECODABET[source[srcOffset + 3]] & 0xFF;
                destination[destOffset] = (byte)(outBuff >> 16);
                destination[destOffset + 1] = (byte)(outBuff >> 8);
                destination[destOffset + 2] = (byte)outBuff;
                return 3;
            }
            catch (Exception e) {
                System.out.println(String.valueOf(source[srcOffset]) + ": " + DECODABET[source[srcOffset]]);
                System.out.println(String.valueOf(source[srcOffset + 1]) + ": " + DECODABET[source[srcOffset + 1]]);
                System.out.println(String.valueOf(source[srcOffset + 2]) + ": " + DECODABET[source[srcOffset + 2]]);
                System.out.println(String.valueOf(source[srcOffset + 3]) + ": " + DECODABET[source[srcOffset + 3]]);
                return -1;
            }
        }

        public static byte[] decode(byte[] source, int off, int len) {
            int len34 = len * 3 / 4;
            byte[] outBuff = new byte[len34];
            int outBuffPosn = 0;
            byte[] b4 = new byte[4];
            int b4Posn = 0;
            int i = 0;
            byte sbiCrop = 0;
            byte sbiDecode = 0;
            for (i = off; i < off + len; ++i) {
                sbiCrop = (byte)(source[i] & 0x7F);
                sbiDecode = DECODABET[sbiCrop];
                if (sbiDecode >= -5) {
                    if (sbiDecode < -1) continue;
                    b4[b4Posn++] = sbiCrop;
                    if (b4Posn <= 3) continue;
                    outBuffPosn += Base64.decode4to3(b4, 0, outBuff, outBuffPosn);
                    b4Posn = 0;
                    if (sbiCrop != 61) continue;
                    break;
                }
                System.err.println("Bad Base64 input character at " + i + ": " + source[i] + "(decimal)");
                return null;
            }
            byte[] out = new byte[outBuffPosn];
            System.arraycopy(outBuff, 0, out, 0, outBuffPosn);
            return out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static byte[] decode(String s) {
            int head;
            byte[] bytes;
            try {
                bytes = s.getBytes(PREFERRED_ENCODING);
            }
            catch (UnsupportedEncodingException uee) {
                bytes = s.getBytes();
            }
            bytes = Base64.decode(bytes, 0, bytes.length);
            if (bytes != null && bytes.length >= 4 && 35615 == (head = bytes[0] & 0xFF | bytes[1] << 8 & 0xFF00)) {
                ByteArrayInputStream bais = null;
                GZIPInputStream gzis = null;
                ByteArrayOutputStream baos = null;
                byte[] buffer = new byte[2048];
                int length = 0;
                try {
                    baos = new ByteArrayOutputStream();
                    bais = new ByteArrayInputStream(bytes);
                    gzis = new GZIPInputStream(bais);
                    while ((length = gzis.read(buffer)) >= 0) {
                        baos.write(buffer, 0, length);
                    }
                    bytes = baos.toByteArray();
                }
                catch (IOException e) {
                }
                finally {
                    try {
                        baos.close();
                    }
                    catch (Exception e) {}
                    try {
                        gzis.close();
                    }
                    catch (Exception e) {}
                    try {
                        bais.close();
                    }
                    catch (Exception e) {}
                }
            }
            return bytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Object decodeToObject(String encodedObject) {
            byte[] objBytes = Base64.decode(encodedObject);
            ByteArrayInputStream bais = null;
            ObjectInputStream ois = null;
            Object obj = null;
            try {
                bais = new ByteArrayInputStream(objBytes);
                ois = new ObjectInputStream(bais);
                obj = ois.readObject();
            }
            catch (IOException e) {
                e.printStackTrace();
                obj = null;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                obj = null;
            }
            finally {
                try {
                    if (bais != null) {
                        bais.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (Exception e) {}
            }
            return obj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean encodeToFile(byte[] dataToEncode, String filename) {
            boolean success = false;
            OutputStream bos = null;
            try {
                bos = new OutputStream(new FileOutputStream(filename), 1);
                bos.write(dataToEncode);
                success = true;
            }
            catch (IOException e) {
                success = false;
            }
            finally {
                try {
                    if (bos != null) {
                        bos.close();
                    }
                }
                catch (Exception e) {}
            }
            return success;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean decodeToFile(String dataToDecode, String filename) {
            boolean success = false;
            OutputStream bos = null;
            try {
                bos = new OutputStream(new FileOutputStream(filename), 0);
                bos.write(dataToDecode.getBytes(PREFERRED_ENCODING));
                success = true;
            }
            catch (IOException e) {
                success = false;
            }
            finally {
                try {
                    if (bos != null) {
                        bos.close();
                    }
                }
                catch (Exception e) {}
            }
            return success;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static byte[] decodeFromFile(String filename) {
            byte[] decodedData = null;
            FilterInputStream bis = null;
            try {
                File file = new File(filename);
                byte[] buffer = null;
                int length = 0;
                int numBytes = 0;
                if (file.length() > Integer.MAX_VALUE) {
                    System.err.println("File is too big for this convenience method (" + file.length() + " bytes).");
                    byte[] byArray = null;
                    return byArray;
                }
                buffer = new byte[(int)file.length()];
                bis = new InputStream(new BufferedInputStream(new FileInputStream(file)), 0);
                while ((numBytes = ((InputStream)bis).read(buffer, length, 4096)) >= 0) {
                    length += numBytes;
                }
                decodedData = new byte[length];
                System.arraycopy(buffer, 0, decodedData, 0, length);
            }
            catch (IOException e) {
                System.err.println("Error decoding from file " + filename);
            }
            finally {
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (Exception exception) {}
            }
            return decodedData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String encodeFromFile(String filename) {
            String encodedData = null;
            FilterInputStream bis = null;
            try {
                File file = new File(filename);
                byte[] buffer = new byte[(int)((double)file.length() * 1.4)];
                int length = 0;
                int numBytes = 0;
                bis = new InputStream(new BufferedInputStream(new FileInputStream(file)), 1);
                while ((numBytes = ((InputStream)bis).read(buffer, length, 4096)) >= 0) {
                    length += numBytes;
                }
                encodedData = new String(buffer, 0, length, PREFERRED_ENCODING);
            }
            catch (IOException e) {
                System.err.println("Error encoding from file " + filename);
            }
            finally {
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (Exception exception) {}
            }
            return encodedData;
        }

        static {
            byte[] __bytes;
            _NATIVE_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
            try {
                __bytes = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes(PREFERRED_ENCODING);
            }
            catch (UnsupportedEncodingException use) {
                __bytes = _NATIVE_ALPHABET;
            }
            ALPHABET = __bytes;
            DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, -9, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9};
        }

        public static class OutputStream
        extends FilterOutputStream {
            private boolean encode;
            private int position;
            private byte[] buffer;
            private int bufferLength;
            private int lineLength;
            private boolean breakLines;
            private byte[] b4;
            private boolean suspendEncoding;

            public OutputStream(java.io.OutputStream out) {
                this(out, 1);
            }

            public OutputStream(java.io.OutputStream out, int options) {
                super(out);
                this.breakLines = (options & 8) != 8;
                this.encode = (options & 1) == 1;
                this.bufferLength = this.encode ? 3 : 4;
                this.buffer = new byte[this.bufferLength];
                this.position = 0;
                this.lineLength = 0;
                this.suspendEncoding = false;
                this.b4 = new byte[4];
            }

            @Override
            public void write(int theByte) throws IOException {
                if (this.suspendEncoding) {
                    this.out.write(theByte);
                    return;
                }
                if (this.encode) {
                    this.buffer[this.position++] = (byte)theByte;
                    if (this.position >= this.bufferLength) {
                        this.out.write(Base64.encode3to4(this.b4, this.buffer, this.bufferLength));
                        this.lineLength += 4;
                        if (this.breakLines && this.lineLength >= 76) {
                            this.out.write(10);
                            this.lineLength = 0;
                        }
                        this.position = 0;
                    }
                } else if (DECODABET[theByte & 0x7F] > -5) {
                    this.buffer[this.position++] = (byte)theByte;
                    if (this.position >= this.bufferLength) {
                        int len = Base64.decode4to3(this.buffer, 0, this.b4, 0);
                        this.out.write(this.b4, 0, len);
                        this.position = 0;
                    }
                } else if (DECODABET[theByte & 0x7F] != -5) {
                    throw new IOException("Invalid character in Base64 data.");
                }
            }

            @Override
            public void write(byte[] theBytes, int off, int len) throws IOException {
                if (this.suspendEncoding) {
                    this.out.write(theBytes, off, len);
                    return;
                }
                for (int i = 0; i < len; ++i) {
                    this.write(theBytes[off + i]);
                }
            }

            public void flushBase64() throws IOException {
                if (this.position > 0) {
                    if (this.encode) {
                        this.out.write(Base64.encode3to4(this.b4, this.buffer, this.position));
                        this.position = 0;
                    } else {
                        throw new IOException("Base64 input not properly padded.");
                    }
                }
            }

            @Override
            public void close() throws IOException {
                this.flushBase64();
                super.close();
                this.buffer = null;
                this.out = null;
            }

            public void suspendEncoding() throws IOException {
                this.flushBase64();
                this.suspendEncoding = true;
            }

            public void resumeEncoding() {
                this.suspendEncoding = false;
            }
        }

        public static class InputStream
        extends FilterInputStream {
            private boolean encode;
            private int position;
            private byte[] buffer;
            private int bufferLength;
            private int numSigBytes;
            private int lineLength;
            private boolean breakLines;

            public InputStream(java.io.InputStream in) {
                this(in, 0);
            }

            public InputStream(java.io.InputStream in, int options) {
                super(in);
                this.breakLines = (options & 8) != 8;
                this.encode = (options & 1) == 1;
                this.bufferLength = this.encode ? 4 : 3;
                this.buffer = new byte[this.bufferLength];
                this.position = -1;
                this.lineLength = 0;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public int read() throws IOException {
                if (this.position < 0) {
                    if (this.encode) {
                        byte[] b3 = new byte[3];
                        int numBinaryBytes = 0;
                        for (int i = 0; i < 3; ++i) {
                            try {
                                int b = this.in.read();
                                if (b < 0) continue;
                                b3[i] = (byte)b;
                                ++numBinaryBytes;
                                continue;
                            }
                            catch (IOException e) {
                                if (i != 0) continue;
                                throw e;
                            }
                        }
                        if (numBinaryBytes <= 0) return -1;
                        Base64.encode3to4(b3, 0, numBinaryBytes, this.buffer, 0);
                        this.position = 0;
                        this.numSigBytes = 4;
                    } else {
                        byte[] b4 = new byte[4];
                        int i = 0;
                        for (i = 0; i < 4; ++i) {
                            int b = 0;
                            while ((b = this.in.read()) >= 0 && DECODABET[b & 0x7F] <= -5) {
                            }
                            if (b < 0) break;
                            b4[i] = (byte)b;
                        }
                        if (i == 4) {
                            this.numSigBytes = Base64.decode4to3(b4, 0, this.buffer, 0);
                            this.position = 0;
                        } else {
                            if (i != 0) throw new IOException("Improperly padded Base64 input.");
                            return -1;
                        }
                    }
                }
                if (this.position < 0) throw new IOException("Error in Base64 code reading stream.");
                if (this.position >= this.numSigBytes) {
                    return -1;
                }
                if (this.encode && this.breakLines && this.lineLength >= 76) {
                    this.lineLength = 0;
                    return 10;
                }
                ++this.lineLength;
                byte b = this.buffer[this.position++];
                if (this.position < this.bufferLength) return b & 0xFF;
                this.position = -1;
                return b & 0xFF;
            }

            @Override
            public int read(byte[] dest, int off, int len) throws IOException {
                int i;
                for (i = 0; i < len; ++i) {
                    int b = this.read();
                    if (b < 0) {
                        if (i != 0) break;
                        return -1;
                    }
                    dest[off + i] = (byte)b;
                }
                return i;
            }
        }
    }

    static class Utils {
        static final String METADATA_PREFIX = "x-amz-meta-";
        static final String AMAZON_HEADER_PREFIX = "x-amz-";
        static final String ALTERNATIVE_DATE_HEADER = "x-amz-date";
        public static final String DEFAULT_HOST = "s3.amazonaws.com";
        public static final int SECURE_PORT = 443;
        public static final int INSECURE_PORT = 80;
        private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";

        Utils() {
        }

        static String makeCanonicalString(String method, String bucket, String key, Map pathArgs, Map headers) {
            return Utils.makeCanonicalString(method, bucket, key, pathArgs, headers, null);
        }

        static String makeCanonicalString(String method, String bucketName, String key, Map pathArgs, Map headers, String expires) {
            StringBuilder buf = new StringBuilder();
            buf.append(method + "\n");
            TreeMap<String, String> interestingHeaders = new TreeMap<String, String>();
            if (headers != null) {
                for (String hashKey : headers.keySet()) {
                    String lk;
                    if (hashKey == null || !(lk = hashKey.toLowerCase()).equals("content-type") && !lk.equals("content-md5") && !lk.equals("date") && !lk.startsWith(AMAZON_HEADER_PREFIX)) continue;
                    List s = (List)headers.get(hashKey);
                    interestingHeaders.put(lk, Utils.concatenateList(s));
                }
            }
            if (interestingHeaders.containsKey(ALTERNATIVE_DATE_HEADER)) {
                interestingHeaders.put("date", "");
            }
            if (expires != null) {
                interestingHeaders.put("date", expires);
            }
            if (!interestingHeaders.containsKey("content-type")) {
                interestingHeaders.put("content-type", "");
            }
            if (!interestingHeaders.containsKey("content-md5")) {
                interestingHeaders.put("content-md5", "");
            }
            for (String headerKey : interestingHeaders.keySet()) {
                if (headerKey.startsWith(AMAZON_HEADER_PREFIX)) {
                    buf.append(headerKey).append(':').append(interestingHeaders.get(headerKey));
                } else {
                    buf.append(interestingHeaders.get(headerKey));
                }
                buf.append("\n");
            }
            if (bucketName != null && bucketName.length() != 0) {
                buf.append("/" + bucketName);
            }
            buf.append("/");
            if (key != null) {
                buf.append(key);
            }
            if (pathArgs != null) {
                if (pathArgs.containsKey("acl")) {
                    buf.append("?acl");
                } else if (pathArgs.containsKey("torrent")) {
                    buf.append("?torrent");
                } else if (pathArgs.containsKey("logging")) {
                    buf.append("?logging");
                } else if (pathArgs.containsKey("location")) {
                    buf.append("?location");
                }
            }
            return buf.toString();
        }

        static String encode(String awsSecretAccessKey, String canonicalString, boolean urlencode) {
            SecretKeySpec signingKey = new SecretKeySpec(awsSecretAccessKey.getBytes(), HMAC_SHA1_ALGORITHM);
            Mac mac = null;
            try {
                mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Could not find sha1 algorithm", e);
            }
            try {
                mac.init(signingKey);
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException("Could not initialize the MAC algorithm", e);
            }
            String b64 = Base64.encodeBytes(mac.doFinal(canonicalString.getBytes()));
            if (urlencode) {
                return Utils.urlencode(b64);
            }
            return b64;
        }

        static Map paramsForListOptions(String prefix, String marker, Integer maxKeys) {
            return Utils.paramsForListOptions(prefix, marker, maxKeys, null);
        }

        static Map paramsForListOptions(String prefix, String marker, Integer maxKeys, String delimiter) {
            HashMap<String, String> argParams = new HashMap<String, String>();
            if (prefix != null) {
                argParams.put("prefix", Utils.urlencode(prefix));
            }
            if (marker != null) {
                argParams.put("marker", Utils.urlencode(marker));
            }
            if (delimiter != null) {
                argParams.put("delimiter", Utils.urlencode(delimiter));
            }
            if (maxKeys != null) {
                argParams.put("max-keys", Integer.toString(maxKeys));
            }
            return argParams;
        }

        public static String convertPathArgsHashToString(Map pathArgs) {
            StringBuilder pathArgsString = new StringBuilder();
            boolean firstRun = true;
            if (pathArgs != null) {
                for (String argument : pathArgs.keySet()) {
                    if (firstRun) {
                        firstRun = false;
                        pathArgsString.append("?");
                    } else {
                        pathArgsString.append("&");
                    }
                    String argumentValue = (String)pathArgs.get(argument);
                    pathArgsString.append(argument);
                    if (argumentValue == null) continue;
                    pathArgsString.append("=");
                    pathArgsString.append(argumentValue);
                }
            }
            return pathArgsString.toString();
        }

        static String urlencode(String unencoded) {
            try {
                return URLEncoder.encode(unencoded, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Could not url encode to UTF-8", e);
            }
        }

        static XMLReader createXMLReader() {
            try {
                return XMLReaderFactory.createXMLReader();
            }
            catch (SAXException e) {
                System.setProperty("org.xml.sax.driver", "org.apache.crimson.parser.XMLReaderImpl");
                try {
                    return XMLReaderFactory.createXMLReader();
                }
                catch (SAXException e2) {
                    throw new RuntimeException("Couldn't initialize a sax driver for the XMLReader");
                }
            }
        }

        private static String concatenateList(List values) {
            StringBuilder buf = new StringBuilder();
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                buf.append(((String)values.get(i)).replaceAll("\n", "").trim());
                if (i == size - 1) continue;
                buf.append(",");
            }
            return buf.toString();
        }

        static boolean validateBucketName(String bucketName, CallingFormat callingFormat) {
            if (callingFormat == CallingFormat.getPathCallingFormat()) {
                int MIN_BUCKET_LENGTH = 3;
                int MAX_BUCKET_LENGTH = 255;
                String BUCKET_NAME_REGEX = "^[0-9A-Za-z\\.\\-_]*$";
                return null != bucketName && bucketName.length() >= 3 && bucketName.length() <= 255 && bucketName.matches("^[0-9A-Za-z\\.\\-_]*$");
            }
            return Utils.isValidSubdomainBucketName(bucketName);
        }

        static boolean isValidSubdomainBucketName(String bucketName) {
            int MIN_BUCKET_LENGTH = 3;
            int MAX_BUCKET_LENGTH = 63;
            String IPv4_REGEX = "^[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+$";
            String BUCKET_NAME_REGEX = "^[a-z0-9]([a-z0-9\\-\\_]*[a-z0-9])?(\\.[a-z0-9]([a-z0-9\\-\\_]*[a-z0-9])?)*$";
            return null != bucketName && bucketName.length() >= 3 && bucketName.length() <= 63 && !bucketName.matches("^[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+$") && bucketName.matches("^[a-z0-9]([a-z0-9\\-\\_]*[a-z0-9])?(\\.[a-z0-9]([a-z0-9\\-\\_]*[a-z0-9])?)*$");
        }

        static CallingFormat getCallingFormatForBucket(CallingFormat desiredFormat, String bucketName) {
            CallingFormat callingFormat = desiredFormat;
            if (callingFormat == CallingFormat.getSubdomainCallingFormat() && !Utils.isValidSubdomainBucketName(bucketName)) {
                callingFormat = CallingFormat.getPathCallingFormat();
            }
            return callingFormat;
        }
    }

    static abstract class CallingFormat {
        protected static CallingFormat pathCallingFormat = new PathCallingFormat();
        protected static CallingFormat subdomainCallingFormat = new SubdomainCallingFormat();
        protected static CallingFormat vanityCallingFormat = new VanityCallingFormat();

        CallingFormat() {
        }

        public abstract boolean supportsLocatedBuckets();

        public abstract String getEndpoint(String var1, int var2, String var3);

        public abstract String getPathBase(String var1, String var2);

        public abstract URL getURL(boolean var1, String var2, int var3, String var4, String var5, Map var6) throws MalformedURLException;

        public static CallingFormat getPathCallingFormat() {
            return pathCallingFormat;
        }

        public static CallingFormat getSubdomainCallingFormat() {
            return subdomainCallingFormat;
        }

        public static CallingFormat getVanityCallingFormat() {
            return vanityCallingFormat;
        }

        private static class VanityCallingFormat
        extends SubdomainCallingFormat {
            private VanityCallingFormat() {
            }

            @Override
            public String getServer(String server, String bucket) {
                return bucket;
            }
        }

        private static class SubdomainCallingFormat
        extends CallingFormat {
            private SubdomainCallingFormat() {
            }

            @Override
            public boolean supportsLocatedBuckets() {
                return true;
            }

            public String getServer(String server, String bucket) {
                return bucket + "." + server;
            }

            @Override
            public String getEndpoint(String server, int port, String bucket) {
                return this.getServer(server, bucket) + ":" + port;
            }

            @Override
            public String getPathBase(String bucket, String key) {
                return "/" + key;
            }

            @Override
            public URL getURL(boolean isSecure, String server, int port, String bucket, String key, Map pathArgs) throws MalformedURLException {
                if (bucket == null || bucket.length() == 0) {
                    String pathArguments = Utils.convertPathArgsHashToString(pathArgs);
                    return new URL(isSecure ? "https" : "http", server, port, "/" + pathArguments);
                }
                String serverToUse = this.getServer(server, bucket);
                String pathBase = this.getPathBase(bucket, key);
                String pathArguments = Utils.convertPathArgsHashToString(pathArgs);
                return new URL(isSecure ? "https" : "http", serverToUse, port, pathBase + pathArguments);
            }
        }

        private static class PathCallingFormat
        extends CallingFormat {
            private PathCallingFormat() {
            }

            @Override
            public boolean supportsLocatedBuckets() {
                return false;
            }

            @Override
            public String getPathBase(String bucket, String key) {
                return PathCallingFormat.isBucketSpecified(bucket) ? "/" + bucket + "/" + key : "/";
            }

            @Override
            public String getEndpoint(String server, int port, String bucket) {
                return server + ":" + port;
            }

            @Override
            public URL getURL(boolean isSecure, String server, int port, String bucket, String key, Map pathArgs) throws MalformedURLException {
                String pathBase = PathCallingFormat.isBucketSpecified(bucket) ? "/" + bucket + "/" + key : "/";
                String pathArguments = Utils.convertPathArgsHashToString(pathArgs);
                return new URL(isSecure ? "https" : "http", server, port, pathBase + pathArguments);
            }

            private static boolean isBucketSpecified(String bucket) {
                return bucket != null && bucket.length() != 0;
            }
        }
    }

    static class S3Object {
        public byte[] data;
        public Map metadata;

        public S3Object(byte[] data, Map metadata) {
            this.data = data;
            this.metadata = metadata;
        }
    }

    static class ListAllMyBucketsResponse
    extends Response {
        public List entries;

        public ListAllMyBucketsResponse(HttpURLConnection connection) throws IOException {
            super(connection);
            if (connection.getResponseCode() < 400) {
                try {
                    XMLReader xr = Utils.createXMLReader();
                    ListAllMyBucketsHandler handler = new ListAllMyBucketsHandler();
                    xr.setContentHandler(handler);
                    xr.setErrorHandler(handler);
                    xr.parse(new InputSource(connection.getInputStream()));
                    this.entries = handler.getEntries();
                }
                catch (SAXException e) {
                    throw new RuntimeException("Unexpected error parsing ListAllMyBuckets xml", e);
                }
            }
        }

        static class ListAllMyBucketsHandler
        extends DefaultHandler {
            private List entries = new ArrayList();
            private Bucket currBucket = null;
            private StringBuffer currText = null;
            private SimpleDateFormat iso8601Parser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

            public ListAllMyBucketsHandler() {
                this.iso8601Parser.setTimeZone(new SimpleTimeZone(0, "GMT"));
                this.currText = new StringBuffer();
            }

            @Override
            public void startDocument() {
            }

            @Override
            public void endDocument() {
            }

            @Override
            public void startElement(String uri, String name, String qName, Attributes attrs) {
                if (name.equals("Bucket")) {
                    this.currBucket = new Bucket();
                }
            }

            @Override
            public void endElement(String uri, String name, String qName) {
                if (name.equals("Bucket")) {
                    this.entries.add(this.currBucket);
                } else if (name.equals("Name")) {
                    this.currBucket.name = this.currText.toString();
                } else if (name.equals("CreationDate")) {
                    try {
                        this.currBucket.creationDate = this.iso8601Parser.parse(this.currText.toString());
                    }
                    catch (ParseException e) {
                        throw new RuntimeException("Unexpected date format in list bucket output", e);
                    }
                }
                this.currText = new StringBuffer();
            }

            @Override
            public void characters(char[] ch, int start, int length) {
                this.currText.append(ch, start, length);
            }

            public List getEntries() {
                return this.entries;
            }
        }
    }

    static class CommonPrefixEntry {
        public String prefix;

        CommonPrefixEntry() {
        }
    }

    static class ListBucketResponse
    extends Response {
        public String name = null;
        public String prefix = null;
        public String marker = null;
        public String delimiter = null;
        public int maxKeys = 0;
        public boolean isTruncated = false;
        public String nextMarker = null;
        public List entries = null;
        public List commonPrefixEntries = null;

        public ListBucketResponse(HttpURLConnection connection) throws IOException {
            super(connection);
            if (connection.getResponseCode() < 400) {
                try {
                    XMLReader xr = Utils.createXMLReader();
                    ListBucketHandler handler = new ListBucketHandler();
                    xr.setContentHandler(handler);
                    xr.setErrorHandler(handler);
                    xr.parse(new InputSource(connection.getInputStream()));
                    this.name = handler.getName();
                    this.prefix = handler.getPrefix();
                    this.marker = handler.getMarker();
                    this.delimiter = handler.getDelimiter();
                    this.maxKeys = handler.getMaxKeys();
                    this.isTruncated = handler.getIsTruncated();
                    this.nextMarker = handler.getNextMarker();
                    this.entries = handler.getKeyEntries();
                    this.commonPrefixEntries = handler.getCommonPrefixEntries();
                }
                catch (SAXException e) {
                    throw new RuntimeException("Unexpected error parsing ListBucket xml", e);
                }
            }
        }

        static class ListBucketHandler
        extends DefaultHandler {
            private String name = null;
            private String prefix = null;
            private String marker = null;
            private String delimiter = null;
            private int maxKeys = 0;
            private boolean isTruncated = false;
            private String nextMarker = null;
            private boolean isEchoedPrefix = false;
            private List keyEntries = new ArrayList();
            private ListEntry keyEntry = null;
            private List commonPrefixEntries = new ArrayList();
            private CommonPrefixEntry commonPrefixEntry = null;
            private StringBuffer currText = null;
            private SimpleDateFormat iso8601Parser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

            public ListBucketHandler() {
                this.iso8601Parser.setTimeZone(new SimpleTimeZone(0, "GMT"));
                this.currText = new StringBuffer();
            }

            @Override
            public void startDocument() {
                this.isEchoedPrefix = true;
            }

            @Override
            public void endDocument() {
            }

            @Override
            public void startElement(String uri, String name, String qName, Attributes attrs) {
                if (name.equals("Contents")) {
                    this.keyEntry = new ListEntry();
                } else if (name.equals("Owner")) {
                    this.keyEntry.owner = new Owner();
                } else if (name.equals("CommonPrefixes")) {
                    this.commonPrefixEntry = new CommonPrefixEntry();
                }
            }

            @Override
            public void endElement(String uri, String name, String qName) {
                if (name.equals("Name")) {
                    this.name = this.currText.toString();
                } else if (name.equals("Prefix") && this.isEchoedPrefix) {
                    this.prefix = this.currText.toString();
                    this.isEchoedPrefix = false;
                } else if (name.equals("Marker")) {
                    this.marker = this.currText.toString();
                } else if (name.equals("MaxKeys")) {
                    this.maxKeys = Integer.parseInt(this.currText.toString());
                } else if (name.equals("Delimiter")) {
                    this.delimiter = this.currText.toString();
                } else if (name.equals("IsTruncated")) {
                    this.isTruncated = Boolean.valueOf(this.currText.toString());
                } else if (name.equals("NextMarker")) {
                    this.nextMarker = this.currText.toString();
                } else if (name.equals("Contents")) {
                    this.keyEntries.add(this.keyEntry);
                } else if (name.equals("Key")) {
                    this.keyEntry.key = this.currText.toString();
                } else if (name.equals("LastModified")) {
                    try {
                        this.keyEntry.lastModified = this.iso8601Parser.parse(this.currText.toString());
                    }
                    catch (ParseException e) {
                        throw new RuntimeException("Unexpected date format in list bucket output", e);
                    }
                } else if (name.equals("ETag")) {
                    this.keyEntry.eTag = this.currText.toString();
                } else if (name.equals("Size")) {
                    this.keyEntry.size = Long.parseLong(this.currText.toString());
                } else if (name.equals("StorageClass")) {
                    this.keyEntry.storageClass = this.currText.toString();
                } else if (name.equals("ID")) {
                    this.keyEntry.owner.id = this.currText.toString();
                } else if (name.equals("DisplayName")) {
                    this.keyEntry.owner.displayName = this.currText.toString();
                } else if (name.equals("CommonPrefixes")) {
                    this.commonPrefixEntries.add(this.commonPrefixEntry);
                } else if (name.equals("Prefix")) {
                    this.commonPrefixEntry.prefix = this.currText.toString();
                }
                if (this.currText.length() != 0) {
                    this.currText = new StringBuffer();
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) {
                this.currText.append(ch, start, length);
            }

            public String getName() {
                return this.name;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public String getMarker() {
                return this.marker;
            }

            public String getDelimiter() {
                return this.delimiter;
            }

            public int getMaxKeys() {
                return this.maxKeys;
            }

            public boolean getIsTruncated() {
                return this.isTruncated;
            }

            public String getNextMarker() {
                return this.nextMarker;
            }

            public List getKeyEntries() {
                return this.keyEntries;
            }

            public List getCommonPrefixEntries() {
                return this.commonPrefixEntries;
            }
        }
    }

    static class Bucket {
        public String name;
        public Date creationDate;

        public Bucket() {
            this.name = null;
            this.creationDate = null;
        }

        public Bucket(String name, Date creationDate) {
            this.name = name;
            this.creationDate = creationDate;
        }

        public String toString() {
            return this.name;
        }
    }

    static class LocationResponse
    extends Response {
        String location;

        public LocationResponse(HttpURLConnection connection) throws IOException {
            super(connection);
            if (connection.getResponseCode() < 400) {
                try {
                    XMLReader xr = Utils.createXMLReader();
                    LocationResponseHandler handler = new LocationResponseHandler();
                    xr.setContentHandler(handler);
                    xr.setErrorHandler(handler);
                    xr.parse(new InputSource(connection.getInputStream()));
                    this.location = handler.loc;
                }
                catch (SAXException e) {
                    throw new RuntimeException("Unexpected error parsing ListAllMyBuckets xml", e);
                }
            } else {
                this.location = "<error>";
            }
        }

        public String getLocation() {
            return this.location;
        }

        static class LocationResponseHandler
        extends DefaultHandler {
            String loc = null;
            private StringBuffer currText = null;

            LocationResponseHandler() {
            }

            @Override
            public void startDocument() {
            }

            @Override
            public void startElement(String uri, String name, String qName, Attributes attrs) {
                if (name.equals("LocationConstraint")) {
                    this.currText = new StringBuffer();
                }
            }

            @Override
            public void endElement(String uri, String name, String qName) {
                if (name.equals("LocationConstraint")) {
                    this.loc = this.currText.toString();
                    this.currText = null;
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) {
                if (this.currText != null) {
                    this.currText.append(ch, start, length);
                }
            }
        }
    }

    static class GetResponse
    extends Response {
        public S3Object object;

        public GetResponse(HttpURLConnection connection) throws IOException {
            super(connection);
            if (connection.getResponseCode() < 400) {
                Map metadata = GetResponse.extractMetadata(connection);
                byte[] body = GetResponse.slurpInputStream(connection.getInputStream());
                this.object = new S3Object(body, metadata);
            }
        }

        private static Map extractMetadata(HttpURLConnection connection) {
            TreeMap<String, List<String>> metadata = new TreeMap<String, List<String>>();
            Map<String, List<String>> headers = connection.getHeaderFields();
            for (String key : headers.keySet()) {
                if (key == null || !key.startsWith("x-amz-meta-")) continue;
                metadata.put(key.substring("x-amz-meta-".length()), headers.get(key));
            }
            return metadata;
        }

        static byte[] slurpInputStream(InputStream stream) throws IOException {
            int count;
            int chunkSize = 2048;
            byte[] buf = new byte[2048];
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream(2048);
            while ((count = stream.read(buf)) != -1) {
                byteStream.write(buf, 0, count);
            }
            return byteStream.toByteArray();
        }
    }

    static class Response {
        public HttpURLConnection connection;

        public Response(HttpURLConnection connection) throws IOException {
            this.connection = connection;
        }
    }

    static class Owner {
        public String id;
        public String displayName;

        Owner() {
        }
    }

    static class ListEntry {
        public String key;
        public Date lastModified;
        public String eTag;
        public long size;
        public String storageClass;
        public Owner owner;

        ListEntry() {
        }

        public String toString() {
            return this.key;
        }
    }

    static class AWSAuthConnection {
        public static final String LOCATION_DEFAULT = null;
        public static final String LOCATION_EU = "EU";
        private String awsAccessKeyId;
        private String awsSecretAccessKey;
        private boolean isSecure;
        private String server;
        private int port;
        private CallingFormat callingFormat;

        public AWSAuthConnection(String awsAccessKeyId, String awsSecretAccessKey) {
            this(awsAccessKeyId, awsSecretAccessKey, true);
        }

        public AWSAuthConnection(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure) {
            this(awsAccessKeyId, awsSecretAccessKey, isSecure, "s3.amazonaws.com");
        }

        public AWSAuthConnection(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server) {
            this(awsAccessKeyId, awsSecretAccessKey, isSecure, server, isSecure ? 443 : 80);
        }

        public AWSAuthConnection(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server, int port) {
            this(awsAccessKeyId, awsSecretAccessKey, isSecure, server, port, CallingFormat.getSubdomainCallingFormat());
        }

        public AWSAuthConnection(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server, CallingFormat format) {
            this(awsAccessKeyId, awsSecretAccessKey, isSecure, server, isSecure ? 443 : 80, format);
        }

        public AWSAuthConnection(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server, int port, CallingFormat format) {
            this.awsAccessKeyId = awsAccessKeyId;
            this.awsSecretAccessKey = awsSecretAccessKey;
            this.isSecure = isSecure;
            this.server = server;
            this.port = port;
            this.callingFormat = format;
        }

        public Response createBucket(String bucket, Map headers) throws IOException {
            return this.createBucket(bucket, null, headers);
        }

        public Response createBucket(String bucket, String location, Map headers) throws IOException {
            String body;
            if (location == null) {
                body = null;
            } else if (LOCATION_EU.equals(location)) {
                if (!this.callingFormat.supportsLocatedBuckets()) {
                    throw new IllegalArgumentException("Creating location-constrained bucket with unsupported calling-format");
                }
                body = "<CreateBucketConstraint><LocationConstraint>" + location + "</LocationConstraint></CreateBucketConstraint>";
            } else {
                throw new IllegalArgumentException("Invalid Location: " + location);
            }
            if (!Utils.validateBucketName(bucket, this.callingFormat)) {
                throw new IllegalArgumentException("Invalid Bucket Name: " + bucket);
            }
            HttpURLConnection request = this.makeRequest("PUT", bucket, "", null, headers);
            if (body != null) {
                request.setDoOutput(true);
                request.getOutputStream().write(body.getBytes("UTF-8"));
            }
            return new Response(request);
        }

        public boolean checkBucketExists(String bucket) throws IOException {
            HttpURLConnection response = this.makeRequest("HEAD", bucket, "", null, null);
            int httpCode = response.getResponseCode();
            if (httpCode >= 200 && httpCode < 300) {
                return true;
            }
            if (httpCode == 404) {
                return false;
            }
            throw new IOException("bucket '" + bucket + "' could not be accessed (rsp=" + httpCode + " (" + response.getResponseMessage() + "). Maybe the bucket is owned by somebody else or " + "the authentication failed");
        }

        public ListBucketResponse listBucket(String bucket, String prefix, String marker, Integer maxKeys, Map headers) throws IOException {
            return this.listBucket(bucket, prefix, marker, maxKeys, null, headers);
        }

        public ListBucketResponse listBucket(String bucket, String prefix, String marker, Integer maxKeys, String delimiter, Map headers) throws IOException {
            Map pathArgs = Utils.paramsForListOptions(prefix, marker, maxKeys, delimiter);
            return new ListBucketResponse(this.makeRequest("GET", bucket, "", pathArgs, headers));
        }

        public Response deleteBucket(String bucket, Map headers) throws IOException {
            return new Response(this.makeRequest("DELETE", bucket, "", null, headers));
        }

        public Response put(String bucket, String key, S3Object object, Map headers) throws IOException {
            HttpURLConnection request = this.makeRequest("PUT", bucket, Utils.urlencode(key), null, headers, object);
            request.setDoOutput(true);
            request.getOutputStream().write(object.data == null ? new byte[]{} : object.data);
            return new Response(request);
        }

        public Response copy(String sourceBucket, String sourceKey, String destinationBucket, String destinationKey, Map headers) throws IOException {
            S3Object object = new S3Object(new byte[0], new HashMap());
            headers = headers == null ? new HashMap<String, List<String>>() : new HashMap(headers);
            headers.put("x-amz-copy-source", Arrays.asList(sourceBucket + "/" + sourceKey));
            headers.put("x-amz-metadata-directive", Arrays.asList("COPY"));
            return AWSAuthConnection.verifyCopy(this.put(destinationBucket, destinationKey, object, headers));
        }

        public Response copy(String sourceBucket, String sourceKey, String destinationBucket, String destinationKey, Map metadata, Map headers) throws IOException {
            S3Object object = new S3Object(new byte[0], metadata);
            headers = headers == null ? new HashMap<String, List<String>>() : new HashMap(headers);
            headers.put("x-amz-copy-source", Arrays.asList(sourceBucket + "/" + sourceKey));
            headers.put("x-amz-metadata-directive", Arrays.asList("REPLACE"));
            return AWSAuthConnection.verifyCopy(this.put(destinationBucket, destinationKey, object, headers));
        }

        private static Response verifyCopy(Response response) throws IOException {
            if (response.connection.getResponseCode() < 400) {
                byte[] body = GetResponse.slurpInputStream(response.connection.getInputStream());
                String message = new String(body);
                if (message.contains("<Error")) {
                    throw new IOException(message.substring(message.indexOf("<Error")));
                }
                if (!message.contains("</CopyObjectResult>")) {
                    throw new IOException("Unexpected response: " + message);
                }
            }
            return response;
        }

        public GetResponse get(String bucket, String key, Map headers) throws IOException {
            return new GetResponse(this.makeRequest("GET", bucket, Utils.urlencode(key), null, headers));
        }

        public Response delete(String bucket, String key, Map headers) throws IOException {
            return new Response(this.makeRequest("DELETE", bucket, Utils.urlencode(key), null, headers));
        }

        public GetResponse getBucketRequestPayment(String bucket, Map headers) throws IOException {
            HashMap<String, Object> pathArgs = new HashMap<String, Object>();
            pathArgs.put("requestPayment", null);
            return new GetResponse(this.makeRequest("GET", bucket, "", pathArgs, headers));
        }

        public Response putBucketRequestPayment(String bucket, String requestPaymentXMLDoc, Map headers) throws IOException {
            HashMap<String, Object> pathArgs = new HashMap<String, Object>();
            pathArgs.put("requestPayment", null);
            S3Object object = new S3Object(requestPaymentXMLDoc.getBytes(), null);
            HttpURLConnection request = this.makeRequest("PUT", bucket, "", pathArgs, headers, object);
            request.setDoOutput(true);
            request.getOutputStream().write(object.data == null ? new byte[]{} : object.data);
            return new Response(request);
        }

        public GetResponse getBucketLogging(String bucket, Map headers) throws IOException {
            HashMap<String, Object> pathArgs = new HashMap<String, Object>();
            pathArgs.put("logging", null);
            return new GetResponse(this.makeRequest("GET", bucket, "", pathArgs, headers));
        }

        public Response putBucketLogging(String bucket, String loggingXMLDoc, Map headers) throws IOException {
            HashMap<String, Object> pathArgs = new HashMap<String, Object>();
            pathArgs.put("logging", null);
            S3Object object = new S3Object(loggingXMLDoc.getBytes(), null);
            HttpURLConnection request = this.makeRequest("PUT", bucket, "", pathArgs, headers, object);
            request.setDoOutput(true);
            request.getOutputStream().write(object.data == null ? new byte[]{} : object.data);
            return new Response(request);
        }

        public GetResponse getBucketACL(String bucket, Map headers) throws IOException {
            return this.getACL(bucket, "", headers);
        }

        public GetResponse getACL(String bucket, String key, Map headers) throws IOException {
            if (key == null) {
                key = "";
            }
            HashMap<String, Object> pathArgs = new HashMap<String, Object>();
            pathArgs.put("acl", null);
            return new GetResponse(this.makeRequest("GET", bucket, Utils.urlencode(key), pathArgs, headers));
        }

        public Response putBucketACL(String bucket, String aclXMLDoc, Map headers) throws IOException {
            return this.putACL(bucket, "", aclXMLDoc, headers);
        }

        public Response putACL(String bucket, String key, String aclXMLDoc, Map headers) throws IOException {
            S3Object object = new S3Object(aclXMLDoc.getBytes(), null);
            HashMap<String, Object> pathArgs = new HashMap<String, Object>();
            pathArgs.put("acl", null);
            HttpURLConnection request = this.makeRequest("PUT", bucket, Utils.urlencode(key), pathArgs, headers, object);
            request.setDoOutput(true);
            request.getOutputStream().write(object.data == null ? new byte[]{} : object.data);
            return new Response(request);
        }

        public LocationResponse getBucketLocation(String bucket) throws IOException {
            HashMap<String, Object> pathArgs = new HashMap<String, Object>();
            pathArgs.put("location", null);
            return new LocationResponse(this.makeRequest("GET", bucket, "", pathArgs, null));
        }

        public ListAllMyBucketsResponse listAllMyBuckets(Map headers) throws IOException {
            return new ListAllMyBucketsResponse(this.makeRequest("GET", "", "", null, headers));
        }

        private HttpURLConnection makeRequest(String method, String bucketName, String key, Map pathArgs, Map headers) throws IOException {
            return this.makeRequest(method, bucketName, key, pathArgs, headers, null);
        }

        private HttpURLConnection makeRequest(String method, String bucket, String key, Map pathArgs, Map headers, S3Object object) throws IOException {
            CallingFormat format = Utils.getCallingFormatForBucket(this.callingFormat, bucket);
            if (this.isSecure && format != CallingFormat.getPathCallingFormat() && bucket.contains(".")) {
                System.err.println("You are making an SSL connection, however, the bucket contains periods and the wildcard certificate will not match by default.  Please consider using HTTP.");
            }
            URL url = format.getURL(this.isSecure, this.server, this.port, bucket, key, pathArgs);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(method);
            if (!connection.getInstanceFollowRedirects() && format.supportsLocatedBuckets()) {
                throw new RuntimeException("HTTP redirect support required.");
            }
            AWSAuthConnection.addHeaders(connection, headers);
            if (object != null) {
                AWSAuthConnection.addMetadataHeaders(connection, object.metadata);
            }
            this.addAuthHeader(connection, method, bucket, key, pathArgs);
            return connection;
        }

        private static void addHeaders(HttpURLConnection connection, Map headers) {
            AWSAuthConnection.addHeaders(connection, headers, "");
        }

        private static void addMetadataHeaders(HttpURLConnection connection, Map metadata) {
            AWSAuthConnection.addHeaders(connection, metadata, "x-amz-meta-");
        }

        private static void addHeaders(HttpURLConnection connection, Map headers, String prefix) {
            if (headers != null) {
                for (String key : headers.keySet()) {
                    for (String value : (List)headers.get(key)) {
                        connection.addRequestProperty(prefix + key, value);
                    }
                }
            }
        }

        private void addAuthHeader(HttpURLConnection connection, String method, String bucket, String key, Map pathArgs) {
            if (connection.getRequestProperty("Date") == null) {
                connection.setRequestProperty("Date", AWSAuthConnection.httpDate());
            }
            if (connection.getRequestProperty("Content-Type") == null) {
                connection.setRequestProperty("Content-Type", "");
            }
            String canonicalString = Utils.makeCanonicalString(method, bucket, key, pathArgs, connection.getRequestProperties());
            String encodedCanonical = Utils.encode(this.awsSecretAccessKey, canonicalString, false);
            connection.setRequestProperty("Authorization", "AWS " + this.awsAccessKeyId + ":" + encodedCanonical);
        }

        public static String httpDate() {
            String DateFormat2 = "EEE, dd MMM yyyy HH:mm:ss ";
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss ", Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            return format.format(new Date()) + "GMT";
        }
    }
}

