/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config.parsing.element;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.CustomInterceptorConfig;
import org.jboss.cache.config.parsing.XmlConfigHelper;
import org.jboss.cache.config.parsing.XmlParserBase;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.util.Util;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomInterceptorsElementParser
extends XmlParserBase {
    public CustomInterceptorsElementParser() {
        this("urn:jboss:jbosscache-core:config:3.2");
    }

    public CustomInterceptorsElementParser(String coreNamespace) {
        this.coreNamespace = coreNamespace;
    }

    public List<CustomInterceptorConfig> parseCustomInterceptors(Element element) {
        NodeList interceptorNodes = element.getElementsByTagName("interceptor");
        ArrayList<CustomInterceptorConfig> interceptorConfigs = new ArrayList<CustomInterceptorConfig>(interceptorNodes.getLength());
        for (int i = 0; i < interceptorNodes.getLength(); ++i) {
            String indexStr;
            boolean first = false;
            boolean last = false;
            int index = -1;
            String after = null;
            String before = null;
            Element interceptorElement = (Element)interceptorNodes.item(i);
            String position = this.getAttributeValue(interceptorElement, "position");
            if (this.existsAttribute(position) && "first".equalsIgnoreCase(position)) {
                first = true;
            }
            if (this.existsAttribute(position) && "last".equalsIgnoreCase(position)) {
                last = true;
            }
            index = this.existsAttribute(indexStr = this.getAttributeValue(interceptorElement, "index")) ? this.getInt(indexStr) : -1;
            before = this.getAttributeValue(interceptorElement, "before");
            if (!this.existsAttribute(before)) {
                before = null;
            }
            if (!this.existsAttribute(after = this.getAttributeValue(interceptorElement, "after"))) {
                after = null;
            }
            CommandInterceptor interceptor = this.buildCommandInterceptor(interceptorElement);
            CustomInterceptorConfig customInterceptorConfig = new CustomInterceptorConfig(interceptor, first, last, index, after, before);
            interceptorConfigs.add(customInterceptorConfig);
        }
        return interceptorConfigs;
    }

    private CommandInterceptor buildCommandInterceptor(Element element) {
        CommandInterceptor result;
        String interceptorClass = this.getAttributeValue(element, "class");
        if (!this.existsAttribute(interceptorClass)) {
            throw new ConfigurationException("Interceptor class cannot be empty!");
        }
        try {
            result = (CommandInterceptor)Util.loadClass(interceptorClass).newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException("CommandInterceptor class is not properly loaded in classloader", e);
        }
        Properties p = XmlConfigHelper.extractProperties(element);
        XmlConfigHelper.setValues(result, p, false, true);
        return result;
    }
}

