/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.servlet;

import com.google.caja.ancillary.servlet.CajaWebToolsServlet;
import com.google.caja.ancillary.servlet.Result;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.util.Assertion;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.caja.util.Pair;
import com.google.caja.util.Sets;
import com.google.caja.util.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.w3c.dom.Element;

public class CajaWebToolsServletTest
extends CajaTestCase {
    CajaWebToolsServlet servlet;
    private Set<ServletTest> tests = Sets.newIdentityHashSet();
    private static final String HTML_NS = "http://www.w3.org/1999/xhtml";

    public void setUp() throws Exception {
        super.setUp();
        this.servlet = new CajaWebToolsServlet("cid");
    }

    public void tearDown() throws Exception {
        CajaWebToolsServletTest.assertTrue((String)"Maybe send was never called", (boolean)this.tests.isEmpty());
        super.tearDown();
    }

    public final void testBadPath() {
        new ServletTest().get("/bogus").expectStatus(404).expectContentType("text/html; charset=UTF-8").expectContentMatches("File not found /bogus.  Expected a path in \\[.*\\]").send();
        this.assertNoErrors();
    }

    public final void testIndex() {
        new ServletTest().get("/index").expectStatus(200).expectContentType("text/html; charset=UTF-8").expectContentMatches("<form\\b[^>]*>").expectContentMatches("<textarea[^>]*>&lt;script&gt;&lt;/script&gt;</textarea>").send();
        this.assertNoErrors();
    }

    public final void testIndexWithPresuppliedInput() {
        new ServletTest().get("/index").param("i", "<p>Hello, World!</p>").expectStatus(200).expectContentType("text/html; charset=UTF-8").expectContentMatches("<form\\b[^>]*>").expectContentMatches("<textarea[^>]*>&lt;p&gt;Hello, World!&lt;/p&gt;</textarea>").send();
        this.assertNoErrors();
    }

    public final void testIndexWithBadParam() {
        new ServletTest().get("/index").param("bogus", "foo").expectStatus(400).expectContentType("text/html; charset=UTF-8").expectContentMatches("Unrecognized param bogus").send();
        this.assertNoErrors();
    }

    public final void testEcho() {
        new ServletTest().get("/echo").param("it", "text/javascript").param("i", "t = Date.now ? Date.now() : (new Date).getTime()").param("ot", "JS").param("minify", "no").expectStatus(200).expectContentType("text/javascript; charset=UTF-8").expectContent("t = Date.now? Date.now(): (new Date).getTime();").send();
        this.assertNoErrors();
    }

    public final void testMinify() {
        new ServletTest().get("/echo").param("it", "text/javascript").param("i", "t = Date.now ? Date.now() : (new Date).getTime()").param("ot", "JS").expectStatus(200).expectContentType("text/javascript; charset=UTF-8").expectContent("t=Date.now?Date.now():(new Date).getTime()").send();
        this.assertNoErrors();
    }

    public final void testMinifiedWithUA1() {
        new ServletTest().get("/echo").param("it", "text/javascript").param("i", "t = Date.now ? Date.now() : +(new Date)").param("ot", "JS").param("userAgent", "Firefox").expectStatus(200).expectContentType("text/javascript; charset=UTF-8").expectContent("t=Date.now()").send();
        new ServletTest().get("/echo").param("it", "text/javascript").param("i", "t = Date.now ? Date.now() : +(new Date)").param("ot", "JS").param("userAgent", "MSIE").expectStatus(200).expectContentType("text/javascript; charset=UTF-8").expectContent("t=+new Date").send();
        this.assertNoErrors();
    }

    public final void testMinifiedWithUA2() {
        new ServletTest().get("/echo").param("it", "text/javascript").param("i", "if (window.addEventListener) {\n  window.addEventListener(foo);\n} else if (window.attachEvent) {\n  window.attachEvent(foo);\n}").param("ot", "JS").param("userAgent", "Firefox").expectStatus(200).expectContentType("text/javascript; charset=UTF-8").expectContent("addEventListener(foo)").send();
        this.assertNoErrors();
    }

    public final void testMinifiedWithUA3() {
        new ServletTest().get("/echo").param("it", "text/javascript").param("i", "if (window.addEventListener) {\n  window.addEventListener(foo);\n} else if (window.attachEvent) {\n  window.attachEvent(foo);\n}").param("ot", "JS").param("userAgent", "MSIE").expectStatus(200).expectContentType("text/javascript; charset=UTF-8").expectContent("attachEvent(foo)").send();
        this.assertNoErrors();
    }

    public final void testMinifyHtml() {
        new ServletTest().get("/echo").param("it", "text/html").param("i", "<script type=text/javascript>\nalert('Hello, World!')\n</script>\n<ul>\n  <li onclick='if (foo()) return bar(); return false'>One</li>\n  <li><a href=javascript:baz()>Two</a></li>\n  <li>Three</li>\n</ul>").param("ot", "HTML").param("minify", "t").param("opt", "t").param("userAgent", "*").expectStatus(200).expectContentType("text/html; charset=UTF-8").expectContent("<script>alert('Hello, World!')</script>\n<ul><li onclick=\"return foo()?bar():false\">One<li><a href=\"javascript:baz%28%29\">Two</a><li>Three</ul>").send();
        this.assertNoErrors();
    }

    public final void testMinifyCss1() {
        new ServletTest().get("/echo").param("it", "text/css").param("i", "p { color: red;    background-color: magenta;    outline-color: #ff0000;    border-top-color: blue; }").param("ot", "CSS").param("minify", "t").param("opt", "t").param("userAgent", "*").expectStatus(200).expectContentType("text/css; charset=UTF-8").expectContent("p{color:red;background:#f0f;outline:#f00;border-top:blue}").send();
        this.assertNoErrors();
    }

    public final void testMinifyCss2() {
        new ServletTest().get("/echo").param("it", "text/css").param("i", "p { background-color: darkblue; background-image: url(foo.gif); }").param("ot", "CSS").param("minify", "t").param("opt", "t").param("userAgent", "*").expectStatus(200).expectContentType("text/css; charset=UTF-8").expectContent("p{background-color:#00008b;background-image:url('foo.gif')}").send();
        this.assertNoErrors();
    }

    public final void testMinifyCss3() {
        new ServletTest().get("/echo").param("it", "text/css").param("i", "p { background-image: purple; }q { background-color: purple; }s { background-image: 'foo.gif'; }").param("ot", "CSS").param("minify", "t").param("opt", "t").param("userAgent", "*").expectStatus(200).expectContentType("text/css; charset=UTF-8").expectContent("p{background-image:purple}q{background:purple}s{background:'foo.gif'}").send();
        this.assertNoErrors();
    }

    public final void testRenamed() {
        new ServletTest().get("/echo").param("it", "text/javascript").param("i", "function hypotenuse(xCoord, yCoord) { return Math.sqrt(xCoord * xCoord + yCoord * yCoord);}").param("ot", "JS").expectStatus(200).expectContentType("text/javascript; charset=UTF-8").expectContent("function hypotenuse(a,b){return Math.sqrt(a*a+b*b)}").send();
        this.assertNoErrors();
    }

    public final void testAsciiOnly() {
        new ServletTest().get("/echo").param("it", "text/javascript").param("i", "alert('\u1234')").param("ot", "JS").param("asciiOnly", "t").expectStatus(200).expectContentType("text/javascript; charset=UTF-8").expectContent("alert('\\u1234')").send();
        this.assertNoErrors();
    }

    public final void testHtmlInputs() {
        new ServletTest().get("/echo").param("i", "<script>function hi(msg) { alert(msg); }</script>").expectStatus(200).expectContentType("text/html; charset=UTF-8").expectHeader("Content-disposition", "attachment; filename=\"caja_tools_output.html\"").expectContent("<script>function hi(a){alert(a)}</script>").send();
        this.assertNoErrors();
    }

    public final void testLint() {
        new ServletTest().get("/lint").param("i", "/**\n * @requires alert\n * @provides foo\n */\nvar foo = (function () {\n  var x, y = 1, z;\n  z = 2;\n  return x + y + z;\n})();").expectStatus(200).expectContentType("text/html; charset=UTF-8").expectContentMatches("<h4 title=\"SYMBOL_NOT_LIVE\">[^<.]+\\.js:8\\+10 - 11: Symbol x may be used before being initialized</h4>").expectContentMatches("return <span class=\"problem\">x</span> \\+ y \\+ z;").expectContentMatches("<h4 title=\"UNUSED_REQUIRE\">[^<.]+\\.js: @requires alert not used</h4>").send();
        this.assertNoErrors();
    }

    public final void testLintIgnoresCajaWhitelist() {
        new ServletTest().get("/lint").param("it", "text/css").param("i", "p { position: fixed }\nq { position: relative }\ns { position: bogus }").expectStatus(200).expectContentType("text/html; charset=UTF-8").expectContentMatches("<h2 class=\"summary\">1 Warning </h2>").expectContentMatches("<span class=\"problem\">bogus</span>").send();
        this.assertNoErrors();
    }

    public final void testHtmlLint() {
        new ServletTest().get("/lint").param("i", "<select value=foo><option></option></select>").expectStatus(200).expectContentType("text/html; charset=UTF-8").expectContentMatches("<h4 title=\"UNKNOWN_ATTRIB\">[^<.]+\\.html:1\\+9 - 14: Unknown attribute value on &lt;select&gt;</h4>").expectContentMatches("&lt;select <span class=\"problem\">value</span>=foo&gt;").send();
        this.assertNoErrors();
    }

    public final void testHtmlDocEcho() {
        new ServletTest().get("/echo").param("i", "<html><head><title>Hello</title></hed><body>World!</body>").param("minLevel", "LOG").expectStatus(200).expectContentType("text/html; charset=UTF-8").expectHeader("Content-disposition", "attachment; filename=\"caja_tools_output.html\"").expectContent("<title>Hello</title>World!").send();
        this.assertNoErrors();
    }

    public final void testDoc() {
        new ServletTest().get("/doc").param("ip", "frobbit.js").param("i", "/** Frobbits nobbits */function frobbit(nobbit) {}").param("ot", "JSON").expectStatus(200).expectContentType("application/json; charset=UTF-8").expectContentMatches(" \"frobbit\": \\{\\s*\"@description\": \"Frobbits nobbits \",").send();
    }

    public final void testDocJar() {
        new ServletTest().get("/doc").param("ip", "foo.js").param("i", "/**@fileoverview foo*/ /**Foo*/var foo = {};").param("ip", "bar.js").param("i", "/**@fileoverview bar*/ /**Bar*/var bar = {};").expectStatus(200).expectContentType("application/zip").expectZip().zipFileExists("/jsdoc/").zipFileExists("/jsdoc/jsdoc.json").zipFileExists("/jsdoc/index.html").zipFileExists("/jsdoc/src-bar.js.html").zipFileExists("/jsdoc/src-foo.js.html").zipFileExists("/jsdoc/file-bar.js.html").zipFileExists("/jsdoc/file-foo.js.html").send();
    }

    public final void testHelp() {
        new ServletTest().get("/help").expectStatus(200).expectContentType("text/html; charset=UTF-8").expectContentMatches("<a href=\"index\">index</a>").expectContentMatches("<tr><th>&amp;i=\u2026</th><td>an input source file</td></tr>").send();
    }

    public final void testLintPageTips() {
        new ServletTest().get("/lint").param("it", "text/javascript").param("i", "avast('foo')").expectStatus(200).expectContentType("text/html; charset=UTF-8").expectContentMatches("<a class=\"help\" href=\"files-cid/UNDEFINED_SYMBOL_tip.html\" target=\"help\">").send();
    }

    public final void testExample1() throws Exception {
        new ServletTest().get("/lint").param("it", "text/html").param("i", this.exampleCode("Whacky HTML")).param("opt", "true").param("minify", "true").expectStatus(200).expectContentType("text/html; charset=UTF-8").expectContentMatches(":3\\+18 - 23: End tag &#39;h2&#39; seen but there were unclosed elements").expectContentMatches("&lt;h1&gt;Hello, World!<span class=\"problem\">&lt;/h2&gt;</span>").expectContentMatches(":2\\+15 - 25: Symbol HelloWorld has not been defined").expectContentMatches("&lt;script&gt;alert\\(<span class=\"problem\">HelloWorld</span>\\)").expectContentMatches("\\Q<h2 class=\"summary\">1 Error, 1 Lint (124B \u2192 86B; output is 69.4% of the original)</h2>\\E").expectContentMatches("\\Q&lt;style&gt;p{color:#f0f}&lt;/style&gt;\n&lt;script&gt;alert(HelloWorld)&lt;/script&gt;\n&lt;h1&gt;Hello, World!&lt;/h1&gt;\\E").send();
    }

    public final void testExample2() throws Exception {
        new ServletTest().get("/lint").param("it", "text/css").param("i", this.exampleCode("Whacky CSS")).param("opt", "true").param("minify", "true").expectStatus(200).expectContentType("text/html; charset=UTF-8").expectContentMatches(":1\\+12 - 22: unknown tag blockquite").expectContentMatches("3\\+3 - 9: unknown css property colour").expectContentMatches("\\Q<h2 class=\"summary\">2 Errors (70B \u2192 48B; output is 68.6% of the original)</h2>\\E").expectContentMatches("\\Qh1,p.bar,blockquite{background:#f0f;colour:blue}\\E").send();
    }

    public final void testExample3() throws Exception {
        new ServletTest().get("/echo").param("it", "text/javascript").param("i", this.exampleCode("More Optimization")).param("opt", "true").param("minify", "true").param("userAgent", "MSIE").expectStatus(200).expectContentType("text/javascript; charset=UTF-8").expectContent("var registerEventListener=function(a,b,c){a.attachEvent(b,c)}").send();
    }

    public final void testIndexPageLinks() throws IOException {
        Result result = new ServletTest().get("/index").expectStatus(200).send();
        Matcher m = Pattern.compile("\"files[-\\w]*/([^\"]*)\"").matcher(result.content.getText());
        int nLinks = 0;
        while (m.find()) {
            String relUrl = "files/" + Nodes.decode(m.group(1));
            CajaWebToolsServletTest.assertTrue((String)relUrl, (boolean)this.servlet.staticFiles.exists(relUrl));
            ++nLinks;
        }
        CajaWebToolsServletTest.assertTrue((nLinks != 0 ? 1 : 0) != 0);
    }

    private String exampleCode(String exampleTitle) throws Exception {
        Element root = this.html(this.fromResource("index.quasi.html"));
        for (Element example : Nodes.nodeListIterable(root.getElementsByTagNameNS(HTML_NS, "li"), Element.class)) {
            for (Element link : Nodes.nodeListIterable(example.getElementsByTagNameNS(HTML_NS, "a"), Element.class)) {
                String uri;
                if (!exampleTitle.equals(link.getFirstChild().getNodeValue()) || !Strings.toLowerCase(uri = link.getAttributeNS(HTML_NS, "href")).startsWith("javascript:")) continue;
                String js = URLDecoder.decode(uri.substring("javascript:".length()), "UTF-8");
                return CajaWebToolsServletTest.findSource(this.js(this.fromString(js)));
            }
        }
        return null;
    }

    private static final String findSource(ParseTreeNode js) {
        ParseTreeNode s;
        Map<String, ParseTreeNode> bindings = Maps.newHashMap();
        if (QuasiBuilder.match("(replaceSource(@s, @t))", js, bindings) && (s = bindings.get("s")) instanceof StringLiteral) {
            return ((StringLiteral)s).getUnquotedValue();
        }
        for (ParseTreeNode parseTreeNode : js.children()) {
            String src = CajaWebToolsServletTest.findSource(parseTreeNode);
            if (src == null) continue;
            return src;
        }
        return null;
    }

    private class ServletTest {
        private final List<Assertion> reqs = Lists.newArrayList();
        private String path;
        private List<Pair<String, String>> params = Lists.newArrayList();
        private Result result;
        private Set<String> zipFileContent;

        ServletTest() {
            CajaWebToolsServletTest.this.tests.add(this);
        }

        ServletTest get(String path) {
            Assert.assertNull((Object)this.path);
            Assert.assertNotNull((Object)path);
            this.path = path;
            return this;
        }

        ServletTest param(String key, String value) {
            Assert.assertNotNull((Object)key);
            Assert.assertNotNull((Object)value);
            this.params.add(Pair.pair(key, value));
            return this;
        }

        ServletTest expectStatus(final int status) {
            this.reqs.add(new Assertion(){

                public void test() throws AssertionFailedError {
                    if (status != ((ServletTest)ServletTest.this).result.status) {
                        try {
                            ((ServletTest)ServletTest.this).result.content.toOutputStream(System.err);
                            System.err.println();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                    Assert.assertEquals((int)status, (int)((ServletTest)ServletTest.this).result.status);
                }
            });
            return this;
        }

        ServletTest expectContentType(final String contentType) {
            this.reqs.add(new Assertion(){

                public void test() throws AssertionFailedError {
                    Assert.assertEquals((String)contentType, (String)ServletTest.this.result.getContentType());
                }
            });
            return this;
        }

        ServletTest expectHeader(final String name, final String value) {
            this.reqs.add(new Assertion(){

                public void test() throws AssertionFailedError {
                    for (Pair<String, String> header : ((ServletTest)ServletTest.this).result.headers) {
                        if (!name.equals(header.a) || !value.equals(header.b)) continue;
                        return;
                    }
                    Assert.fail((String)("Missing header " + name + ":" + value + " not in " + ((ServletTest)ServletTest.this).result.headers));
                }
            });
            return this;
        }

        ServletTest expectContentMatches(String re) {
            return this.expectContentMatches(Pattern.compile(re));
        }

        ServletTest expectContentMatches(final Pattern p) {
            this.reqs.add(new Assertion(){

                public void test() throws AssertionFailedError {
                    try {
                        String text = ((ServletTest)ServletTest.this).result.content.getText();
                        Assert.assertTrue((String)("Does not match " + p.pattern() + "\n" + text), (boolean)p.matcher(text).find());
                    }
                    catch (IOException ex) {
                        Assert.fail((String)ex.toString());
                    }
                }
            });
            return this;
        }

        ServletTest expectContent(final String expected) {
            this.reqs.add(new Assertion(){

                public void test() throws AssertionFailedError {
                    try {
                        Assert.assertEquals((String)expected, (String)((ServletTest)ServletTest.this).result.content.getText());
                    }
                    catch (IOException ex) {
                        Assert.fail((String)ex.toString());
                    }
                }
            });
            return this;
        }

        private void checkZipFile() throws IOException {
            if (this.zipFileContent == null) {
                ZipEntry ze;
                Set<String> files = Sets.newLinkedHashSet();
                ByteArrayOutputStream bout = new ByteArrayOutputStream((int)this.result.content.byteLength());
                this.result.content.toOutputStream(bout);
                byte[] zipB = bout.toByteArray();
                ZipInputStream zin = new ZipInputStream(new ByteArrayInputStream(zipB));
                while ((ze = zin.getNextEntry()) != null) {
                    files.add(ze.getName());
                }
                this.zipFileContent = files;
            }
        }

        ServletTest expectZip() {
            this.reqs.add(new Assertion(){

                public void test() throws AssertionFailedError {
                    try {
                        ServletTest.this.checkZipFile();
                    }
                    catch (IOException ex) {
                        Assert.fail((String)ex.toString());
                    }
                }
            });
            return this;
        }

        ServletTest zipFileExists(final String path) {
            this.reqs.add(new Assertion(){

                public void test() throws AssertionFailedError {
                    try {
                        ServletTest.this.checkZipFile();
                    }
                    catch (IOException ex) {
                        Assert.fail((String)ex.toString());
                    }
                    Assert.assertTrue((String)(path + " not in " + ServletTest.this.zipFileContent.toString()), (boolean)ServletTest.this.zipFileContent.contains(path));
                }
            });
            return this;
        }

        Result send() {
            Assert.assertTrue((boolean)CajaWebToolsServletTest.this.tests.remove(this));
            this.result = CajaWebToolsServletTest.this.servlet.handle(this.path, this.params);
            CajaWebToolsServletTest.this.mq.getMessages().addAll(this.result.mq.getMessages());
            Assert.assertFalse((String)"no assertions", (boolean)this.reqs.isEmpty());
            for (Assertion a : this.reqs) {
                a.test();
            }
            return this.result;
        }
    }
}

