/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.xcmis.search.lucene.index.FieldNames;
import org.xcmis.search.lucene.search.UUIDFieldSelector;
import org.xcmis.spi.utils.Logger;

public class DescendantQueryNode
extends Query {
    private static final long serialVersionUID = -6151493594236655389L;
    private static final Logger log = Logger.getLogger(DescendantQueryNode.class);
    private final Query context;
    private final Query parentQuery;

    public DescendantQueryNode(Query context, Query parentQuery) {
        this.context = context;
        this.parentQuery = parentQuery;
    }

    public void extractTerms(Set terms) {
        this.context.extractTerms(terms);
        this.parentQuery.extractTerms(terms);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query cQuery = null;
        if (this.context != null) {
            cQuery = this.context.rewrite(reader);
        }
        Query pQuery = this.parentQuery.rewrite(reader);
        if (cQuery == this.context && pQuery == this.parentQuery) {
            return this;
        }
        return new DescendantQueryNode(cQuery, pQuery);
    }

    public String toString() {
        return "(DescendantQueryNode Parent:" + this.parentQuery + " query:" + this.context + ")";
    }

    public String toString(String field) {
        return "(DescendantQueryNode Parent:" + this.parentQuery + " query:" + this.context + ")";
    }

    protected Weight createWeight(Searcher searcher) throws IOException {
        return new DescendantQueryNodeWeight(searcher);
    }

    private Query getConetextQuery() {
        return this.context;
    }

    private class DescendantQueryNodeWeight
    implements Weight {
        private final Searcher searcher;

        public DescendantQueryNodeWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }

        public Query getQuery() {
            return DescendantQueryNode.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            Scorer parentScorer = DescendantQueryNode.this.parentQuery.weight(this.searcher).scorer(reader);
            return new DescendantQueryNodeScorer(this.searcher, parentScorer, reader);
        }

        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }
    }

    private class DescendantQueryNodeScorer
    extends Scorer {
        private final IndexReader reader;
        private final Searcher searcher;
        private Scorer currentContextScorer;
        private final Scorer parentScorer;

        protected DescendantQueryNodeScorer(Searcher searcher, Scorer parentScorer, IndexReader reader) {
            super(searcher.getSimilarity());
            this.parentScorer = parentScorer;
            this.searcher = searcher;
            this.reader = reader;
        }

        public int doc() {
            return this.currentContextScorer.doc();
        }

        public Explanation explain(int doc) throws IOException {
            return new Explanation();
        }

        public boolean next() throws IOException {
            if (this.currentContextScorer == null) {
                if (!this.parentScorer.next()) {
                    log.error("parent not found");
                    return false;
                }
                int parentDoc = this.parentScorer.doc();
                Document parentDocument = this.reader.document(parentDoc, (FieldSelector)new UUIDFieldSelector());
                if (DescendantQueryNode.this.context != null) {
                    BooleanQuery bq = new BooleanQuery();
                    bq.add(DescendantQueryNode.this.context, BooleanClause.Occur.MUST);
                    bq.add((Query)new TermQuery(new Term(FieldNames.PARENT, parentDocument.get(FieldNames.UUID))), BooleanClause.Occur.MUST);
                    if (log.isDebugEnabled()) {
                        log.debug("Sub query " + bq);
                    }
                    this.currentContextScorer = bq.weight(this.searcher).scorer(this.reader);
                } else {
                    TermQuery newQuery = new TermQuery(new Term(FieldNames.PARENT, parentDocument.get(FieldNames.UUID)));
                    log.debug("Sub query " + newQuery);
                    this.currentContextScorer = newQuery.weight(this.searcher).scorer(this.reader);
                }
            }
            return this.currentContextScorer.next();
        }

        public float score() throws IOException {
            return this.currentContextScorer.score();
        }

        public boolean skipTo(int target) throws IOException {
            return this.currentContextScorer.skipTo(target);
        }
    }
}

