/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.checker;

import java.io.IOException;
import java.security.PrivilegedAction;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.impl.AbstractRepositorySuspender;
import org.exoplatform.services.jcr.impl.checker.InspectionReport;
import org.exoplatform.services.jcr.impl.core.lock.cacheable.AbstractCacheableLockManager;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeDataManagerImpl;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCWorkspaceDataContainer;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCWorkspaceDataContainerChecker;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

@Managed
@NameTemplate(value={@Property(key="service", value="RepositoryCheckController")})
public class RepositoryCheckController
extends AbstractRepositorySuspender
implements Startable {
    protected static Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.RepositoryCheckController");
    public static final String REPORT_CONSISTENT_MESSAGE = "Repository data is consistent";
    public static final String REPORT_NOT_CONSISTENT_MESSAGE = "Repository data is NOT consistent";
    public static final String EXCEPTION_DURING_CHECKING_MESSAGE = "Exception occured during consistency checking";
    public static final String CONFIRMATION_FAILED_MESSAGE = "For starting auto-repair function please enter \"YES\" as method parameter";
    protected InspectionReport lastReport;

    public RepositoryCheckController(ManageableRepository repository) {
        super(repository);
    }

    @Managed
    @ManagedDescription(value="Check repository data consistency. DB data, value storage and lucene index will be checked.")
    public String checkAll() {
        return this.checkAndRepair(new DataStorage[]{DataStorage.DB, DataStorage.VALUE_STORAGE, DataStorage.LUCENE_INDEX}, false);
    }

    @Managed
    @ManagedDescription(value="Check repository database consistency.")
    public String checkDataBase() {
        return this.checkAndRepair(new DataStorage[]{DataStorage.DB}, false);
    }

    @Managed
    @ManagedDescription(value="Check repository value storage consistency.")
    public String checkValueStorage() {
        return this.checkAndRepair(new DataStorage[]{DataStorage.VALUE_STORAGE}, false);
    }

    @Managed
    @ManagedDescription(value="Check repository search index consistency.")
    public String checkIndex() {
        return this.checkAndRepair(new DataStorage[]{DataStorage.LUCENE_INDEX}, false);
    }

    @Managed
    @ManagedDescription(value="Auto-repair inconsistencies for value storage. Don't forget to backup your data first. Set parameter to \"YES\" for enabling auto-repair feature")
    public String repairValueStorage(String confirmation) {
        if (confirmation.equalsIgnoreCase("YES")) {
            return this.checkAndRepair(new DataStorage[]{DataStorage.VALUE_STORAGE}, true);
        }
        return CONFIRMATION_FAILED_MESSAGE;
    }

    @Managed
    @ManagedDescription(value="Auto-repair inconsistencies for database. Don't forget to backup your data first. Set parameter to \"YES\" for enabling auto-repair feature")
    public String repairDataBase(String confirmation) {
        if (confirmation.equalsIgnoreCase("YES")) {
            return this.checkAndRepair(new DataStorage[]{DataStorage.DB}, true);
        }
        return CONFIRMATION_FAILED_MESSAGE;
    }

    public String checkAndRepair(final DataStorage[] storages, final boolean autoRepair) {
        return (String)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<String>(){

            @Override
            public String run() {
                return RepositoryCheckController.this.checkAndRepairAction(storages, autoRepair);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String checkAndRepairAction(DataStorage[] storages, boolean autoRepair) {
        try {
            this.createNewReport();
        }
        catch (IOException e) {
            return this.getExceptionDuringCheckingMessage(e);
        }
        try {
            this.suspendRepository();
            String e = this.doCheckAndRepair(storages, autoRepair);
            Object var6_6 = null;
            this.resumeRepository();
            this.closeReport();
            return e;
        }
        catch (RepositoryException e) {
            try {
                String string = this.getExceptionDuringCheckingMessage(e);
                Object var6_7 = null;
                this.resumeRepository();
                this.closeReport();
                return string;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.resumeRepository();
                this.closeReport();
                throw throwable;
            }
        }
    }

    protected void resumeRepository() {
        try {
            super.resumeRepository();
        }
        catch (RepositoryException e) {
            LOG.error((Object)("Can not resume repository. Error: " + e.getMessage()), (Throwable)e);
        }
    }

    private String doCheckAndRepair(DataStorage[] storages, boolean autoRepair) {
        try {
            block7: for (DataStorage storage : storages) {
                switch (storage) {
                    case DB: {
                        this.doCheckDataBase(autoRepair);
                        continue block7;
                    }
                    case VALUE_STORAGE: {
                        this.doCheckValueStorage(autoRepair);
                        continue block7;
                    }
                    case LUCENE_INDEX: {
                        this.doCheckIndex(autoRepair);
                    }
                }
            }
            return this.logAndGetCheckingResultMessage();
        }
        catch (Throwable e) {
            return this.logAndGetExceptionDuringCheckingMessage(e);
        }
    }

    private String logAndGetCheckingResultMessage() {
        if (this.lastReport.hasInconsistency()) {
            this.logComment(REPORT_NOT_CONSISTENT_MESSAGE);
            return REPORT_NOT_CONSISTENT_MESSAGE + this.getPathToReportMessage();
        }
        this.logComment(REPORT_CONSISTENT_MESSAGE);
        return REPORT_CONSISTENT_MESSAGE + this.getPathToReportMessage();
    }

    private String logAndGetExceptionDuringCheckingMessage(Throwable e) {
        this.logExceptionAndSetInconsistency(EXCEPTION_DURING_CHECKING_MESSAGE, e);
        return this.getExceptionDuringCheckingMessage(e) + this.getPathToReportMessage();
    }

    private String getExceptionDuringCheckingMessage(Throwable e) {
        return "Exception occured during consistency checking: " + e.getMessage();
    }

    private void logComment(String message) {
        try {
            this.lastReport.logComment(message);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void logExceptionAndSetInconsistency(String message, Throwable e) {
        try {
            this.lastReport.logExceptionAndSetInconsistency(message, e);
        }
        catch (IOException e1) {
            LOG.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    private void createNewReport() throws IOException {
        this.lastReport = new InspectionReport(this.repository.getConfiguration().getName());
    }

    private void closeReport() {
        try {
            this.lastReport.close();
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void doCheckDataBase(boolean autoRepair) {
        for (String wsName : this.repository.getWorkspaceNames()) {
            this.logComment("Check DB consistency. Workspace " + wsName);
            JDBCWorkspaceDataContainerChecker jdbcChecker = this.getJDBCChecker(wsName);
            jdbcChecker.checkDataBase(autoRepair);
            jdbcChecker.checkLocksInDataBase(autoRepair);
        }
    }

    private void doCheckValueStorage(boolean autoRepair) {
        for (String wsName : this.repository.getWorkspaceNames()) {
            this.logComment("Check ValueStorage consistency. Workspace " + wsName);
            this.getJDBCChecker(wsName).checkValueStorage(autoRepair);
        }
    }

    private void doCheckIndex(boolean autoRepair) throws RepositoryException, IOException {
        String systemWS = this.repository.getConfiguration().getSystemWorkspaceName();
        for (String wsName : this.repository.getWorkspaceNames()) {
            this.logComment("Check SearchIndex consistency. Workspace " + wsName);
            SearchManager searchManager = (SearchManager)this.getComponent(SearchManager.class, wsName);
            searchManager.checkIndex(this.lastReport, systemWS.equals(wsName));
        }
    }

    private JDBCWorkspaceDataContainerChecker getJDBCChecker(String wsName) {
        JDBCWorkspaceDataContainer dataContainer = (JDBCWorkspaceDataContainer)this.getComponent(JDBCWorkspaceDataContainer.class, wsName);
        AbstractCacheableLockManager lockManager = (AbstractCacheableLockManager)this.getComponent(AbstractCacheableLockManager.class, wsName);
        ValueStoragePluginProvider vsPlugin = (ValueStoragePluginProvider)this.getComponent(ValueStoragePluginProvider.class, wsName);
        WorkspaceEntry wsEntry = (WorkspaceEntry)this.getComponent(WorkspaceEntry.class, wsName);
        NodeTypeDataManagerImpl nodeTypeManager = (NodeTypeDataManagerImpl)this.getComponent(NodeTypeDataManagerImpl.class, wsName);
        return new JDBCWorkspaceDataContainerChecker(dataContainer, lockManager, vsPlugin, wsEntry, nodeTypeManager, this.lastReport);
    }

    private Object getComponent(Class forClass, String wsName) {
        return this.repository.getWorkspaceContainer(wsName).getComponent(forClass);
    }

    private String getPathToReportMessage() {
        return ". See full report by path " + this.lastReport.getReportPath();
    }

    public void start() {
    }

    public void stop() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataStorage {
        DB,
        VALUE_STORAGE,
        LUCENE_INDEX;

    }
}

