/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util.concurrent.locks;

import java.util.concurrent.locks.Lock;
import org.jboss.cache.invocation.InvocationContextContainer;
import org.jboss.cache.util.concurrent.locks.OwnableReentrantLock;
import org.jboss.cache.util.concurrent.locks.PerElementLockContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerElementOwnableReentrantLockContainer<E>
extends PerElementLockContainer<E> {
    private InvocationContextContainer icc;

    public PerElementOwnableReentrantLockContainer(int concurrencyLevel, InvocationContextContainer icc) {
        super(concurrencyLevel);
        this.icc = icc;
    }

    @Override
    public boolean ownsLock(E object, Object owner) {
        OwnableReentrantLock l = this.getLockFromMap(object);
        return l != null && owner.equals(l.getOwner());
    }

    @Override
    public boolean isLocked(E object) {
        OwnableReentrantLock l = this.getLockFromMap(object);
        return l != null && l.isLocked();
    }

    private OwnableReentrantLock getLockFromMap(E key) {
        return (OwnableReentrantLock)this.locks.get(key);
    }

    @Override
    protected final Lock newLock() {
        return new OwnableReentrantLock(this.icc);
    }
}

