/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.component.cache;

import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.component.cache.UIWCMCachePanel;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={ClearActionListener.class}), @EventConfig(listeners={RefreshActionListener.class})})
public class UIWCMCacheForm
extends UIForm {
    public static final String FIELD_LABEL_CURRENTSIZE = "currentSize";
    public static final String FIELD_LABEL_HIT = "hit";
    public static final String FIELD_LABEL_MISS = "miss";
    public static final String FIELD_LIVE_TIME = "livetime";
    public static final String FIELD_MAX_SIZE = "maxsize";
    public static final String CHECKBOX_ENABLE_CACHE = "isCacheEnable";
    private WCMComposer composer;
    private ExoCache<String, Object> cache = ((CacheService)WCMCoreUtils.getService(CacheService.class)).getCacheInstance("wcm.composer");

    public UIWCMCacheForm() throws Exception {
        this.composer = (WCMComposer)WCMCoreUtils.getService(WCMComposer.class);
        int hit = this.cache.getCacheHit();
        long currentSize = this.cache.getCacheSize();
        int missHit = this.cache.getCacheHit();
        long livetime = this.cache.getLiveTime();
        int maxsize = this.cache.getMaxSize();
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_LABEL_CURRENTSIZE, FIELD_LABEL_CURRENTSIZE, String.valueOf(currentSize)).setEditable(false));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_LABEL_HIT, FIELD_LABEL_HIT, String.valueOf(hit)).setEditable(false));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_LABEL_MISS, FIELD_LABEL_MISS, String.valueOf(missHit)).setEditable(false));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_MAX_SIZE, FIELD_MAX_SIZE, String.valueOf(maxsize)));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_LIVE_TIME, FIELD_LIVE_TIME, String.valueOf(livetime)));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(CHECKBOX_ENABLE_CACHE, CHECKBOX_ENABLE_CACHE, (Object)this.composer.isCached()));
        this.setActions(new String[]{"Clear", "Save", "Refresh"});
        this.update();
    }

    public void update() throws Exception {
        this.getUIStringInput(FIELD_LIVE_TIME).setValue((Object)String.valueOf(this.cache.getLiveTime()));
        this.getUIStringInput(FIELD_MAX_SIZE).setValue((Object)String.valueOf(this.cache.getMaxSize()));
        this.getUIStringInput(FIELD_LABEL_MISS).setValue((Object)String.valueOf(this.cache.getCacheMiss()));
        this.getUIStringInput(FIELD_LABEL_HIT).setValue((Object)String.valueOf(this.cache.getCacheHit()));
        this.getUIStringInput(FIELD_LABEL_CURRENTSIZE).setValue((Object)String.valueOf(this.cache.getCacheSize()));
        this.getUIFormCheckBoxInput(CHECKBOX_ENABLE_CACHE).setChecked(this.composer.isCached());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RefreshActionListener
    extends EventListener<UIWCMCacheForm> {
        public void execute(Event<UIWCMCacheForm> event) throws Exception {
            UIWCMCacheForm uiForm = (UIWCMCacheForm)((Object)event.getSource());
            UIWCMCachePanel wcmCachePanel = (UIWCMCachePanel)uiForm.getAncestorOfType(UIWCMCachePanel.class);
            uiForm.update();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)wcmCachePanel);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClearActionListener
    extends EventListener<UIWCMCacheForm> {
        public void execute(Event<UIWCMCacheForm> event) throws Exception {
            UIWCMCacheForm uiCacheForm = (UIWCMCacheForm)((Object)event.getSource());
            UIWCMCachePanel uiCachePanel = (UIWCMCachePanel)((UIWCMCacheForm)((Object)event.getSource())).getParent();
            uiCacheForm.cache.clearCache();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiCachePanel);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIWCMCacheForm> {
        public void execute(Event<UIWCMCacheForm> event) throws Exception {
            UIWCMCacheForm uiCacheForm = (UIWCMCacheForm)((Object)event.getSource());
            UIWCMCachePanel cachePanel = (UIWCMCachePanel)((UIWCMCacheForm)((Object)event.getSource())).getAncestorOfType(UIWCMCachePanel.class);
            String livetime = (String)uiCacheForm.getUIStringInput(UIWCMCacheForm.FIELD_LIVE_TIME).getValue();
            Boolean isChecked = uiCacheForm.getUIFormCheckBoxInput(UIWCMCacheForm.CHECKBOX_ENABLE_CACHE).isChecked();
            if (!isChecked.booleanValue()) {
                throw new Exception("cache enable is not set");
            }
            String maxsize = (String)uiCacheForm.getUIStringInput(UIWCMCacheForm.FIELD_MAX_SIZE).getValue();
            uiCacheForm.cache.setLiveTime(Long.parseLong(livetime));
            uiCacheForm.cache.setMaxSize(Integer.parseInt(maxsize));
            uiCacheForm.update();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)cachePanel);
        }
    }
}

