/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.extensions.publication.impl;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.wcm.extensions.publication.PublicationManager;
import org.exoplatform.services.wcm.extensions.publication.context.ContextPlugin;
import org.exoplatform.services.wcm.extensions.publication.context.impl.ContextConfig;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.StatesLifecyclePlugin;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.impl.LifecyclesConfig;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublicationManagerImpl
implements PublicationManager,
Startable {
    private StatesLifecyclePlugin statesLifecyclePlugin;
    private ContextPlugin contextPlugin;

    @Override
    public void addLifecycle(ComponentPlugin plugin) {
        if (plugin instanceof StatesLifecyclePlugin) {
            this.statesLifecyclePlugin = (StatesLifecyclePlugin)plugin;
        }
    }

    @Override
    public void addContext(ComponentPlugin plugin) {
        if (plugin instanceof ContextPlugin) {
            this.contextPlugin = (ContextPlugin)plugin;
        }
    }

    public void start() {
    }

    public void stop() {
    }

    @Override
    public ContextConfig.Context getContext(String name) {
        if (name != null && this.contextPlugin != null && this.contextPlugin.getContextConfig() != null) {
            for (ContextConfig.Context context : this.contextPlugin.getContextConfig().getContexts()) {
                if (!name.equals(context.getName())) continue;
                return context;
            }
        }
        return null;
    }

    @Override
    public List<ContextConfig.Context> getContexts() {
        if (this.contextPlugin != null && this.contextPlugin.getContextConfig() != null) {
            return this.contextPlugin.getContextConfig().getContexts();
        }
        return null;
    }

    @Override
    public LifecyclesConfig.Lifecycle getLifecycle(String name) {
        if (name != null && this.statesLifecyclePlugin != null && this.statesLifecyclePlugin.getLifecyclesConfig() != null) {
            for (LifecyclesConfig.Lifecycle lifecycle : this.statesLifecyclePlugin.getLifecyclesConfig().getLifecycles()) {
                if (!name.equals(lifecycle.getName())) continue;
                return lifecycle;
            }
        }
        return null;
    }

    @Override
    public List<LifecyclesConfig.Lifecycle> getLifecycles() {
        if (this.statesLifecyclePlugin != null && this.statesLifecyclePlugin.getLifecyclesConfig() != null) {
            return this.statesLifecyclePlugin.getLifecyclesConfig().getLifecycles();
        }
        return null;
    }

    @Override
    public List<LifecyclesConfig.Lifecycle> getLifecyclesFromUser(String remoteUser, String state) {
        ArrayList<LifecyclesConfig.Lifecycle> lifecycles = null;
        if (this.statesLifecyclePlugin != null && this.statesLifecyclePlugin.getLifecyclesConfig() != null) {
            for (LifecyclesConfig.Lifecycle lifecycle : this.statesLifecyclePlugin.getLifecyclesConfig().getLifecycles()) {
                if (lifecycles == null) {
                    lifecycles = new ArrayList<LifecyclesConfig.Lifecycle>();
                }
                ExoContainer container = ExoContainerContext.getCurrentContainer();
                IdentityRegistry identityRegistry = (IdentityRegistry)container.getComponentInstanceOfType(IdentityRegistry.class);
                Identity identity = identityRegistry.getIdentity(remoteUser);
                block1: for (LifecyclesConfig.State state_ : lifecycle.getStates()) {
                    if (!state.equals(state_.getState())) continue;
                    ArrayList<String> memberships = new ArrayList<String>();
                    if (state_.getMembership() != null && !"automatic".equals(state_.getMembership())) {
                        memberships.add(state_.getMembership());
                    }
                    if (state_.getMemberships() != null) {
                        memberships.addAll(state_.getMemberships());
                    }
                    for (String membership : memberships) {
                        String[] membershipTab = membership.split(":");
                        if (!identity.isMemberOf(membershipTab[1], membershipTab[0])) continue;
                        lifecycles.add(lifecycle);
                        continue block1;
                    }
                }
            }
        }
        return lifecycles;
    }
}

