/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.extensions.publication.lifecycle.authoring.ui;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.wcm.extensions.publication.PublicationManager;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.authoring.AuthoringPublicationConstant;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.impl.LifecyclesConfig;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.StageAndVersionPublicationConstant;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationContainer;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationPanel;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/wcm/webui/publication/lifecycle/authoring/ui/UIPublicationPanel.gtmpl", events={@EventConfig(listeners={ChangeStateActionListener.class}), @EventConfig(listeners={UIPublicationPanel.ChangeVersionActionListener.class}), @EventConfig(listeners={UIPublicationPanel.PreviewVersionActionListener.class}), @EventConfig(listeners={UIPublicationPanel.RestoreVersionActionListener.class}), @EventConfig(listeners={UIPublicationPanel.SeeAllVersionActionListener.class}), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={ResetActionListener.class}), @EventConfig(listeners={UIPublicationPanel.CloseActionListener.class})})
public class UIPublicationPanel
extends org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationPanel {
    public static final String OBJECTID = "objectId";
    public static final String START_PUBLICATION = "UIPublicationPanelStartDateInput";
    public static final String END_PUBLICATION = "UIPublicationPanelEndDateInput";
    public static final Log LOG = LogFactory.getLog(UIPublicationPanel.class);

    public UIPublicationPanel() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormDateTimeInput(START_PUBLICATION, START_PUBLICATION, null));
        this.addUIFormInput((UIFormInput)new UIFormDateTimeInput(END_PUBLICATION, END_PUBLICATION, null));
        this.setActions(new String[]{"Save", "Reset", "Close"});
    }

    public void init(Node node) throws Exception {
        Calendar startDate = null;
        Calendar endDate = null;
        String nodeVersionUUID = null;
        super.init(node);
        if ("published".equals(node.getProperty(StageAndVersionPublicationConstant.CURRENT_STATE).getString()) && !"".equals(nodeVersionUUID = node.getProperty(StageAndVersionPublicationConstant.LIVE_REVISION_PROP).getString())) {
            Node revision = this.getRevisionByUUID(nodeVersionUUID);
            this.setCurrentRevision(revision);
        }
        if (node.hasProperty(AuthoringPublicationConstant.END_TIME_PROPERTY)) {
            endDate = node.getProperty(AuthoringPublicationConstant.END_TIME_PROPERTY).getDate();
        }
        if (node.hasProperty(AuthoringPublicationConstant.START_TIME_PROPERTY)) {
            startDate = node.getProperty(AuthoringPublicationConstant.START_TIME_PROPERTY).getDate();
        }
        if (startDate != null) {
            ((UIFormDateTimeInput)this.getChildById(START_PUBLICATION)).setCalendar(startDate);
        }
        if (endDate != null) {
            ((UIFormDateTimeInput)this.getChildById(END_PUBLICATION)).setCalendar(endDate);
        }
    }

    public List<LifecyclesConfig.State> getStates(Node cNode) throws Exception {
        ArrayList<LifecyclesConfig.State> states = new ArrayList();
        String lifecycleName = this.getLifeCycle(cNode);
        PublicationManager publicationManagerImpl = (PublicationManager)this.getApplicationComponent(PublicationManager.class);
        LifecyclesConfig.Lifecycle lifecycle = publicationManagerImpl.getLifecycle(lifecycleName);
        states = lifecycle.getStates();
        return states;
    }

    private String getLifeCycle(Node cNode) throws Exception {
        String lifecycleName = null;
        try {
            lifecycleName = cNode.getProperty("publication:lifecycle").getString();
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to get States for node " + cNode), (Throwable)e);
        }
        return lifecycleName;
    }

    public boolean canReachState(LifecyclesConfig.State state, String remoteUser, NodeImpl node) {
        IdentityRegistry identityRegistry = (IdentityRegistry)this.getApplicationComponent(IdentityRegistry.class);
        Identity currentUser = identityRegistry.getIdentity(remoteUser);
        if (this.isAuthorizedByMembership(state, currentUser)) {
            return true;
        }
        return this.isAuthorizedByRole(state, currentUser, node);
    }

    boolean isAuthorizedByMembership(LifecyclesConfig.State state, Identity currentUser) {
        String membership = state.getMembership();
        ArrayList<String> memberships = new ArrayList<String>();
        if (membership != null) {
            memberships.add(membership);
        }
        if (state.getMemberships() != null) {
            memberships.addAll(state.getMemberships());
        }
        for (String membership_ : memberships) {
            String expectedRole;
            String[] membershipTab = membership_.split(":");
            String expectedGroup = membershipTab[1];
            if (!currentUser.isMemberOf(expectedGroup, expectedRole = membershipTab[0])) continue;
            return true;
        }
        return false;
    }

    boolean isAuthorizedByRole(LifecyclesConfig.State state, Identity currentUser, NodeImpl node) {
        try {
            String role_ = state.getRole();
            ArrayList<String> roles = new ArrayList<String>();
            if (role_ != null) {
                roles.add(role_);
            }
            if (state.getRoles() != null) {
                roles.addAll(state.getRoles());
            }
            for (String role : roles) {
                AccessControlList acl = node.getACL();
                if (!acl.hasPermissions()) continue;
                List entries = acl.getPermissionEntries();
                for (AccessControlEntry accessControlEntry : entries) {
                    String authorizedGroup;
                    String identity = accessControlEntry.getIdentity();
                    if (identity.indexOf(58) <= 0 || !"set_property".equals(accessControlEntry.getPermission()) || !currentUser.isMemberOf(authorizedGroup = identity.split(":")[1], role)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to extract node permissions", (Throwable)e);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResetActionListener
    extends EventListener<UIPublicationPanel> {
        public void execute(Event<UIPublicationPanel> event) throws Exception {
            UIPublicationPanel publicationPanel = (UIPublicationPanel)((Object)event.getSource());
            Node node = publicationPanel.getCurrentNode();
            UIFormDateTimeInput startPublication = (UIFormDateTimeInput)publicationPanel.getChildById(UIPublicationPanel.START_PUBLICATION);
            startPublication.setCalendar(null);
            if (node.hasProperty(AuthoringPublicationConstant.START_TIME_PROPERTY)) {
                node.getProperty(AuthoringPublicationConstant.START_TIME_PROPERTY).remove();
                node.save();
            }
            UIFormDateTimeInput endPublication = (UIFormDateTimeInput)publicationPanel.getChildById(UIPublicationPanel.END_PUBLICATION);
            endPublication.setCalendar(null);
            if (node.hasProperty(AuthoringPublicationConstant.END_TIME_PROPERTY)) {
                node.getProperty(AuthoringPublicationConstant.END_TIME_PROPERTY).remove();
                node.save();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIPublicationPanel> {
        public void execute(Event<UIPublicationPanel> event) throws Exception {
            UIPublicationPanel publicationPanel = (UIPublicationPanel)((Object)event.getSource());
            UIFormDateTimeInput startPublication = (UIFormDateTimeInput)publicationPanel.getChildById(UIPublicationPanel.START_PUBLICATION);
            UIFormDateTimeInput endPublication = (UIFormDateTimeInput)publicationPanel.getChildById(UIPublicationPanel.END_PUBLICATION);
            Calendar startDate = startPublication.getCalendar();
            Calendar endDate = endPublication.getCalendar();
            Node node = publicationPanel.getCurrentNode();
            try {
                if (startDate != null && endDate != null && startDate.after(endDate)) {
                    UIApplication uiApp = (UIApplication)publicationPanel.getAncestorOfType(UIApplication.class);
                    uiApp.addMessage(new ApplicationMessage("UIPublicationPanel.msg.fromDate-after-toDate", null));
                    return;
                }
                if (!"".equals(startPublication.getValue()) || !"".equals(endPublication.getValue())) {
                    if (!"".equals(startPublication.getValue())) {
                        node.setProperty(AuthoringPublicationConstant.START_TIME_PROPERTY, startDate);
                    }
                    if (!"".equals(endPublication.getValue())) {
                        node.setProperty(AuthoringPublicationConstant.END_TIME_PROPERTY, endDate);
                    }
                    node.getSession().save();
                }
            }
            catch (NullPointerException e) {
                UIApplication uiApp = (UIApplication)publicationPanel.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIPublicationPanel.msg.invalid-format", null));
                return;
            }
            catch (ItemExistsException iee) {
                LOG.error((Object)"Error when adding properties to node");
            }
            UIPopupContainer uiPopupContainer = (UIPopupContainer)publicationPanel.getAncestorOfType(UIPopupContainer.class);
            uiPopupContainer.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupContainer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeStateActionListener
    extends EventListener<UIPublicationPanel> {
        public void execute(Event<UIPublicationPanel> event) throws Exception {
            UIPublicationPanel publicationPanel = (UIPublicationPanel)((Object)event.getSource());
            String state = event.getRequestContext().getRequestParameter(UIPublicationPanel.OBJECTID);
            Node currentNode = publicationPanel.getCurrentNode();
            PublicationService publicationService = (PublicationService)publicationPanel.getApplicationComponent(PublicationService.class);
            WCMPublicationService wcmPublicationService = (WCMPublicationService)publicationPanel.getApplicationComponent(WCMPublicationService.class);
            PublicationPlugin publicationPlugin = (PublicationPlugin)publicationService.getPublicationPlugins().get(AuthoringPublicationConstant.LIFECYCLE_NAME);
            HashMap<String, String> context = new HashMap<String, String>();
            Node currentRevision = publicationPanel.getCurrentRevision();
            if (currentRevision != null) {
                context.put(AuthoringPublicationConstant.CURRENT_REVISION_NAME, currentRevision.getName());
            }
            try {
                publicationPlugin.changeState(currentNode, state, context);
                currentNode.setProperty("publication:lastUser", event.getRequestContext().getRemoteUser());
                String siteName = Util.getPortalRequestContext().getPortalOwner();
                String remoteUser = Util.getPortalRequestContext().getRemoteUser();
                wcmPublicationService.updateLifecyleOnChangeContent(currentNode, siteName, remoteUser, state);
                publicationPanel.updatePanel();
            }
            catch (Exception e) {
                UIApplication uiApp = (UIApplication)publicationPanel.getAncestorOfType(UIApplication.class);
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            }
            UIPublicationContainer publicationContainer = (UIPublicationContainer)publicationPanel.getAncestorOfType(UIPublicationContainer.class);
            publicationContainer.setActiveTab((UIComponent)publicationPanel, event.getRequestContext());
        }
    }
}

