/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.extensions.publication;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.jcr.Node;
import javax.jcr.lock.Lock;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.extensions.publication.context.impl.ContextConfig;
import org.exoplatform.services.wcm.extensions.publication.impl.PublicationManagerImpl;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.impl.LifecyclesConfig;
import org.exoplatform.services.wcm.extensions.utils.ContextComparator;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.publication.WebpagePublicationPlugin;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class WCMPublicationServiceImpl
extends org.exoplatform.services.wcm.publication.WCMPublicationServiceImpl {
    private static final Log log = ExoLogger.getLogger(WCMPublicationServiceImpl.class);
    private PublicationService publicationService = (PublicationService)WCMCoreUtils.getService(PublicationService.class);
    private WCMComposer wcmComposer = (WCMComposer)WCMCoreUtils.getService(WCMComposer.class);

    public void enrollNodeInLifecycle(Node node, String siteName, String remoteUser) {
        block12: {
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)(node.getPath() + "::" + siteName + "::" + remoteUser));
                }
                PublicationManagerImpl publicationManagerImpl = (PublicationManagerImpl)WCMCoreUtils.getService(PublicationManagerImpl.class);
                ContextComparator comparator = new ContextComparator();
                TreeSet<ContextConfig.Context> treeSetContext = new TreeSet<ContextConfig.Context>(comparator);
                treeSetContext.addAll(publicationManagerImpl.getContexts());
                for (ContextConfig.Context context : treeSetContext) {
                    boolean pathVerified = true;
                    boolean nodetypeVerified = true;
                    boolean siteVerified = true;
                    boolean membershipVerified = true;
                    String path = context.getPath();
                    String nodetype = context.getNodetype();
                    String site = context.getSite();
                    ArrayList<String> memberships = new ArrayList<String>();
                    if (context.getMembership() != null) {
                        memberships.add(context.getMembership());
                    }
                    if (context.getMemberships() != null) {
                        memberships.addAll(context.getMemberships());
                    }
                    if (path != null) {
                        String workspace = node.getSession().getWorkspace().getName();
                        ManageableRepository manaRepository = (ManageableRepository)node.getSession().getRepository();
                        String repository = manaRepository.getConfiguration().getName();
                        String[] pathTab = path.split(":");
                        boolean bl = pathVerified = node.getPath().contains(pathTab[2]) && repository.equals(pathTab[0]) && workspace.equals(pathTab[1]);
                    }
                    if (nodetype != null) {
                        nodetypeVerified = nodetype.equals(node.getPrimaryNodeType().getName());
                    }
                    if (site != null) {
                        siteVerified = site.equals(siteName);
                    }
                    if (memberships.size() > 0) {
                        for (String membership : memberships) {
                            String[] membershipTab = membership.split(":");
                            IdentityRegistry identityRegistry = (IdentityRegistry)WCMCoreUtils.getService(IdentityRegistry.class);
                            Identity identity = identityRegistry.getIdentity(remoteUser);
                            membershipVerified = identity.isMemberOf(membershipTab[1], membershipTab[0]);
                            if (!membershipVerified) continue;
                            break;
                        }
                    }
                    if (!pathVerified || !nodetypeVerified || !siteVerified || !membershipVerified) continue;
                    LifecyclesConfig.Lifecycle lifecycle = publicationManagerImpl.getLifecycle(context.getLifecycle());
                    String lifecycleName = ((WebpagePublicationPlugin)this.getWebpagePublicationPlugins().get(lifecycle.getPublicationPlugin())).getLifecycleName();
                    if (node.canAddMixin("publication:authoring")) {
                        node.addMixin("publication:authoring");
                        node.setProperty("publication:lastUser", remoteUser);
                        node.setProperty("publication:lifecycle", lifecycle.getName());
                        node.getSession().save();
                    }
                    this.enrollNodeInLifecycle(node, lifecycleName);
                    this.setInitialState(node, lifecycle, remoteUser);
                    break;
                }
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) break block12;
                log.error((Object)"Couldn't complete the enrollement : ", (Throwable)ex);
            }
        }
    }

    private void setInitialState(Node node, LifecyclesConfig.Lifecycle lifecycle, String remoteUser) throws Exception {
        block10: {
            List<LifecyclesConfig.State> states = lifecycle.getStates();
            if (states == null || states.size() <= 0) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("could not find an initial state in lifecycle " + lifecycle.getName()));
                }
            } else {
                String initialState = states.get(0).getState();
                PublicationService publicationService = (PublicationService)WCMCoreUtils.getService(PublicationService.class);
                PublicationPlugin publicationPlugin = (PublicationPlugin)publicationService.getPublicationPlugins().get("Authoring publication");
                HashMap<String, String> context = new HashMap<String, String>();
                NodeLocation currentRevisionLocation = NodeLocation.make((Node)node);
                Node currentRevision = this.getCurrentRevision(currentRevisionLocation);
                if (currentRevision != null) {
                    context.put("Publication.context.currentVersion", currentRevision.getName());
                }
                try {
                    if (node.isLocked()) {
                        Lock lock = node.getLock();
                        String owner = lock.getLockOwner();
                        if (log.isInfoEnabled()) {
                            log.info((Object)"node is locked by owner, unlocking it for enrollement");
                        }
                        if (node.holdsLock() && remoteUser.equals(owner)) {
                            String lockToken = LockUtil.getLockToken((Node)node);
                            if (lockToken != null) {
                                node.getSession().addLockToken(lockToken);
                            }
                            node.unlock();
                            node.removeMixin("mix:lockable");
                            node.getSession().save();
                            LockUtil.removeLock((Node)node);
                        }
                    }
                    context.put("Publication.context.isInitialPhase", "true");
                    publicationPlugin.changeState(node, initialState, context);
                    node.setProperty("publication:lastUser", remoteUser);
                    node.getSession().save();
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block10;
                    log.error((Object)"Error setting staged state : ", (Throwable)e);
                }
            }
        }
    }

    public Node getCurrentRevision(NodeLocation currentRevisionLocation) {
        return NodeLocation.getNodeByLocation((NodeLocation)currentRevisionLocation);
    }

    public void updateLifecyleOnChangeContent(Node node, String siteName, String remoteUser, String newState) throws Exception {
        if (!this.publicationService.isNodeEnrolledInLifecycle(node)) {
            this.enrollNodeInLifecycle(node, siteName, remoteUser);
        }
        String lifecycleName = this.publicationService.getNodeLifecycleName(node);
        WebpagePublicationPlugin publicationPlugin = (WebpagePublicationPlugin)this.getWebpagePublicationPlugins().get(lifecycleName);
        publicationPlugin.updateLifecyleOnChangeContent(node, remoteUser, newState);
        this.wcmComposer.updateContent(node.getSession().getWorkspace().getName(), node.getPath(), new HashMap());
        this.listenerService.broadcast("WCMPublicationService.event.updateState", (Object)this.cmsService, (Object)node);
    }
}

