/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.browsecontent;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ecm.webui.component.browsecontent.UIBrowseContainer;
import org.exoplatform.ecm.webui.component.browsecontent.UITagList;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/browse/UITagList.gtmpl", events={@EventConfig(listeners={ViewByTagActionListener.class})})
public class UITagList
extends UIComponent {
    public static final String PUBLIC_TAG_NODE_PATH = "exoPublicTagNode";
    private String tagPath_;

    public List<Node> getPrivateTagLink() throws Exception {
        String repository = this.getRepository();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository manageableRepo = repositoryService.getRepository(repository);
        String workspace = manageableRepo.getConfiguration().getDefaultWorkspaceName();
        String userName = this.getUserName();
        NewFolksonomyService newFolksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
        return newFolksonomyService.getAllPrivateTags(userName, repository, workspace);
    }

    public List<Node> getPublicTagLink() throws Exception {
        String repository = this.getRepository();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository manageableRepo = repositoryService.getRepository(repository);
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)container.getComponentInstanceOfType(NodeHierarchyCreator.class);
        String workspace = manageableRepo.getConfiguration().getDefaultWorkspaceName();
        String publicTagNodePath = nodeHierarchyCreator.getJcrPath(PUBLIC_TAG_NODE_PATH);
        NewFolksonomyService newFolksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
        return newFolksonomyService.getAllPublicTags(publicTagNodePath, repository, workspace);
    }

    public Map<String, String> getTagStyle() throws Exception {
        String repository = this.getRepository();
        String workspace = ((UIBrowseContainer)this.getAncestorOfType(UIBrowseContainer.class)).getDMSSystemWorkspace(repository);
        NewFolksonomyService newFolksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
        HashMap<String, String> tagStyle = new HashMap<String, String>();
        for (Node tag : newFolksonomyService.getAllTagStyle(repository, workspace)) {
            tagStyle.put(tag.getProperty("exo:styleRange").getValue().getString(), tag.getProperty("exo:htmlStyle").getValue().getString());
        }
        return tagStyle;
    }

    public String getTagHtmlStyle(Map<String, String> tagStyles, int tagCount) throws Exception {
        for (Map.Entry<String, String> entry : tagStyles.entrySet()) {
            if (!this.checkTagRate(tagCount, entry.getKey())) continue;
            return entry.getValue();
        }
        return "";
    }

    private boolean checkTagRate(int numOfDocument, String range) throws Exception {
        String[] vals = StringUtils.split((String)range, (String)"..");
        int minValue = Integer.parseInt(vals[0]);
        int maxValue = vals[1].equals("*") ? Integer.MAX_VALUE : Integer.parseInt(vals[1]);
        return minValue <= numOfDocument && numOfDocument < maxValue;
    }

    public String getRepository() {
        return ((UIBrowseContainer)this.getAncestorOfType(UIBrowseContainer.class)).getRepository();
    }

    public String getWorkspace() {
        return ((UIBrowseContainer)this.getAncestorOfType(UIBrowseContainer.class)).getWorkSpace();
    }

    public String getUserName() {
        return ((UIBrowseContainer)this.getAncestorOfType(UIBrowseContainer.class)).getUserName();
    }

    public String getTagPath() {
        return this.tagPath_;
    }

    public void setTagPath(String tagName) {
        this.tagPath_ = tagName;
    }
}

