/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.browsecontent;

import java.io.InputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Value;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.component.browsecontent.UIBrowseContainer;
import org.exoplatform.ecm.webui.component.browsecontent.UIBrowseContentPortlet;
import org.exoplatform.ecm.webui.component.browsecontent.UIDocumentDetail;
import org.exoplatform.ecm.webui.component.browsecontent.UIToolBar;
import org.exoplatform.ecm.webui.presentation.AbstractActionComponent;
import org.exoplatform.ecm.webui.presentation.UIBaseNodePresentation;
import org.exoplatform.ecm.webui.presentation.removeattach.RemoveAttachmentComponent;
import org.exoplatform.ecm.webui.presentation.removecomment.RemoveCommentComponent;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.comments.CommentsService;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.Parameter;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={ChangeLanguageActionListener.class}), @EventConfig(listeners={ChangeNodeActionListener.class}), @EventConfig(listeners={DownloadActionListener.class})})
public class UIDocumentDetail
extends UIBaseNodePresentation
implements UIPopupComponent {
    protected Node node_;
    private Node originalNode_;
    private String language_;
    private JCRResourceResolver jcrTemplateResourceResolver_;
    private static final Log LOG = ExoLogger.getLogger((String)"portlet.DocumentDetail");

    public void processRender(WebuiRequestContext context) throws Exception {
        if (this.isValidNode()) {
            this.setRendered(true);
            super.processRender(context);
        } else {
            this.setRendered(false);
        }
    }

    protected boolean isValidNode() throws Exception {
        if (this.originalNode_ == null) {
            return false;
        }
        return this.getUIBrowseContainer().getNodeByPath(this.originalNode_.getPath(), this.getWorkspaceName()) != null;
    }

    private UIBrowseContainer getUIBrowseContainer() {
        return (UIBrowseContainer)((UIBrowseContentPortlet)this.getAncestorOfType(UIBrowseContentPortlet.class)).findFirstComponentOfType(UIBrowseContainer.class);
    }

    public UIComponent getCommentComponent() {
        return this.getUIBrowseContainer().getChild(UIToolBar.class);
    }

    public UIComponent getRemoveAttach() throws Exception {
        this.removeChild(RemoveAttachmentComponent.class);
        UIComponent uicomponent = this.addChild(RemoveAttachmentComponent.class, null, "DocumentDetailRemoveAttach".concat(UUID.randomUUID().toString()));
        ((AbstractActionComponent)uicomponent).setLstComponentupdate(Arrays.asList(this.getParent().getClass()));
        return uicomponent;
    }

    public UIComponent getRemoveComment() throws Exception {
        this.removeChild(RemoveCommentComponent.class);
        UIComponent uicomponent = this.addChild(RemoveCommentComponent.class, null, "DocumentDetailRemoveComment".concat(UUID.randomUUID().toString()));
        ((AbstractActionComponent)uicomponent).setLstComponentupdate(Arrays.asList(this.getParent().getClass()));
        return uicomponent;
    }

    public String getTemplatePath() {
        String userName = Util.getPortalRequestContext().getRemoteUser();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String template = null;
        try {
            template = SessionProviderFactory.isAnonim() ? templateService.getTemplatePathByAnonymous(false, this.getNodeType()) : templateService.getTemplatePathByUser(false, this.getNodeType(), userName);
            if (this.jcrTemplateResourceResolver_ == null) {
                this.newJCRTemplateResourceResolver();
            }
            return template;
        }
        catch (AccessControlException e) {
            UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
            Object[] arg = new Object[]{template};
            uiApp.addMessage(new ApplicationMessage("UIDocumentForm.msg.do-not-permission", arg, 0));
            return null;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Exception when get template ", (Throwable)e);
            }
            UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
            Object[] arg = new Object[]{template};
            uiApp.addMessage(new ApplicationMessage("UIDocumentForm.msg.not-support", arg, 0));
            return null;
        }
    }

    public String getIcons(Node node, String type) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getNodeTypeIcon((Node)node, (String)type);
    }

    public String getTemplate() {
        return this.getTemplatePath();
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        if (this.jcrTemplateResourceResolver_ == null) {
            this.newJCRTemplateResourceResolver();
        }
        return this.jcrTemplateResourceResolver_;
    }

    public void newJCRTemplateResourceResolver() {
        block2: {
            try {
                String systemWorkspace = ((UIBrowseContainer)((UIBrowseContentPortlet)this.getAncestorOfType(UIBrowseContentPortlet.class)).getChild(UIBrowseContainer.class)).getDmsSystemWorkspace();
                this.jcrTemplateResourceResolver_ = new JCRResourceResolver(systemWorkspace);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)"Exception when get template resource", (Throwable)e);
            }
        }
    }

    public Object getComponentInstanceOfType(String className) {
        Object service;
        block2: {
            service = null;
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> object = loader.loadClass(className);
                service = this.getApplicationComponent(object);
            }
            catch (ClassNotFoundException ex) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)("Not found class " + className), (Throwable)ex);
            }
        }
        return service;
    }

    public Node getNode() throws Exception {
        if (this.node_.hasProperty("exo:language")) {
            String defaultLang = this.node_.getProperty("exo:language").getString();
            if (this.language_ == null) {
                this.language_ = defaultLang;
            }
            if (!this.language_.equals(defaultLang)) {
                Node curNode = this.node_.getNode("languages/" + this.language_);
                return curNode;
            }
        }
        return this.node_;
    }

    public void setOriginalNode(Node node) {
        this.originalNode_ = node;
    }

    public Node getOriginalNode() throws Exception {
        return this.originalNode_;
    }

    public PortletPreferences getPortletPreferences() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequest prequest = pcontext.getRequest();
        PortletPreferences portletPref = prequest.getPreferences();
        return portletPref;
    }

    public void setLanguage(String language) {
        this.language_ = language;
    }

    public String getLanguage() {
        return this.language_;
    }

    public String getDownloadLink(Node node) throws Exception {
        return Utils.getDownloadLink((Node)node);
    }

    public String getImage(Node node) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node imageNode = node.getNode("exo:image");
        InputStream input = imageNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(this.originalNode_.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public String getWebDAVServerPrefix() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)PortletRequestContext.getCurrentInstance();
        String prefixWebDAV = portletRequestContext.getRequest().getScheme() + "://" + portletRequestContext.getRequest().getServerName() + ":" + String.format("%s", portletRequestContext.getRequest().getServerPort());
        return prefixWebDAV;
    }

    public void setNode(Node docNode) {
        this.node_ = docNode;
    }

    public List<Node> getAttachments() throws Exception {
        ArrayList<Node> attachments = new ArrayList<Node>();
        NodeIterator childrenIterator = this.node_.getNodes();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        int attachData = 0;
        while (childrenIterator.hasNext()) {
            Node childNode = childrenIterator.nextNode();
            String nodeType = childNode.getPrimaryNodeType().getName();
            List listCanCreateNodeType = org.exoplatform.ecm.webui.utils.Utils.getListAllowedFileType((Node)this.originalNode_, (TemplateService)templateService);
            if (!listCanCreateNodeType.contains(nodeType)) continue;
            if (childNode.hasProperty("jcr:data")) {
                attachData = childNode.getProperty("jcr:data").getStream().available();
                if (attachData <= 0) continue;
                attachments.add(childNode);
                continue;
            }
            attachments.add(childNode);
        }
        return attachments;
    }

    @Deprecated
    public String getAttachmentURL(Node attNode, Parameter[] params) throws Exception {
        return this.getViewableLink(attNode, params);
    }

    public String getViewableLink(Node attNode, Parameter[] params) throws Exception {
        return this.event("ChangeNode", org.exoplatform.ecm.webui.utils.Utils.formatNodeName((String)attNode.getPath()), params);
    }

    public List<Node> getRelations() throws Exception {
        ArrayList<Node> relations = new ArrayList<Node>();
        if (this.node_.hasProperty("exo:relation")) {
            Value[] vals = this.node_.getProperty("exo:relation").getValues();
            for (int i = 0; i < vals.length; ++i) {
                String uuid = vals[i].getString();
                Node node = this.getNodeByUUID(uuid);
                relations.add(node);
            }
        }
        return relations;
    }

    public boolean isNodeTypeSupported() {
        try {
            TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
            return templateService.isManagedNodeType(this.getNodeType());
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isNodeTypeSupported(String nodeTypeName) {
        try {
            TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
            return templateService.isManagedNodeType(nodeTypeName);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Node getNodeByUUID(String uuid) throws Exception {
        ManageableRepository manageRepo = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository();
        String[] workspaces = manageRepo.getWorkspaceNames();
        SessionProvider provider = SessionProviderFactory.createSessionProvider();
        for (String ws : workspaces) {
            try {
                return provider.getSession(ws, manageRepo).getNodeByUUID(uuid);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public boolean hasPropertyContent(Node node, String property) {
        try {
            return node.hasProperty(property);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getNodeType() throws Exception {
        return this.originalNode_.getPrimaryNodeType().getName();
    }

    public String getRssLink() {
        return null;
    }

    public boolean isRssLink() {
        return false;
    }

    public List<Node> getComments() throws Exception {
        return ((CommentsService)this.getApplicationComponent(CommentsService.class)).getComments(this.node_, this.getLanguage());
    }

    public List<String> getSupportedLocalise() throws Exception {
        MultiLanguageService multiLanguageService = (MultiLanguageService)this.getApplicationComponent(MultiLanguageService.class);
        return multiLanguageService.getSupportedLanguages(this.originalNode_);
    }

    public String getViewTemplate(String nodeTypeName, String templateName) throws Exception {
        TemplateService tempServ = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return tempServ.getTemplatePath(false, nodeTypeName, templateName);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public String getPortalName() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        return containerInfo.getContainerName();
    }

    public String getRepository() throws Exception {
        return ((ManageableRepository)this.originalNode_.getSession().getRepository()).getConfiguration().getName();
    }

    public String getWorkspaceName() throws Exception {
        return this.originalNode_.getSession().getWorkspace().getName();
    }

    public String encodeHTML(String text) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.encodeHTML((String)text);
    }

    public boolean isShowPlanView(Node node) throws Exception {
        return false;
    }

    public List<Node> getListNodes(Node node) throws Exception {
        NodeIterator childrenIterator = node.getNodes();
        ArrayList<Node> childrenList = new ArrayList<Node>();
        while (childrenIterator.hasNext()) {
            Node child = (Node)childrenIterator.next();
            if (!PermissionUtil.canRead((Node)child)) continue;
            childrenList.add(child);
        }
        return childrenList;
    }

    public String getTemplateSkin(String nodeTypeName, String skinName) throws Exception {
        TemplateService tempServ = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return tempServ.getSkinPath(nodeTypeName, skinName, this.getLanguage());
    }

    public UIComponent getUIComponent(String mimeType) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getUIComponent((String)mimeType, (UIContainer)this);
    }

    public boolean isEnableComment() {
        return false;
    }

    public boolean isEnableVote() {
        return false;
    }

    public void setEnableComment(boolean value) {
    }

    public void setEnableVote(boolean value) {
    }

    public String getInlineEditingField(Node orgNode, String propertyName, String defaultValue, String inputType, String idGenerator, String cssClass, boolean isGenericProperty, String ... arguments) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getInlineEditingField((Node)orgNode, (String)propertyName, (String)defaultValue, (String)inputType, (String)idGenerator, (String)cssClass, (boolean)isGenericProperty, (String[])arguments);
    }

    public String getInlineEditingField(Node orgNode, String propertyName) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getInlineEditingField((Node)orgNode, (String)propertyName);
    }
}

