/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contentvalidation.webui;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.form.DialogFormActionListeners;
import org.exoplatform.ecm.webui.form.UIDialogForm;
import org.exoplatform.ecm.webui.selector.ComponentSelector;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.tree.selectone.UIOneNodePathSelector;
import org.exoplatform.ecm.webui.tree.selectone.UIOneTaxonomySelector;
import org.exoplatform.ecm.webui.utils.DialogFormUtil;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.workflow.webui.component.controller.UITask;
import org.exoplatform.workflow.webui.component.controller.UITaskManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(type=UIFormMultiValueInputSet.class, id="WYSIWYGRichTextMultipleInputset", events={@EventConfig(listeners={UIDialogForm.AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIFormMultiValueInputSet.RemoveActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowComponentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveReferenceActionListener.class}, confirm="DialogFormField.msg.confirm-delete", phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DialogFormActionListeners.RemoveDataActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DialogFormActionListeners.ChangeTabActionListener.class}, phase=Event.Phase.DECODE)})})
public class UIDocumentForm
extends UIDialogForm
implements UIPopupComponent,
UISelectable {
    public static final String FIELD_TAXONOMY = "categories";
    public static final String POPUP_TAXONOMY = "PopupComponent";
    private List<String> listTaxonomyName = new ArrayList<String>();
    private String documentType_;
    private static final Log LOG = ExoLogger.getLogger((String)UIDocumentForm.class.getName());

    public UIDocumentForm() throws Exception {
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public List<String> getlistTaxonomyName() {
        return this.listTaxonomyName;
    }

    public void setListTaxonomyName(List<String> listTaxonomyNameNew) {
        this.listTaxonomyName = listTaxonomyNameNew;
    }

    public void setNodePath(String nodePath) {
        this.nodePath = nodePath;
    }

    public void setTemplateNode(String type) {
        this.documentType_ = type;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public void setWorkspace(String workspace) {
        this.workspaceName = workspace;
    }

    private String getRepository() throws Exception {
        ManageableRepository manaRepo = (ManageableRepository)this.getCurrentNode().getSession().getRepository();
        return manaRepo.getConfiguration().getName();
    }

    public String getTemplate() {
        String userName = Util.getPortalRequestContext().getRemoteUser();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        try {
            return templateService.getTemplatePathByUser(true, this.documentType_, userName);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
            return null;
        }
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        try {
            DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
            String wsName = dmsConfiguration.getConfig().getSystemWorkspace();
            return new JCRResourceResolver(wsName);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
            return super.getTemplateResourceResolver(context, template);
        }
    }

    public Node getCurrentNode() throws Exception {
        return this.getNode();
    }

    public boolean isEditing() {
        return true;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public Node getRootPathTaxonomy(Node node) throws Exception {
        try {
            TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
            List allTaxonomyTrees = taxonomyService.getAllTaxonomyTrees();
            for (Node taxonomyTree : allTaxonomyTrees) {
                if (!node.getPath().startsWith(taxonomyTree.getPath())) continue;
                return taxonomyTree;
            }
            return null;
        }
        catch (AccessDeniedException accessDeniedException) {
            return null;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
            UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
            Object[] arg = new Object[]{this.contentType};
            uiApp.addMessage(new ApplicationMessage("UIDocumentForm.msg.not-support", arg, 0));
            return null;
        }
    }

    public void renderField(String name) throws Exception {
        if (name.equals(FIELD_TAXONOMY) && !this.isUpdateSelect) {
            UIComponent uiInput = this.findComponentById(name);
            TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
            List listCategories = taxonomyService.getAllCategories(this.getCurrentNode());
            for (Node itemNode : listCategories) {
                Node taxonomyTree = this.getRootPathTaxonomy(itemNode);
                if (taxonomyTree == null) continue;
                String categoryPath = itemNode.getPath().replaceAll(taxonomyTree.getPath(), "");
                if (this.getListTaxonomy().contains(taxonomyTree.getName() + categoryPath)) continue;
                this.listTaxonomyName.add(this.getCategoryLabel(taxonomyTree.getName() + categoryPath));
                this.getListTaxonomy().add(taxonomyTree.getName() + categoryPath);
            }
            ((UIFormMultiValueInputSet)uiInput).setValue(this.listTaxonomyName);
        }
        super.renderField(name);
    }

    public void initFieldInput() throws Exception {
        TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
        List listCategories = taxonomyService.getAllCategories(this.getCurrentNode());
        for (Node itemNode : listCategories) {
            Node taxonomyTree = this.getRootPathTaxonomy(itemNode);
            if (taxonomyTree == null) continue;
            String categoryPath = itemNode.getPath().replaceAll(taxonomyTree.getPath(), "");
            if (this.getListTaxonomy().contains(taxonomyTree.getName() + categoryPath)) continue;
            this.listTaxonomyName.add(this.getCategoryLabel(taxonomyTree.getName() + categoryPath));
            this.getListTaxonomy().add(taxonomyTree.getName() + categoryPath);
        }
        UIFormMultiValueInputSet uiFormMultiValue = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
        uiFormMultiValue.setId(FIELD_TAXONOMY);
        uiFormMultiValue.setName(FIELD_TAXONOMY);
        uiFormMultiValue.setType(UIFormStringInput.class);
        uiFormMultiValue.setValue(this.listTaxonomyName);
        uiFormMultiValue.setEditable(false);
        this.addUIFormInput((UIFormInput)uiFormMultiValue);
    }

    public void doSelect(String selectField, Object value) throws Exception {
        this.isUpdateSelect = true;
        UIFormInput formInput = this.getUIInput(selectField);
        if (formInput instanceof UIFormInputBase) {
            ((UIFormInputBase)formInput).setValue((Object)value.toString());
        } else if (formInput instanceof UIFormMultiValueInputSet) {
            UIFormMultiValueInputSet inputSet = (UIFormMultiValueInputSet)formInput;
            String valueTaxonomy = String.valueOf(value).trim();
            List values = inputSet.getValue();
            if (!this.getListTaxonomy().contains(valueTaxonomy)) {
                this.getListTaxonomy().add(valueTaxonomy);
                values.add(this.getCategoryLabel(valueTaxonomy));
            }
            this.listTaxonomyName = values;
            inputSet.setValue(values);
        }
        UITaskManager uiContainer = (UITaskManager)this.getParent();
        uiContainer.removeChildById(POPUP_TAXONOMY);
    }

    private List<String> getAddedListCategory(List<String> taxonomyList, List<String> existingList) {
        ArrayList<String> addedList = new ArrayList<String>();
        for (String addedCategory : taxonomyList) {
            if (existingList.contains(addedCategory)) continue;
            addedList.add(addedCategory);
        }
        return addedList;
    }

    private List<String> getRemovedListCategory(List<String> taxonomyList, List<String> existingList) {
        ArrayList<String> removedList = new ArrayList<String>();
        for (String existedCategory : existingList) {
            if (taxonomyList.contains(existedCategory)) continue;
            removedList.add(existedCategory);
        }
        return removedList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveActionListener
    extends EventListener<UIDocumentForm> {
        public void execute(Event<UIDocumentForm> event) throws Exception {
            UIDocumentForm uiDocumentForm;
            block4: {
                uiDocumentForm = (UIDocumentForm)((Object)event.getSource());
                String objectid = event.getRequestContext().getRequestParameter("objectId");
                String idx = objectid.replaceAll(UIDocumentForm.FIELD_TAXONOMY, "");
                try {
                    int idxInput = Integer.parseInt(idx);
                    uiDocumentForm.getListTaxonomy().remove(idxInput);
                    uiDocumentForm.getlistTaxonomyName().remove(idxInput);
                    uiDocumentForm.setIsUpdateSelect(true);
                }
                catch (NumberFormatException ne) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)ne.getMessage());
                    }
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block4;
                    LOG.warn((Object)e.getMessage());
                }
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDocumentForm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveReferenceActionListener
    extends EventListener<UIDocumentForm> {
        public void execute(Event<UIDocumentForm> event) throws Exception {
            UIDocumentForm uiForm = (UIDocumentForm)((Object)event.getSource());
            uiForm.isRemovePreference = true;
            String fieldName = event.getRequestContext().getRequestParameter("objectId");
            uiForm.getUIStringInput(fieldName).setValue(null);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShowComponentActionListener
    extends EventListener<UIDocumentForm> {
        public void execute(Event<UIDocumentForm> event) throws Exception {
            String[] stringArray;
            UIDocumentForm uiForm = (UIDocumentForm)((Object)event.getSource());
            UITaskManager uiContainer = (UITaskManager)uiForm.getParent();
            uiForm.isShowingComponent = true;
            String fieldName = event.getRequestContext().getRequestParameter("objectId");
            Map fieldPropertiesMap = (Map)uiForm.componentSelectors.get(fieldName);
            String classPath = (String)fieldPropertiesMap.get("selectorClass");
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName(classPath, true, cl);
            String rootPath = (String)fieldPropertiesMap.get("rootPath");
            UIComponent uiComp = uiContainer.createUIComponent(clazz, null, null);
            String selectorParams = (String)fieldPropertiesMap.get("selectorParams");
            if (uiComp instanceof UIOneNodePathSelector) {
                String[] arrParams;
                SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
                String repositoryName = uiForm.getRepository();
                String wsFieldName = (String)fieldPropertiesMap.get("workspaceField");
                String wsName = "";
                if (wsFieldName != null && wsFieldName.length() > 0) {
                    if (uiForm.getUIInput(wsFieldName) != null) {
                        wsName = (String)((UIFormInputBase)uiForm.getUIInput(wsFieldName)).getValue();
                        ((UIOneNodePathSelector)uiComp).setIsDisable(wsName, true);
                    } else {
                        wsName = uiForm.getCurrentNode().getSession().getWorkspace().getName();
                        ((UIOneNodePathSelector)uiComp).setIsDisable(wsName, false);
                    }
                }
                if (selectorParams != null && (arrParams = selectorParams.split(",")).length == 4) {
                    ((UIOneNodePathSelector)uiComp).setAcceptedNodeTypesInPathPanel(new String[]{"nt:file", "nt:folder", "nt:unstructured", "exo:taxonomy"});
                    wsName = arrParams[1];
                    rootPath = arrParams[2];
                    ((UIOneNodePathSelector)uiComp).setIsDisable(wsName, true);
                    if (arrParams[3].indexOf(";") > -1) {
                        ((UIOneNodePathSelector)uiComp).setAcceptedMimeTypes(arrParams[3].split(";"));
                    } else {
                        ((UIOneNodePathSelector)uiComp).setAcceptedMimeTypes(new String[]{arrParams[3]});
                    }
                }
                if (rootPath == null) {
                    rootPath = "/";
                }
                ((UIOneNodePathSelector)uiComp).setRootNodeLocation(repositoryName, wsName, rootPath);
                ((UIOneNodePathSelector)uiComp).setShowRootPathSelect(true);
                ((UIOneNodePathSelector)uiComp).init(sessionProvider);
            } else if (uiComp instanceof UIOneTaxonomySelector) {
                NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)uiForm.getApplicationComponent(NodeHierarchyCreator.class);
                DMSConfiguration dmsConfig = (DMSConfiguration)uiForm.getApplicationComponent(DMSConfiguration.class);
                DMSRepositoryConfiguration dmsRepoConfig = dmsConfig.getConfig();
                String workspaceName = dmsRepoConfig.getSystemWorkspace();
                ((UIOneTaxonomySelector)uiComp).setIsDisable(workspaceName, false);
                String rootTreePath = nodeHierarchyCreator.getJcrPath("exoTaxoTreesStoragePath");
                Session session = uiForm.getSession();
                Node rootTree = (Node)session.getItem(rootTreePath);
                NodeIterator childrenIterator = rootTree.getNodes();
                if (childrenIterator.hasNext()) {
                    Node childNode = childrenIterator.nextNode();
                    rootTreePath = childNode.getPath();
                }
                ((UIOneTaxonomySelector)uiComp).setRootNodeLocation(uiForm.repositoryName, workspaceName, rootTreePath);
                ((UIOneTaxonomySelector)uiComp).init(WCMCoreUtils.getSystemSessionProvider());
            }
            uiContainer.initPopup(uiComp);
            String param = "returnField=" + fieldName;
            if (selectorParams == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = param;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = param;
                stringArray = stringArray3;
                stringArray3[1] = "selectorParams=" + selectorParams;
            }
            String[] params = stringArray;
            ((ComponentSelector)uiComp).setSourceComponent((UIComponent)uiForm, params);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiContainer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UIDocumentForm> {
        public void execute(Event<UIDocumentForm> event) throws Exception {
            UIDocumentForm uiDocumentForm = (UIDocumentForm)((Object)event.getSource());
            UITaskManager uiTaskManager = (UITaskManager)uiDocumentForm.getParent();
            String clickedField = event.getRequestContext().getRequestParameter("objectId");
            if (uiDocumentForm.isReference) {
                UIApplication uiApp = (UIApplication)uiDocumentForm.getAncestorOfType(UIApplication.class);
                try {
                    UIFormMultiValueInputSet uiSet = (UIFormMultiValueInputSet)uiDocumentForm.getChildById(UIDocumentForm.FIELD_TAXONOMY);
                    if (uiSet != null && uiSet.getName() != null && uiSet.getName().equals(UIDocumentForm.FIELD_TAXONOMY) && clickedField != null && clickedField.equals(UIDocumentForm.FIELD_TAXONOMY)) {
                        String repository = ((RepositoryService)uiDocumentForm.getApplicationComponent(RepositoryService.class)).getCurrentRepository().getConfiguration().getName();
                        DMSConfiguration dmsConfig = (DMSConfiguration)uiDocumentForm.getApplicationComponent(DMSConfiguration.class);
                        DMSRepositoryConfiguration dmsRepoConfig = dmsConfig.getConfig();
                        String workspaceName = dmsRepoConfig.getSystemWorkspace();
                        if (uiSet.getValue().size() == 0) {
                            uiSet.setValue(new ArrayList());
                        }
                        UIOneTaxonomySelector uiOneTaxonomySelector = (UIOneTaxonomySelector)uiTaskManager.createUIComponent(UIOneTaxonomySelector.class, null, null);
                        uiOneTaxonomySelector.setIsDisable(workspaceName, false);
                        TaxonomyService taxonomyService = (TaxonomyService)uiDocumentForm.getApplicationComponent(TaxonomyService.class);
                        List lstTaxonomyTree = taxonomyService.getAllTaxonomyTrees();
                        if (lstTaxonomyTree.size() == 0) {
                            throw new AccessDeniedException();
                        }
                        uiOneTaxonomySelector.setRootNodeLocation(repository, workspaceName, ((Node)lstTaxonomyTree.get(0)).getPath());
                        uiOneTaxonomySelector.setExceptedNodeTypesInPathPanel(new String[]{"exo:symlink"});
                        uiOneTaxonomySelector.init(WCMCoreUtils.getSystemSessionProvider());
                        String param = "returnField=categories";
                        uiOneTaxonomySelector.setSourceComponent((UIComponent)uiDocumentForm, new String[]{param});
                        UIPopupWindow uiPopupWindow = (UIPopupWindow)uiTaskManager.getChildById(UIDocumentForm.POPUP_TAXONOMY);
                        if (uiPopupWindow == null) {
                            uiPopupWindow = (UIPopupWindow)uiTaskManager.addChild(UIPopupWindow.class, null, UIDocumentForm.POPUP_TAXONOMY);
                        }
                        uiPopupWindow.setWindowSize(700, 450);
                        uiPopupWindow.setUIComponent((UIComponent)uiOneTaxonomySelector);
                        uiPopupWindow.setRendered(true);
                        uiPopupWindow.setShow(true);
                    }
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaskManager);
                }
                catch (AccessDeniedException accessDeniedException) {
                    uiApp.addMessage(new ApplicationMessage("Taxonomy.msg.AccessDeniedException", null, 1));
                    return;
                }
                catch (Exception e) {
                    JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                    return;
                }
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaskManager);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIDocumentForm> {
        public void execute(Event<UIDocumentForm> event) throws Exception {
            UITaskManager uiTaskManager = (UITaskManager)((UIDocumentForm)((Object)event.getSource())).getParent();
            uiTaskManager.setRenderedChild(UITask.class);
            uiTaskManager.setSelectedTab(((UITask)uiTaskManager.getChild(UITask.class)).getId());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaskManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIDocumentForm> {
        public void execute(Event<UIDocumentForm> event) throws Exception {
            UIFormMultiValueInputSet uiSet;
            UIDocumentForm uiForm = (UIDocumentForm)((Object)event.getSource());
            UITaskManager uiTaskManager = (UITaskManager)uiForm.getAncestorOfType(UITaskManager.class);
            List inputs = uiForm.getChildren();
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            int index = 0;
            boolean hasCategories = false;
            String categoriesPath = "";
            TaxonomyService taxonomyService = (TaxonomyService)uiForm.getApplicationComponent(TaxonomyService.class);
            List listTaxonomy = uiForm.getListTaxonomy();
            if (uiForm.isReference && (uiSet = (UIFormMultiValueInputSet)uiForm.getChildById(UIDocumentForm.FIELD_TAXONOMY)) != null && uiSet.getName() != null && uiSet.getName().equals(UIDocumentForm.FIELD_TAXONOMY)) {
                hasCategories = true;
                for (String category : listTaxonomy) {
                    categoriesPath.concat(category).concat(",");
                }
                if (listTaxonomy != null && listTaxonomy.size() > 0) {
                    try {
                        for (String categoryPath : listTaxonomy) {
                            index = categoryPath.indexOf("/");
                            if (index < 0) {
                                taxonomyService.getTaxonomyTree(categoryPath);
                                continue;
                            }
                            taxonomyService.getTaxonomyTree(categoryPath.substring(0, index)).getNode(categoryPath.substring(index + 1));
                        }
                    }
                    catch (Exception e) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error((Object)"Unexpected error occurs", (Throwable)e);
                        }
                        uiApp.addMessage(new ApplicationMessage("UISelectedCategoriesGrid.msg.non-categories", null, 1));
                        return;
                    }
                }
            }
            Map inputProperties = DialogFormUtil.prepareMap((List)inputs, (Map)uiForm.getInputProperties(), (Map)uiForm.getInputOptions());
            Node homeNode = uiForm.getNode().getParent();
            try {
                CmsService cmsService = (CmsService)uiForm.getApplicationComponent(CmsService.class);
                String addedPath = cmsService.storeNode(uiForm.documentType_, homeNode, inputProperties, false);
                homeNode.getSession().save();
                homeNode.save();
                Node newNode = (Node)homeNode.getSession().getItem(addedPath);
                List listTaxonomyTrees = taxonomyService.getAllTaxonomyTrees();
                List listExistedTaxonomy = taxonomyService.getAllCategories(newNode);
                ArrayList<String> listExistingTaxonomy = new ArrayList<String>();
                block12: for (Node existedTaxonomy : listExistedTaxonomy) {
                    for (Node taxonomyTrees : listTaxonomyTrees) {
                        if (!existedTaxonomy.getPath().contains(taxonomyTrees.getPath())) continue;
                        listExistingTaxonomy.add(taxonomyTrees.getName() + existedTaxonomy.getPath().substring(taxonomyTrees.getPath().length()));
                        continue block12;
                    }
                }
                if (hasCategories && !homeNode.isNodeType("exo:taxonomy")) {
                    for (String removedCate : uiForm.getRemovedListCategory(listTaxonomy, listExistingTaxonomy)) {
                        index = removedCate.indexOf("/");
                        if (index != -1) {
                            taxonomyService.removeCategory(newNode, removedCate.substring(0, index), removedCate.substring(index + 1));
                            continue;
                        }
                        taxonomyService.removeCategory(newNode, removedCate, "");
                    }
                }
                if (hasCategories && newNode != null && listTaxonomy != null && listTaxonomy.size() > 0) {
                    uiForm.releaseLock();
                    for (String categoryPath : uiForm.getAddedListCategory(listTaxonomy, listExistingTaxonomy)) {
                        index = categoryPath.indexOf("/");
                        try {
                            if (index != -1) {
                                taxonomyService.addCategory(newNode, categoryPath.substring(0, index), categoryPath.substring(index + 1));
                                continue;
                            }
                            taxonomyService.addCategory(newNode, categoryPath, "");
                        }
                        catch (AccessDeniedException accessDeniedException) {
                            uiApp.addMessage(new ApplicationMessage("AccessControlException.msg", null, 1));
                        }
                        catch (Exception e) {}
                    }
                } else {
                    ArrayList vals = new ArrayList();
                    if (newNode.hasProperty("exo:category")) {
                        newNode.setProperty("exo:category", vals.toArray(new Value[vals.size()]));
                    }
                    newNode.save();
                }
                uiTaskManager.setSelectedTab(((UITask)uiTaskManager.getChild(UITask.class)).getId());
                uiTaskManager.setRenderedChild(UITask.class);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaskManager);
            }
            catch (AccessControlException ace) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Unexpected error", (Throwable)ace);
                }
                throw new AccessDeniedException(ace.getMessage());
            }
            catch (VersionException ve) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Unexpected error", (Throwable)ve);
                }
                uiApp.addMessage(new ApplicationMessage("UIDocumentForm.msg.in-versioning", null, 1));
                return;
            }
            catch (ConstraintViolationException constraintViolationException) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Unexpected error occurrs", (Throwable)constraintViolationException);
                }
                uiApp.addMessage(new ApplicationMessage("UIDocumentForm.msg.constraintviolation-exception", null, 1));
                return;
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Unexpected error", (Throwable)e);
                }
                String key = "UIDocumentForm.msg.cannot-save";
                uiApp.addMessage(new ApplicationMessage(key, null, 1));
                return;
            }
        }
    }
}

