/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.workflow.impl.bonita;

import java.util.Hashtable;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.exoplatform.services.workflow.Form;

public class FormCache {
    private static final Logger LOG = Logger.getLogger(FormCache.class.getName());
    Hashtable<String, Hashtable<String, Hashtable<Locale, Form>>> forms = new Hashtable();

    public Form getForm(String processId, String activity, Locale locale) {
        Hashtable<String, Hashtable<Locale, Form>> states = this.forms.get(processId);
        if (states == null) {
            return null;
        }
        Hashtable<Locale, Form> locales = states.get(activity);
        if (locales == null) {
            return null;
        }
        return locales.get(locale);
    }

    public void removeForms(String processId) {
        this.forms.remove(processId);
    }

    public void setForm(String processId, String activity, Locale locale, Form form) {
        Hashtable<Locale, Object> locales;
        Hashtable<String, Hashtable<Locale, Object>> states;
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Form will be cached for [process,activity]: [" + processId + "," + activity + "]");
        }
        if ((states = this.forms.get(processId)) == null) {
            states = new Hashtable();
            this.forms.put(processId, states);
        }
        if ((locales = states.get(activity)) == null) {
            locales = new Hashtable();
            states.put(activity, locales);
        }
        locales.put(locale, form);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        for (String processId : this.forms.keySet()) {
            ret.append("Process Id = " + processId + "\n");
            Hashtable<String, Hashtable<Locale, Form>> states = this.forms.get(processId);
            for (String activity : states.keySet()) {
                ret.append("  State Name = " + activity + "\n");
                Hashtable<Locale, Form> locales = states.get(activity);
                for (Locale locale : locales.keySet()) {
                    ret.append("    Locale = " + locale.toString() + "\n");
                }
            }
        }
        return ret.toString();
    }
}

