/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.workflow.impl.bonita;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.workflow.FileDefinition;
import org.exoplatform.services.workflow.Form;
import org.exoplatform.services.workflow.impl.bonita.AutomaticFormImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SpecifiedFormImpl
implements Form {
    private String customizedView;
    private byte[] icon;
    private byte[] stateImageBytes;
    private boolean isDelegatedView;
    private ResourceBundle resourceBundle;
    private String activity;
    private List<Map<String, Object>> submitButtons;
    private List<Map<String, Object>> variables;
    private String message;
    private static final Log LOG = ExoLogger.getLogger((String)SpecifiedFormImpl.class.getName());

    public String getCustomizedView() {
        return this.customizedView;
    }

    public String getIconURL() {
        String url = this.icon != null ? this.publishImage(this.icon) : "";
        return url;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public String getStateImageURL() {
        String url = this.stateImageBytes != null ? this.publishImage(this.stateImageBytes) : "";
        return url;
    }

    public String getStateName() {
        return this.activity;
    }

    public List getSubmitButtons() {
        return this.submitButtons;
    }

    private String publishImage(byte[] image) {
        DownloadService dS = (DownloadService)PortalContainer.getInstance().getComponentInstanceOfType(DownloadService.class);
        ByteArrayInputStream iS = new ByteArrayInputStream(image);
        String id = dS.addDownloadResource((DownloadResource)new InputStreamDownloadResource((InputStream)iS, "image/gif"));
        return dS.getDownloadLink(id);
    }

    public List getVariables() {
        return this.variables;
    }

    public boolean isCustomizedView() {
        return this.customizedView != null && !"".equals(this.customizedView);
    }

    public boolean isDelegatedView() {
        return this.isDelegatedView;
    }

    public SpecifiedFormImpl(String processId, FileDefinition fileDefinition, String activity, Locale locale) {
        block11: {
            this.customizedView = null;
            this.icon = null;
            this.stateImageBytes = null;
            this.isDelegatedView = false;
            this.resourceBundle = null;
            this.activity = null;
            this.customizedView = fileDefinition.getCustomizedView(activity);
            this.isDelegatedView = fileDefinition.isDelegatedView(activity);
            this.resourceBundle = fileDefinition.getResourceBundle(activity, locale);
            if (this.resourceBundle == null) {
                AutomaticFormImpl tmpForm = new AutomaticFormImpl(processId, activity, locale);
                this.resourceBundle = tmpForm.getResourceBundle();
            }
            this.activity = activity;
            this.variables = fileDefinition.getVariables(activity);
            try {
                this.icon = fileDefinition.getEntry(this.activity + "-icon.gif");
            }
            catch (Exception e) {
                this.icon = null;
            }
            try {
                this.stateImageBytes = fileDefinition.getEntry(this.activity + "-state.gif");
            }
            catch (Exception e) {
                this.icon = null;
            }
            this.submitButtons = new ArrayList<Map<String, Object>>();
            if (!"".equals(activity)) {
                ArrayList ret = new ArrayList();
                XPath xPath = XPathFactory.newInstance().newXPath();
                String expression = "/forms/form[state-name=\"" + activity + "\"]/submitbutton";
                try {
                    NodeList nodeSet = (NodeList)xPath.evaluate(expression, this.getFormsDefinition(fileDefinition), XPathConstants.NODESET);
                    for (int i = 0; i < nodeSet.getLength(); ++i) {
                        HashMap<String, String> attributes = new HashMap<String, String>();
                        Element element = (Element)nodeSet.item(i);
                        Attr component = element.getAttributeNode("variable");
                        if (component != null) {
                            attributes.put("variable", component.getValue());
                        }
                        if ((component = element.getAttributeNode("name")) != null) {
                            attributes.put("name", component.getValue());
                        }
                        attributes.put("transition", "");
                        this.submitButtons.add(attributes);
                    }
                }
                catch (XPathExpressionException e) {
                    if (!LOG.isWarnEnabled()) break block11;
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public String getMessage() {
        return this.message;
    }

    public boolean hasMessage() {
        boolean out = false;
        if (this.message != null) {
            out = !this.message.trim().equals("");
        }
        return out;
    }

    public Element getFormsDefinition(FileDefinition f) {
        Element ret;
        block5: {
            ret = null;
            try {
                byte[] xpdlDefinition = f.getEntry("forms.xml");
                try {
                    Element formDefinition;
                    if (xpdlDefinition == null) {
                        throw new Exception("The XPDL definition file was not retrieved.");
                    }
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(xpdlDefinition);
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    ret = formDefinition = builder.parse(inputStream).getDocumentElement();
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while parsing the XPDL Definition", e);
                }
            }
            catch (Exception e1) {
                if (!LOG.isWarnEnabled()) break block5;
                LOG.warn((Object)e1.getMessage(), (Throwable)e1);
            }
        }
        return ret;
    }
}

